set counter 0
proc Space {height} {
  global counter
  incr counter
  Frame Label-$counter -frame:height $height
  return Label-$counter
}
proc Hspace {width} {
  global counter
  incr counter
  Frame Label-$counter -frame:width $width -packFrame:expand 0
  return Label-$counter
}
     
proc convertTilde {file} {
  set file [string trim $file]
  regsub -- {^(~/)} $file {$HOME/} file
  regsub -- {^~([^/])} $file {/home/\1} file
  return $file
}

proc getUserName {} {
  if {[catch "exec whoami"]} {
    return ""
  } else {
    set user [exec whoami]
  }
  if {[catch "exec hostname -d"]} {
    if {[catch "exec domainname"]} {
      return ""
    } else {
      set domain [exec domainname]
    }
  } else {
    set domain [exec hostname -d]
  }
  return $user@$domain
}
proc dotfile_advertisment {} {
  global argv
  set w [makeTempWindow "Dotfile Generator Advertisment"]
  label $w.thanks \
      -text "It would be of great help to the Dotfile Generator, if you would append a help message in your automatic replys. It look like below." \
      -wraplength 400 -justify left
  pack $w.thanks

  set FILE [open [lindex $argv 1]/TDG-advertisment]
  set advertisment [read $FILE]
  close $FILE
  label $w.advertisment -text "
>>>>>>>>>>>>>>>>> START >>>>>>>>>>>>>>>>>>>    
$advertisment\
<<<<<<<<<<<<<<<<< END <<<<<<<<<<<<<<<<<<<<<" -justify left
  pack $w.advertisment

  button $w.ok -text "OK" -command "destroy $w"
  pack $w.ok -side right -expand 0 -fill x
}
proc dateWidget {prefix} {
    Radio ${prefix}_dateInfo \
      -text "What Information"\
      -entries {Year Month Day "Week number"}

  Line ${prefix}_datel1
  Radio ${prefix}_digit \
      -text "Number of digets in year"\
      -entries 2 4\
      -packLabel:side left

  Line ${prefix}_datel2
  Radio ${prefix}_monthFormat \
      -text "Month format (August)"\
      -entries 08 Aug August 

  Line ${prefix}_datel3
  Radio ${prefix}_dayFormat \
      -text "Day/week format" \
      -entries {Monday Mon "day of week" "day of month"}

  ##################################################
  ###          Help for Date
  ##################################################
  Help ${prefix}_digit\
      "Should the year be represented with 2 or 4 digits? Ie.  should"\
      "1997 be written as 1997 or just 97? (Remember year 2000!)"
  Help ${prefix}_monthFormat\
      "How should the month be represented?  with the number of the"\
      "month, the short name of the month or the long name of the"\
      "month."
  Help ${prefix}_dayFormat\
      "Here you may select which format should be used for the current"\
      "day or week."

}

proc splitMessage {message} {
  set result {}
  set line ""
  set maxlen 70
  while {$message != ""} {
    set newline 0
    set index [string first " " $message]
    set index2 [string first "\n" $message]
    if {$index2<$index && $index2 != -1} {
      set index $index2
      set newline 1
    }
    if {$index == -1} {
      set next $message
      set message ""
    } else {
      set next [string range $message 0 [expr $index-1]]
      set message [string range $message [expr $index+1] end]
    }
    if {[string length $line] + [string length $next] > $maxlen} {
      lappend result $line
      set line $next
    } else {
      if {[string length $line] == 0} {
        set line $next
      } else {
        append line " $next"
      }
      if {$newline} {
        lappend result $line
        set line ""
      }
    }
  }
  lappend result [string trimright $line]
  return $result
}

proc testPattern {head pat} {
  set w [makeTempWindow "Test pattern"]
  pushGrab local $w

  label $w.1 -text Header
  label $w.2 -text Body
  frame $w.f1 
  text $w.f1.text -height 10 -yscrollcommand "$w.f1.scroll set"
  scrollbar $w.f1.scroll -command "$w.f1.text yview"
  frame $w.f2 
  text $w.f2.text -yscrollcommand "$w.f2.scroll set"
  scrollbar $w.f2.scroll -command "$w.f2.text yview"

  frame $w.buts
  button $w.buts.quit -text "Quit" -command "destroy $w"
  button $w.buts.reset -text Clear -command \
      "$w.f1.text delete 1.0 end;$w.f2.text delete 1.0 end"
  button $w.buts.test -text "Test It" \
      -command "testItNow \"$head\" \"$pat\" $w.f1.text $w.f2.text"

  pack $w.1 $w.f1 $w.2 $w.f2 $w.buts -fill x -expand 1
  pack $w.f1.text -side left -fill both -expand 1
  pack $w.f1.scroll -fill y -expand 1
  pack $w.f2.text -side left -fill both -expand 1
  pack $w.f2.scroll -fill y -expand 1
  pack $w.buts.reset $w.buts.test $w.buts.quit -side right -anchor e

  tkwait window $w
  popGrab
}

proc protect {txt} {
  regsub -all -- {'} $txt {'"'"'} txt
  return $txt
}
proc protectForQuoting {txt} {
  regsub -all -- {"} $txt {"'"'"} txt
  return $txt
}

##################################################
# I Can not get this to work :-(
##################################################
proc testItNow {head pat headText patText} {
  global __system

  switch $head {
    "Body of letter" {
      set pattern $pat
    }
    "Sendmail from" {
      set pattern "^from +$pat"
    }
    TO -
    FROM_DEAMON -
    FROM_MAILER {
      set pattern "^$head$pat"
    }
    default {
      set pattern "^$head:$pat"
    }
  }

  for {set i [expr [string length $pattern]-1]} {$i>0} {incr i -1} {
    puts "|$__system(egrep) -i [string range $pattern 0 $i]"
    set pipe [open "|$__system(egrep) -iq [string range $pattern 0 $i] > /dev/null" a]
    puts $pipe [$headText get 1.0 end]
    puts [$headText get 1.0 end]
    if {![catch close $pipe]} break
  }
  puts "Matched: [string range $pattern 0 $i]"
}

proc printSave {args} {
  global thisCmds
  print [join $args]
  append thisCmds "[join $args]\n"
}
