/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.ObjectIdentityWrapper;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.io.VMObjectInputStream;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private static boolean dump;
    private static final boolean DEBUG = false;
    private DataInputStream realInputStream;
    private DataInputStream dataInputStream;
    private DataInputStream blockDataInput;
    private int blockDataPosition;
    private int blockDataBytes;
    private byte[] blockData;
    private boolean useSubclassMethod;
    private int nextOID;
    private boolean resolveEnabled;
    private Hashtable objectLookupTable;
    private Object currentObject;
    private ObjectStreamClass currentObjectStreamClass;
    private TreeSet currentObjectValidators;
    private boolean readDataFromBlock;
    private boolean fieldsAlreadyRead;
    private Hashtable classLookupTable;
    private GetField prereadFields;
    private int depth;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object readObject() throws ClassNotFoundException, IOException {
        Object ret_val;
        if (this.useSubclassMethod) {
            return this.readObjectOverride();
        }
        boolean old_mode = this.setBlockDataMode(false);
        byte marker = this.realInputStream.readByte();
        if (dump) {
            this.dumpElement("MARKER: 0x" + Integer.toHexString(marker) + ' ');
        }
        try {
            ret_val = this.parseContent(marker);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setBlockDataMode(old_mode);
            throw throwable;
        }
        {
            Object var5_6 = null;
            this.setBlockDataMode(old_mode);
        }
        return ret_val;
    }

    private final Object parseContent(byte marker) throws ClassNotFoundException, IOException {
        Object ret_val;
        boolean is_consumed = false;
        switch (marker) {
            case 120: {
                ret_val = null;
                is_consumed = true;
                break;
            }
            case 119: 
            case 122: {
                if (marker == 122) {
                    if (dump) {
                        this.dumpElementln("BLOCKDATALONG");
                    }
                } else if (dump) {
                    this.dumpElementln("BLOCKDATA");
                }
                this.readNextBlock(marker);
            }
            case 112: {
                if (dump) {
                    this.dumpElementln("NULL");
                }
                ret_val = null;
                break;
            }
            case 113: {
                if (dump) {
                    this.dumpElement("REFERENCE ");
                }
                Integer oid = new Integer(this.realInputStream.readInt());
                if (dump) {
                    this.dumpElementln(Integer.toHexString(oid));
                }
                ret_val = ((ObjectIdentityWrapper)this.objectLookupTable.get((Object)oid)).object;
                break;
            }
            case 118: {
                if (dump) {
                    this.dumpElementln("CLASS");
                }
                ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                Class clazz = osc.forClass();
                this.assignNewHandle(clazz);
                ret_val = clazz;
                break;
            }
            case 125: {
                if (dump) {
                    this.dumpElementln("PROXYCLASS");
                }
                int n_intf = this.realInputStream.readInt();
                String[] intfs = new String[n_intf];
                int i = 0;
                while (i < n_intf) {
                    intfs[i] = this.realInputStream.readUTF();
                    ++i;
                }
                boolean oldmode = this.setBlockDataMode(true);
                Class cl = this.resolveProxyClass(intfs);
                this.setBlockDataMode(oldmode);
                ObjectStreamClass osc = this.lookupClass(cl);
                if (osc.firstNonSerializableParentConstructor == null) {
                    osc.realClassIsSerializable = true;
                    osc.fieldMapping = new ObjectStreamField[0];
                    osc.fields = osc.fieldMapping;
                    try {
                        Class clazz = class$java$lang$Object;
                        if (clazz == null) {
                            clazz = class$java$lang$Object = ObjectInputStream.class("[Ljava.lang.Object;", false);
                        }
                        osc.firstNonSerializableParentConstructor = clazz.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException x) {
                        throw (InternalError)new InternalError("Object ctor missing").initCause(x);
                    }
                }
                this.assignNewHandle(osc);
                if (!is_consumed) {
                    byte b = this.realInputStream.readByte();
                    if (b != 120) {
                        throw new IOException("Data annotated to class was not consumed." + b);
                    }
                } else {
                    is_consumed = false;
                }
                ObjectStreamClass superosc = (ObjectStreamClass)this.readObject();
                osc.setSuperclass(superosc);
                ret_val = osc;
                break;
            }
            case 114: {
                ObjectStreamClass osc = this.readClassDescriptor();
                if (!is_consumed) {
                    byte b = this.realInputStream.readByte();
                    if (b != 120) {
                        throw new IOException("Data annotated to class was not consumed." + b);
                    }
                } else {
                    is_consumed = false;
                }
                osc.setSuperclass((ObjectStreamClass)this.readObject());
                ret_val = osc;
                break;
            }
            case 116: 
            case 124: {
                if (dump) {
                    this.dumpElement("STRING=");
                }
                String s = this.realInputStream.readUTF();
                if (dump) {
                    this.dumpElementln(s);
                }
                ret_val = this.processResolution(null, s, this.assignNewHandle(s));
                break;
            }
            case 117: {
                if (dump) {
                    this.dumpElementln("ARRAY");
                }
                ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                Class componentType = osc.forClass().getComponentType();
                if (dump) {
                    this.dumpElement("ARRAY LENGTH=");
                }
                int length = this.realInputStream.readInt();
                if (dump) {
                    this.dumpElementln(length + "; COMPONENT TYPE=" + componentType);
                }
                Object array = Array.newInstance(componentType, length);
                int handle = this.assignNewHandle(array);
                this.readArrayElements(array, componentType);
                if (dump) {
                    int i = 0;
                    int len = Array.getLength(array);
                    while (i < len) {
                        this.dumpElementln("  ELEMENT[" + i + "]=" + Array.get(array, i));
                        ++i;
                    }
                }
                ret_val = this.processResolution(null, array, handle);
                break;
            }
            case 115: {
                if (dump) {
                    this.dumpElementln("OBJECT");
                }
                ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                Class clazz = osc.forClass();
                if (!osc.realClassIsSerializable) {
                    throw new NotSerializableException(clazz + " is not Serializable, and thus cannot be deserialized.");
                }
                if (osc.realClassIsExternalizable) {
                    Externalizable obj = osc.newInstance();
                    int handle = this.assignNewHandle(obj);
                    boolean bl = false;
                    if ((osc.getFlags() & 8) != 0) {
                        bl = true;
                    }
                    boolean read_from_blocks = bl;
                    boolean oldmode = this.readDataFromBlock;
                    if (read_from_blocks) {
                        this.setBlockDataMode(true);
                    }
                    obj.readExternal(this);
                    if (read_from_blocks) {
                        this.setBlockDataMode(oldmode);
                        if (!oldmode && this.realInputStream.readByte() != 120) {
                            throw new IOException("No end of block data seen for class with readExternal (ObjectInputStream) method.");
                        }
                    }
                    ret_val = this.processResolution(osc, obj, handle);
                    break;
                }
                Object obj = this.newObject(clazz, osc.firstNonSerializableParentConstructor);
                int handle = this.assignNewHandle(obj);
                Object prevObject = this.currentObject;
                ObjectStreamClass prevObjectStreamClass = this.currentObjectStreamClass;
                TreeSet prevObjectValidators = this.currentObjectValidators;
                this.currentObject = obj;
                this.currentObjectValidators = null;
                ObjectStreamClass[] hierarchy = this.inputGetObjectStreamClasses(clazz);
                int i = 0;
                while (i < hierarchy.length) {
                    Method readObjectMethod;
                    this.currentObjectStreamClass = hierarchy[i];
                    if (dump) {
                        this.dumpElementln("Reading fields of " + this.currentObjectStreamClass.getName());
                    }
                    if ((readObjectMethod = this.currentObjectStreamClass.readObjectMethod) != null) {
                        this.fieldsAlreadyRead = false;
                        boolean oldmode = this.setBlockDataMode(true);
                        this.callReadMethod(readObjectMethod, this.currentObjectStreamClass.forClass(), obj);
                        this.setBlockDataMode(oldmode);
                    } else {
                        this.readFields(obj, this.currentObjectStreamClass);
                    }
                    if (this.currentObjectStreamClass.hasWriteMethod()) {
                        if (dump) {
                            this.dumpElement("ENDBLOCKDATA? ");
                        }
                        try {
                            byte writeMarker = this.realInputStream.readByte();
                            while (writeMarker != 120) {
                                this.parseContent(writeMarker);
                                writeMarker = this.realInputStream.readByte();
                            }
                            if (dump) {
                                this.dumpElementln("yes");
                            }
                        }
                        catch (EOFException e) {
                            throw (IOException)new IOException("No end of block data seen for class with readObject (ObjectInputStream) method.").initCause(e);
                        }
                    }
                    ++i;
                }
                this.currentObject = prevObject;
                this.currentObjectStreamClass = prevObjectStreamClass;
                ret_val = this.processResolution(osc, obj, handle);
                if (this.currentObjectValidators != null) {
                    this.invokeValidators();
                }
                this.currentObjectValidators = prevObjectValidators;
                break;
            }
            case 121: {
                if (dump) {
                    this.dumpElementln("RESET");
                }
                this.clearHandles();
                ret_val = this.readObject();
                break;
            }
            case 123: {
                if (dump) {
                    this.dumpElement("EXCEPTION=");
                }
                Exception e = (Exception)this.readObject();
                if (dump) {
                    this.dumpElementln(e.toString());
                }
                this.clearHandles();
                throw new WriteAbortedException("Exception thrown during writing of stream", e);
            }
            default: {
                throw new IOException("Unknown marker on stream: " + marker);
            }
        }
        return ret_val;
    }

    private final void checkTypeConsistency(String name, ObjectStreamField[] fields1, ObjectStreamField[] fields2) throws InvalidClassException {
        int nonPrimitive = 0;
        nonPrimitive = 0;
        while (nonPrimitive < fields1.length && fields1[nonPrimitive].isPrimitive()) {
            ++nonPrimitive;
        }
        if (nonPrimitive == fields1.length) {
            return;
        }
        int i = 0;
        while (i < fields2.length && nonPrimitive < fields1.length) {
            ObjectStreamField f1 = fields1[nonPrimitive];
            ObjectStreamField f2 = fields2[i];
            if (!f2.isPrimitive()) break;
            int compVal = f1.getName().compareTo(f2.getName());
            if (compVal < 0) {
                ++nonPrimitive;
                continue;
            }
            if (compVal > 0) {
                ++i;
                continue;
            }
            throw new InvalidClassException("invalid field type for " + f2.getName() + " in class " + name);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected ObjectStreamClass readClassDescriptor() throws ClassNotFoundException, IOException {
        block23: {
            if (ObjectInputStream.dump) {
                this.dumpElement("CLASSDESC NAME=");
            }
            name = this.realInputStream.readUTF();
            if (ObjectInputStream.dump) {
                this.dumpElement(name + "; UID=");
            }
            uid = this.realInputStream.readLong();
            if (ObjectInputStream.dump) {
                this.dumpElement(Long.toHexString(uid) + "; FLAGS=");
            }
            flags = this.realInputStream.readByte();
            if (ObjectInputStream.dump) {
                this.dumpElement(Integer.toHexString(flags) + "; FIELD COUNT=");
            }
            field_count = this.realInputStream.readShort();
            if (ObjectInputStream.dump) {
                this.dumpElementln(Short.toString((short)field_count));
            }
            fields = new ObjectStreamField[field_count];
            osc = new ObjectStreamClass(name, uid, flags, fields);
            this.assignNewHandle(osc);
            callersClassLoader = this.currentLoader();
            i = 0;
            while (i < field_count) {
                if (ObjectInputStream.dump) {
                    this.dumpElement("  TYPE CODE=");
                }
                type_code = (char)this.realInputStream.readByte();
                if (ObjectInputStream.dump) {
                    this.dumpElement(type_code + "; FIELD NAME=");
                }
                field_name = this.realInputStream.readUTF();
                if (ObjectInputStream.dump) {
                    this.dumpElementln(field_name);
                }
                class_name = type_code == 'L' || type_code == '[' ? (String)this.readObject() : String.valueOf(type_code);
                fields[i] = new ObjectStreamField(field_name, class_name, callersClassLoader);
                ++i;
            }
            clazz = this.resolveClass(osc);
            oldmode = this.setBlockDataMode(true);
            osc.setClass(clazz, this.lookupClass(clazz.getSuperclass()));
            this.classLookupTable.put(clazz, osc);
            this.setBlockDataMode(oldmode);
            first_nonserial = clazz.getSuperclass();
            if (first_nonserial != null) ** GOTO lbl46
            first_nonserial = clazz;
            break block23;
lbl-1000:
            // 1 sources

            {
                first_nonserial = first_nonserial.getSuperclass();
lbl46:
                // 2 sources

                if ((v0 = ObjectInputStream.class$java$io$Serializable) != null) continue;
                v0 = ObjectInputStream.class("[Ljava.io.Serializable;", false);
                ** while (v0.isAssignableFrom((Class)first_nonserial) || Modifier.isAbstract((int)first_nonserial.getModifiers()))
            }
        }
        local_constructor_class = first_nonserial;
        osc.firstNonSerializableParentConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - void declaration
             */
            public final Object run() {
                try {
                    void e;
                    Constructor c = local_constructor_class.getDeclaredConstructor(new Class[0]);
                    if (Modifier.isPrivate(c.getModifiers())) {
                        return null;
                    }
                    return e;
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
        v1 = ObjectInputStream.class$java$io$Serializable;
        if (v1 == null) {
            v1 = ObjectInputStream.class$java$io$Serializable = ObjectInputStream.class("[Ljava.io.Serializable;", false);
        }
        osc.realClassIsSerializable = v1.isAssignableFrom(clazz);
        v2 = ObjectInputStream.class$java$io$Externalizable;
        if (v2 == null) {
            v2 = ObjectInputStream.class$java$io$Externalizable = ObjectInputStream.class("[Ljava.io.Externalizable;", false);
        }
        osc.realClassIsExternalizable = v2.isAssignableFrom(clazz);
        stream_fields = osc.fields;
        real_fields = ObjectStreamClass.lookupForClassObject((Class)clazz).fields;
        fieldmapping = new ObjectStreamField[2 * Math.max(stream_fields.length, real_fields.length)];
        stream_idx = 0;
        real_idx = 0;
        map_idx = 0;
        this.checkTypeConsistency(name, real_fields, stream_fields);
        this.checkTypeConsistency(name, stream_fields, real_fields);
        while (stream_idx < stream_fields.length || real_idx < real_fields.length) {
            stream_field = null;
            real_field = null;
            if (stream_idx == stream_fields.length) {
                real_field = real_fields[real_idx++];
            } else if (real_idx == real_fields.length) {
                stream_field = stream_fields[stream_idx++];
            } else {
                comp_val = real_fields[real_idx].compareTo(stream_fields[stream_idx]);
                if (comp_val < 0) {
                    real_field = real_fields[real_idx++];
                } else if (comp_val > 0) {
                    stream_field = stream_fields[stream_idx++];
                } else {
                    stream_field = stream_fields[stream_idx++];
                    real_field = real_fields[real_idx++];
                    if (stream_field.getType() != real_field.getType()) {
                        throw new InvalidClassException("invalid field type for " + real_field.getName() + " in class " + name);
                    }
                }
            }
            if (map_idx == fieldmapping.length) {
                newfieldmapping = new ObjectStreamField[fieldmapping.length + 2];
                System.arraycopy(fieldmapping, 0, newfieldmapping, 0, fieldmapping.length);
                fieldmapping = newfieldmapping;
            }
            fieldmapping[map_idx++] = stream_field;
            fieldmapping[map_idx++] = real_field;
        }
        osc.fieldMapping = fieldmapping;
        return osc;
    }

    public void defaultReadObject() throws ClassNotFoundException, IOException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultReadObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("defaultReadObject called but fields already read from stream (by defaultReadObject or readFields)");
        }
        boolean oldmode = this.setBlockDataMode(false);
        this.readFields(this.currentObject, this.currentObjectStreamClass);
        this.setBlockDataMode(oldmode);
        this.fieldsAlreadyRead = true;
    }

    public void registerValidation(ObjectInputValidation validator, int priority) throws InvalidObjectException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("registerValidation called by non-active class and/or object");
        }
        if (validator == null) {
            throw new InvalidObjectException("attempt to add a null ObjectInputValidation object");
        }
        if (this.currentObjectValidators == null) {
            this.currentObjectValidators = new TreeSet();
        }
        this.currentObjectValidators.add(new ValidatorAndPriority(validator, priority));
    }

    protected Class resolveClass(ObjectStreamClass osc) throws ClassNotFoundException, IOException {
        String name = osc.getName();
        try {
            return Class.forName(name, true, this.currentLoader());
        }
        catch (ClassNotFoundException x) {
            if (name.equals("void")) {
                return Void.TYPE;
            }
            if (name.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (name.equals("byte")) {
                return Byte.TYPE;
            }
            if (name.equals("char")) {
                return Character.TYPE;
            }
            if (name.equals("short")) {
                return Short.TYPE;
            }
            if (name.equals("int")) {
                return Integer.TYPE;
            }
            if (name.equals("long")) {
                return Long.TYPE;
            }
            if (name.equals("float")) {
                return Float.TYPE;
            }
            if (name.equals("double")) {
                return Double.TYPE;
            }
            throw x;
        }
    }

    private final ClassLoader currentLoader() {
        ClassLoader cl = VMObjectInputStream.currentClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    private final ObjectStreamClass lookupClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ObjectStreamClass oclazz = (ObjectStreamClass)this.classLookupTable.get(clazz);
        if (oclazz == null) {
            return ObjectStreamClass.lookup(clazz);
        }
        return oclazz;
    }

    private final ObjectStreamClass[] inputGetObjectStreamClasses(Class clazz) {
        ObjectStreamClass osc = this.lookupClass(clazz);
        if (osc == null) {
            return new ObjectStreamClass[0];
        }
        Vector oscs = new Vector();
        while (osc != null) {
            oscs.addElement(osc);
            osc = osc.getSuper();
        }
        int count = oscs.size();
        ObjectStreamClass[] sorted_oscs = new ObjectStreamClass[count];
        int i = count - 1;
        while (i >= 0) {
            sorted_oscs[count - i - 1] = (ObjectStreamClass)oscs.elementAt(i);
            --i;
        }
        return sorted_oscs;
    }

    protected Object resolveObject(Object obj) throws IOException {
        return obj;
    }

    protected Class resolveProxyClass(String[] intfs) throws IOException, ClassNotFoundException {
        int i;
        ClassLoader cl = this.currentLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        Class[] clss = new Class[intfs.length];
        if (cl == null) {
            i = 0;
            while (i < intfs.length) {
                clss[i] = Class.forName(intfs[i]);
                ++i;
            }
            cl = ClassLoader.getSystemClassLoader();
        } else {
            i = 0;
            while (i < intfs.length) {
                clss[i] = Class.forName(intfs[i], false, cl);
                ++i;
            }
        }
        try {
            return Proxy.getProxyClass(cl, clss);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    protected boolean enableResolveObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SerializablePermission("enableSubstitution"));
        }
        boolean old_val = this.resolveEnabled;
        this.resolveEnabled = enable;
        return old_val;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        if (dump) {
            this.dumpElement("STREAM MAGIC ");
        }
        if (this.realInputStream.readShort() != -21267) {
            throw new StreamCorruptedException("Invalid stream magic number");
        }
        if (dump) {
            this.dumpElementln("STREAM VERSION ");
        }
        if (this.realInputStream.readShort() != 5) {
            throw new StreamCorruptedException("Invalid stream version number");
        }
    }

    public int read() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockData[this.blockDataPosition++] & 0xFF;
        }
        return this.realInputStream.read();
    }

    public int read(byte[] data, int offset, int length) throws IOException {
        if (this.readDataFromBlock) {
            int remain = this.blockDataBytes - this.blockDataPosition;
            if (remain == 0) {
                this.readNextBlock();
                remain = this.blockDataBytes - this.blockDataPosition;
            }
            length = Math.min(length, remain);
            System.arraycopy(this.blockData, this.blockDataPosition, data, offset, length);
            this.blockDataPosition += length;
            return length;
        }
        return this.realInputStream.read(data, offset, length);
    }

    public int available() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockDataBytes - this.blockDataPosition;
        }
        return this.realInputStream.available();
    }

    public void close() throws IOException {
        this.realInputStream.close();
    }

    public boolean readBoolean() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 1) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        boolean value = this.dataInputStream.readBoolean();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    public byte readByte() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 1) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        byte value = this.dataInputStream.readByte();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    public int readUnsignedByte() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 1) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        int value = this.dataInputStream.readUnsignedByte();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    public short readShort() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 2) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        short value = this.dataInputStream.readShort();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    public int readUnsignedShort() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 2) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        int value = this.dataInputStream.readUnsignedShort();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    public char readChar() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 2) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        char value = this.dataInputStream.readChar();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    public int readInt() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 4) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        int value = this.dataInputStream.readInt();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    public long readLong() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 8) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        long value = this.dataInputStream.readLong();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    public float readFloat() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 4) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        float value = this.dataInputStream.readFloat();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    public double readDouble() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 8) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        double value = this.dataInputStream.readDouble();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    public void readFully(byte[] data) throws IOException {
        this.dataInputStream.readFully(data);
    }

    public void readFully(byte[] data, int offset, int size) throws IOException {
        this.dataInputStream.readFully(data, offset, size);
    }

    public int skipBytes(int len) throws IOException {
        return this.dataInputStream.skipBytes(len);
    }

    public String readLine() throws IOException {
        return this.dataInputStream.readLine();
    }

    public String readUTF() throws IOException {
        return this.dataInputStream.readUTF();
    }

    public GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("readFields called by non-active class and/or object");
        }
        if (this.prereadFields != null) {
            return this.prereadFields;
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("readFields called but fields already read from stream (by defaultReadObject or readFields)");
        }
        final ObjectStreamClass clazz = this.currentObjectStreamClass;
        final byte[] prim_field_data = new byte[clazz.primFieldSize];
        final Object[] objs = new Object[clazz.objectFieldCount];
        boolean oldmode = this.setBlockDataMode(false);
        this.readFully(prim_field_data);
        int i = 0;
        while (i < objs.length) {
            objs[i] = this.readObject();
            ++i;
        }
        this.setBlockDataMode(oldmode);
        this.prereadFields = new GetField(){

            public final ObjectStreamClass getObjectStreamClass() {
                return clazz;
            }

            public final boolean defaulted(String name) throws IOException, IllegalArgumentException {
                ObjectStreamField f = clazz.getField(name);
                if (f != null) {
                    return f.isPersistent() && !f.isToSet();
                }
                try {
                    boolean bl = false;
                    if (clazz.forClass().getDeclaredField(name) != null) {
                        bl = true;
                    }
                    return bl;
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public final boolean get(String name, boolean defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Boolean.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int n = 0;
                if (prim_field_data[field.getOffset()] == 0) {
                    n = 1;
                }
                return 1 - n;
            }

            public final char get(String name, char defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Character.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return (char)((prim_field_data[off++] & 0xFF) << 8 | prim_field_data[off] & 0xFF);
            }

            public final byte get(String name, byte defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Byte.TYPE);
                if (field == null) {
                    return defvalue;
                }
                return prim_field_data[field.getOffset()];
            }

            public final short get(String name, short defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Short.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return (short)((prim_field_data[off++] & 0xFF) << 8 | prim_field_data[off] & 0xFF);
            }

            public final int get(String name, int defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Integer.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return (prim_field_data[off++] & 0xFF) << 24 | (prim_field_data[off++] & 0xFF) << 16 | (prim_field_data[off++] & 0xFF) << 8 | prim_field_data[off] & 0xFF;
            }

            public final long get(String name, long defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Long.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return ((long)prim_field_data[off++] & 0xFFL) << 56 | ((long)prim_field_data[off++] & 0xFFL) << 48 | ((long)prim_field_data[off++] & 0xFFL) << 40 | ((long)prim_field_data[off++] & 0xFFL) << 32 | (long)((prim_field_data[off++] & 0xFF) << 24) | (long)((prim_field_data[off++] & 0xFF) << 16) | (long)((prim_field_data[off++] & 0xFF) << 8) | (long)(prim_field_data[off] & 0xFF);
            }

            public final float get(String name, float defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Float.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return Float.intBitsToFloat((prim_field_data[off++] & 0xFF) << 24 | (prim_field_data[off++] & 0xFF) << 16 | (prim_field_data[off++] & 0xFF) << 8 | prim_field_data[off] & 0xFF);
            }

            public final double get(String name, double defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Double.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return Double.longBitsToDouble(((long)prim_field_data[off++] & 0xFFL) << 56 | ((long)prim_field_data[off++] & 0xFFL) << 48 | ((long)prim_field_data[off++] & 0xFFL) << 40 | ((long)prim_field_data[off++] & 0xFFL) << 32 | (long)((prim_field_data[off++] & 0xFF) << 24) | (long)((prim_field_data[off++] & 0xFF) << 16) | (long)((prim_field_data[off++] & 0xFF) << 8) | (long)(prim_field_data[off] & 0xFF));
            }

            public final Object get(String name, Object defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, defvalue == null ? null : defvalue.getClass());
                if (field == null) {
                    return defvalue;
                }
                return objs[field.getOffset()];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private final ObjectStreamField getField(String name, Class type) throws IllegalArgumentException {
                ObjectStreamField objectStreamField;
                ObjectStreamField field;
                block18: {
                    field = clazz.getField(name);
                    boolean illegal = false;
                    try {
                        Class field_type;
                        block16: {
                            field_type = field.getType();
                            if (type != field_type && (type != null || field_type.isPrimitive())) break block16;
                            ObjectStreamField objectStreamField2 = field;
                            Object var6_10 = null;
                            if (!illegal && field != null && !field.isToSet() && field.isPersistent()) {
                                return null;
                            }
                            try {
                                Field f = clazz.forClass().getDeclaredField(name);
                                if (Modifier.isTransient(f.getModifiers())) {
                                    throw new IllegalArgumentException("no such field (non transient) " + name);
                                }
                                if (field != null) return objectStreamField2;
                                if (f.getType() == type) return objectStreamField2;
                                throw new IllegalArgumentException("Invalid requested type for field " + name);
                            }
                            catch (NoSuchFieldException e) {
                                if (field != null) return objectStreamField2;
                                throw new IllegalArgumentException(e);
                            }
                        }
                        try {
                            String string;
                            illegal = true;
                            StringBuffer stringBuffer = new StringBuffer("Field requested is of type ").append(field_type.getName()).append(", but requested type was ");
                            if (type == null) {
                                string = "Object";
                                throw new IllegalArgumentException(stringBuffer.append(string).toString());
                            }
                            string = type.getName();
                            throw new IllegalArgumentException(stringBuffer.append(string).toString());
                        }
                        catch (NullPointerException _) {
                        }
                        catch (IllegalArgumentException e) {
                            throw e;
                        }
                        objectStreamField = null;
                        Object var6_11 = null;
                        if (illegal || field == null || field.isToSet() || !field.isPersistent()) break block18;
                        return null;
                    }
                    catch (Throwable throwable) {
                        Object var6_12 = null;
                        if (!illegal && field != null && !field.isToSet() && field.isPersistent()) {
                            return null;
                        }
                        try {}
                        catch (NoSuchFieldException e) {
                            if (field != null) throw throwable;
                            throw new IllegalArgumentException(e);
                        }
                        Field f = clazz.forClass().getDeclaredField(name);
                        if (Modifier.isTransient(f.getModifiers())) {
                            throw new IllegalArgumentException("no such field (non transient) " + name);
                        }
                        if (field != null) throw throwable;
                        if (f.getType() == type) throw throwable;
                        throw new IllegalArgumentException("Invalid requested type for field " + name);
                    }
                }
                try {}
                catch (NoSuchFieldException e) {
                    if (field != null) return objectStreamField;
                    throw new IllegalArgumentException(e);
                }
                Field f = clazz.forClass().getDeclaredField(name);
                if (Modifier.isTransient(f.getModifiers())) {
                    throw new IllegalArgumentException("no such field (non transient) " + name);
                }
                if (field != null) return objectStreamField;
                if (f.getType() == type) return objectStreamField;
                throw new IllegalArgumentException("Invalid requested type for field " + name);
            }
        };
        this.fieldsAlreadyRead = true;
        return this.prereadFields;
    }

    protected Object readObjectOverride() throws ClassNotFoundException, IOException, OptionalDataException {
        throw new IOException("Subclass of ObjectInputStream must implement readObjectOverride");
    }

    private final int assignNewHandle(Object obj) {
        this.objectLookupTable.put(new Integer(this.nextOID), new ObjectIdentityWrapper(obj));
        return this.nextOID++;
    }

    private final Object processResolution(ObjectStreamClass osc, Object obj, int handle) throws IOException {
        if (osc != null && obj instanceof Serializable) {
            try {
                Method m = osc.readResolveMethod;
                if (m != null) {
                    obj = m.invoke(obj, new Object[0]);
                }
            }
            catch (IllegalAccessException ignore) {
            }
            catch (InvocationTargetException ignore) {
                // empty catch block
            }
        }
        if (this.resolveEnabled) {
            obj = this.resolveObject(obj);
        }
        this.objectLookupTable.put(new Integer(handle), new ObjectIdentityWrapper(obj));
        return obj;
    }

    private final void clearHandles() {
        this.objectLookupTable.clear();
        this.nextOID = 0x7E0000;
    }

    private final void readNextBlock() throws IOException {
        this.readNextBlock(this.realInputStream.readByte());
    }

    private final void readNextBlock(byte marker) throws IOException {
        if (marker == 119) {
            if (dump) {
                this.dumpElement("BLOCK DATA SIZE=");
            }
            this.blockDataBytes = this.realInputStream.readUnsignedByte();
            if (dump) {
                this.dumpElementln(Integer.toString(this.blockDataBytes));
            }
        } else if (marker == 122) {
            if (dump) {
                this.dumpElement("BLOCK DATA LONG SIZE=");
            }
            this.blockDataBytes = this.realInputStream.readInt();
            if (dump) {
                this.dumpElementln(Integer.toString(this.blockDataBytes));
            }
        } else {
            throw new EOFException("Attempt to read primitive data, but no data block is active.");
        }
        if (this.blockData.length < this.blockDataBytes) {
            this.blockData = new byte[this.blockDataBytes];
        }
        this.realInputStream.readFully(this.blockData, 0, this.blockDataBytes);
        this.blockDataPosition = 0;
    }

    private final void readArrayElements(Object array, Class clazz) throws ClassNotFoundException, IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] cast_array = (boolean[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readBoolean();
                    ++i;
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] cast_array = (byte[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readByte();
                    ++i;
                }
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cast_array = (char[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readChar();
                    ++i;
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] cast_array = (double[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readDouble();
                    ++i;
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] cast_array = (float[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readFloat();
                    ++i;
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] cast_array = (int[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readInt();
                    ++i;
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] cast_array = (long[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readLong();
                    ++i;
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] cast_array = (short[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readShort();
                    ++i;
                }
                return;
            }
        } else {
            Object[] cast_array = (Object[])array;
            int i = 0;
            while (i < cast_array.length) {
                cast_array[i] = this.readObject();
                ++i;
            }
        }
    }

    private final void readFields(Object obj, ObjectStreamClass stream_osc) throws ClassNotFoundException, IOException {
        ObjectStreamField[] fields = stream_osc.fieldMapping;
        int i = 0;
        while (i < fields.length) {
            char type;
            String field_name;
            boolean set_value;
            ObjectStreamField stream_field = fields[i];
            ObjectStreamField real_field = fields[i + 1];
            boolean bl = false;
            if (stream_field != null && stream_field.getOffset() >= 0 && stream_field.isToSet()) {
                bl = true;
            }
            boolean read_value = bl;
            boolean bl2 = false;
            if (real_field != null && real_field.isToSet()) {
                bl2 = set_value = true;
            }
            if (stream_field != null) {
                field_name = stream_field.getName();
                type = stream_field.getTypeCode();
            } else {
                field_name = real_field.getName();
                type = real_field.getTypeCode();
            }
            switch (type) {
                case 'Z': {
                    boolean value;
                    boolean bl3 = false;
                    if (read_value) {
                        bl3 = value = this.realInputStream.readBoolean();
                    }
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setBooleanField(obj, value);
                    break;
                }
                case 'B': {
                    byte value;
                    byte by = 0;
                    if (read_value) {
                        by = value = this.realInputStream.readByte();
                    }
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setByteField(obj, value);
                    break;
                }
                case 'C': {
                    char value;
                    char c = '\u0000';
                    if (read_value) {
                        c = value = this.realInputStream.readChar();
                    }
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setCharField(obj, value);
                    break;
                }
                case 'D': {
                    double value;
                    double d = value = read_value ? this.realInputStream.readDouble() : 0.0;
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setDoubleField(obj, value);
                    break;
                }
                case 'F': {
                    float value;
                    float f = value = read_value ? this.realInputStream.readFloat() : 0.0f;
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setFloatField(obj, value);
                    break;
                }
                case 'I': {
                    int value;
                    int n = 0;
                    if (read_value) {
                        n = value = this.realInputStream.readInt();
                    }
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setIntField(obj, value);
                    break;
                }
                case 'J': {
                    long value;
                    long l = value = read_value ? this.realInputStream.readLong() : 0L;
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setLongField(obj, value);
                    break;
                }
                case 'S': {
                    short value;
                    short s = 0;
                    if (read_value) {
                        s = value = this.realInputStream.readShort();
                    }
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setShortField(obj, value);
                    break;
                }
                case 'L': 
                case '[': {
                    Object value;
                    Object object = value = read_value ? this.readObject() : null;
                    if (!set_value) break;
                    real_field.setObjectField(obj, value);
                    break;
                }
                default: {
                    throw new InternalError("Invalid type code: " + type);
                }
            }
            i += 2;
        }
    }

    private final boolean setBlockDataMode(boolean on) {
        boolean oldmode = this.readDataFromBlock;
        this.readDataFromBlock = on;
        this.dataInputStream = on ? this.blockDataInput : this.realInputStream;
        return oldmode;
    }

    private final Object newObject(Class real_class, Constructor constructor) throws ClassNotFoundException, IOException {
        if (constructor == null) {
            throw new InvalidClassException("Missing accessible no-arg base class constructor for " + real_class.getName());
        }
        try {
            return VMObjectInputStream.allocateObject(real_class, constructor.getDeclaringClass(), constructor);
        }
        catch (InstantiationException e) {
            throw (ClassNotFoundException)new ClassNotFoundException("Instance of " + real_class + " could not be created").initCause(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void invokeValidators() throws InvalidObjectException {
        try {
            Iterator it = this.currentObjectValidators.iterator();
            while (it.hasNext()) {
                ValidatorAndPriority vap = (ValidatorAndPriority)it.next();
                ObjectInputValidation validator = vap.validator;
                validator.validateObject();
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.currentObjectValidators = null;
            throw throwable;
        }
        {
            Object var2_6 = null;
            this.currentObjectValidators = null;
            return;
        }
    }

    private final void callReadMethod(Method readObject, Class klass, Object obj) throws ClassNotFoundException, IOException {
        try {
            readObject.invoke(obj, new Object[]{this});
        }
        catch (InvocationTargetException x) {
            Throwable exception = x.getTargetException();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            throw (IOException)new IOException("Exception thrown from readObject() on " + klass).initCause(x);
        }
        catch (Exception x) {
            throw (IOException)new IOException("Failure invoking readObject() on " + klass).initCause(x);
        }
        this.prereadFields = null;
    }

    private final void dumpElement(String msg) {
        System.out.print(msg);
    }

    private final void dumpElementln(String msg) {
        System.out.println(msg);
        int i = 0;
        while (i < this.depth) {
            System.out.print(" ");
            ++i;
        }
        System.out.print(Thread.currentThread() + ": ");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.depth = 0;
    }

    public ObjectInputStream(InputStream in) throws IOException, StreamCorruptedException {
        this.this();
        this.resolveEnabled = false;
        this.blockDataPosition = 0;
        this.blockDataBytes = 0;
        this.blockData = new byte[1024];
        this.blockDataInput = new DataInputStream(this);
        this.realInputStream = new DataInputStream(in);
        this.nextOID = 0x7E0000;
        this.objectLookupTable = new Hashtable();
        this.classLookupTable = new Hashtable();
        this.setBlockDataMode(true);
        this.readStreamHeader();
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        this.this();
        SecurityManager sec_man = System.getSecurityManager();
        if (sec_man != null) {
            sec_man.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    private static final class ValidatorAndPriority
    implements Comparable {
        int priority;
        ObjectInputValidation validator;

        public final int compareTo(Object o) {
            ValidatorAndPriority vap = (ValidatorAndPriority)o;
            return this.priority - vap.priority;
        }

        ValidatorAndPriority(ObjectInputValidation validator, int priority) {
            this.priority = priority;
            this.validator = validator;
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;
    }
}

