/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public final class PrivateCredentialPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 5284372143517237068L;
    private final String credentialClass;
    private final Set principals;
    private final boolean testing;

    public final boolean equals(Object o) {
        if (!(o instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission that = (PrivateCredentialPermission)o;
        if (!that.getActions().equals(this.getActions())) {
            return false;
        }
        if (!that.getCredentialClass().equals(this.getCredentialClass())) {
            return false;
        }
        String[][] principals = this.getPrincipals();
        String[][] that_principals = that.getPrincipals();
        if (that_principals == null) {
            return false;
        }
        if (that_principals.length != principals.length) {
            return false;
        }
        int i = 0;
        while (i < principals.length) {
            if (!principals[i][0].equals(that_principals[i][0]) || !principals[i][1].equals(that_principals[i][1])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final String getActions() {
        return "read";
    }

    public final String getCredentialClass() {
        return this.credentialClass;
    }

    public final String[][] getPrincipals() {
        String[][] ret = new String[this.principals.size()][];
        Iterator it = this.principals.iterator();
        int i = 0;
        while (i < this.principals.size() && it.hasNext()) {
            CredOwner co = (CredOwner)it.next();
            ret[i] = new String[]{co.getPrincipalClass(), co.getPrincipalName()};
            ++i;
        }
        return ret;
    }

    public final int hashCode() {
        return this.credentialClass.hashCode() + this.principals.hashCode();
    }

    public final boolean implies(Permission p) {
        if (!(p instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission that = (PrivateCredentialPermission)p;
        if (!this.credentialClass.equals("*") && !this.credentialClass.equals(that.getCredentialClass())) {
            return false;
        }
        String[][] principals = this.getPrincipals();
        String[][] that_principals = that.getPrincipals();
        if (that_principals == null) {
            return false;
        }
        int i = 0;
        while (i < principals.length) {
            int j = 0;
            while (j < that_principals.length) {
                if (principals[i][0].equals(that_principals[j][0]) && (principals[i][1].equals("*") || principals[i][1].equals(that_principals[j][1]))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public final PermissionCollection newPermissionCollection() {
        return null;
    }

    public PrivateCredentialPermission(String name, String actions) {
        super(name);
        actions = actions.trim().toLowerCase();
        if (!"read".equals(actions)) {
            throw new IllegalArgumentException("actions must be \"read\"");
        }
        StringTokenizer st = new StringTokenizer(name, " \"'");
        this.principals = new HashSet();
        if (st.countTokens() < 3 || (st.countTokens() & 1) == 0) {
            throw new IllegalArgumentException("badly formed credential name");
        }
        this.credentialClass = st.nextToken();
        while (st.hasMoreTokens()) {
            this.principals.add(new CredOwner(st.nextToken(), st.nextToken()));
        }
        this.testing = false;
    }

    private static class CredOwner
    implements Serializable {
        private final String principalClass;
        private final String principalName;

        public boolean equals(Object o) {
            if (!(o instanceof CredOwner)) {
                return false;
            }
            boolean bl = false;
            if (this.principalClass.equals(((CredOwner)o).getPrincipalClass()) && this.principalName.equals(((CredOwner)o).getPrincipalName())) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            return this.principalClass.hashCode() + this.principalName.hashCode();
        }

        public String getPrincipalClass() {
            return this.principalClass;
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        CredOwner(String principalClass, String principalName) {
            this.principalClass = principalClass;
            this.principalName = principalName;
        }
    }
}

