/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileCacheImageOutputStream
extends ImageOutputStreamImpl {
    private OutputStream stream;
    private File cacheDir;

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    private final void checkStreamClosed() throws IOException {
        if (this.stream == null) {
            throw new IOException("stream closed");
        }
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return true;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public int read() throws IOException {
        throw new Error("not implemented");
    }

    public int read(byte[] data, int offset, int len) throws IOException {
        throw new Error("not implemented");
    }

    public void write(byte[] data, int offset, int len) throws IOException {
        this.checkStreamClosed();
        this.stream.write(data, offset, len);
    }

    public void write(int value) throws IOException {
        this.checkStreamClosed();
        this.stream.write(value);
    }

    public FileCacheImageOutputStream(OutputStream stream, File cacheDir) throws IOException {
        this.stream = stream;
        this.cacheDir = cacheDir;
    }
}

