/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicButtonUI
extends ButtonUI {
    protected int defaultTextIconGap;
    protected int defaultTextShiftOffset;
    private int textShiftOffset;
    protected BasicButtonListener listener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicButtonUI();
    }

    public int getDefaultTextIconGap(AbstractButton b) {
        return this.defaultTextIconGap;
    }

    protected void clearTextShiftOffset() {
        this.textShiftOffset = 0;
    }

    protected int getTextShiftOffset() {
        return this.textShiftOffset;
    }

    protected void setTextShiftOffset() {
        this.textShiftOffset = this.defaultTextShiftOffset;
    }

    protected String getPropertyPrefix() {
        return "Button.";
    }

    protected void installDefaults(AbstractButton b) {
        String prefix = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(b, prefix + "background", prefix + "foreground", prefix + "font");
        LookAndFeel.installBorder(b, prefix + "border");
        b.setMargin(UIManager.getInsets(prefix + "margin"));
        b.setIconTextGap(UIManager.getInt(prefix + "textIconGap"));
        b.setInputMap(0, (InputMap)UIManager.get(prefix + "focusInputMap"));
        b.setRolloverEnabled(UIManager.getBoolean(prefix + "rollover"));
    }

    protected void uninstallDefaults(AbstractButton b) {
        if (b.getFont() instanceof UIResource) {
            b.setFont(null);
        }
        b.setForeground(null);
        b.setBackground(null);
        b.setBorder(null);
        b.setIconTextGap(this.defaultTextIconGap);
        b.setMargin(null);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new BasicButtonListener(b);
    }

    protected void installListeners(AbstractButton b) {
        this.listener = this.createButtonListener(b);
        b.addChangeListener(this.listener);
        b.addPropertyChangeListener(this.listener);
        b.addFocusListener(this.listener);
        b.addMouseListener(this.listener);
        b.addMouseMotionListener(this.listener);
    }

    protected void uninstallListeners(AbstractButton b) {
        b.removeChangeListener(this.listener);
        b.removePropertyChangeListener(this.listener);
        b.removeFocusListener(this.listener);
        b.removeMouseListener(this.listener);
        b.removeMouseMotionListener(this.listener);
    }

    protected void installKeyboardActions(AbstractButton b) {
        this.listener.installKeyboardActions(b);
    }

    protected void uninstallKeyboardActions(AbstractButton b) {
        this.listener.uninstallKeyboardActions(b);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            this.installDefaults(b);
            this.installListeners(b);
            this.installKeyboardActions(b);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Dimension d = BasicGraphicsUtils.getPreferredButtonSize(b, this.defaultTextIconGap + this.defaultTextShiftOffset);
        return d;
    }

    static Icon currentIcon(AbstractButton b) {
        Icon i = b.getIcon();
        ButtonModel model = b.getModel();
        if (model.isPressed() && b.getPressedIcon() != null && b.isEnabled()) {
            i = b.getPressedIcon();
        } else if (model.isRollover()) {
            if (b.isSelected() && b.getRolloverSelectedIcon() != null) {
                i = b.getRolloverSelectedIcon();
            } else if (b.getRolloverIcon() != null) {
                i = b.getRolloverIcon();
            }
        } else if (b.isSelected() && b.isEnabled()) {
            if (b.isEnabled() && b.getSelectedIcon() != null) {
                i = b.getSelectedIcon();
            } else if (b.getDisabledSelectedIcon() != null) {
                i = b.getDisabledSelectedIcon();
            }
        } else if (!b.isEnabled() && b.getDisabledIcon() != null) {
            i = b.getDisabledIcon();
        }
        return i;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Rectangle tr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle vr = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        if (b.isBorderPainted()) {
            SwingUtilities.calculateInnerArea(b, vr);
        } else {
            vr = SwingUtilities.getLocalBounds(b);
        }
        String text = SwingUtilities.layoutCompoundLabel(c, g.getFontMetrics(f), b.getText(), BasicButtonUI.currentIcon(b), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), vr, ir, tr, b.getIconTextGap() + this.defaultTextShiftOffset);
        if (b.getModel().isArmed() && b.getModel().isPressed() || b.isSelected()) {
            this.paintButtonPressed(g, b);
        }
        this.paintIcon(g, c, ir);
        if (text != null) {
            this.paintText(g, b, tr, text);
        }
        if (b.isFocusOwner() && b.isFocusPainted()) {
            this.paintFocus(g, b, vr, tr, ir);
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle vr, Rectangle tr, Rectangle ir) {
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        Icon i = BasicButtonUI.currentIcon(b);
        if (i != null) {
            i.paintIcon(c, g, iconRect.x, iconRect.y);
        }
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled() && b.isOpaque()) {
            Rectangle area = new Rectangle();
            SwingUtilities.calculateInnerArea(b, area);
            g.setColor(UIManager.getColor(this.getPropertyPrefix() + "shadow"));
            g.fillRect(area.x, area.y, area.width, area.height);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        this.paintText(g, (AbstractButton)c, textRect, text);
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        Font f = b.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        if (b.isEnabled()) {
            g.setColor(b.getForeground());
            g.drawString(text, textRect.x, textRect.y + fm.getAscent());
        } else {
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            String prefix = this.getPropertyPrefix();
            g.setColor(defaults.getColor(prefix + "disabledText"));
            g.drawString(text, textRect.x, textRect.y + fm.getAscent());
        }
    }

    private final /* synthetic */ void this() {
        this.defaultTextIconGap = 4;
        this.defaultTextShiftOffset = 0;
    }

    public BasicButtonUI() {
        this.this();
    }
}

