/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollButton;
import javax.swing.plaf.metal.MetalUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MetalScrollBarUI
extends BasicScrollBarUI {
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    private static final Dimension MIN_THUMB_SIZE = new Dimension(15, 15);
    private static final Dimension MIN_THUMB_SIZE_FREE_STANDING = new Dimension(17, 17);
    protected MetalScrollButton increaseButton;
    protected MetalScrollButton decreaseButton;
    protected int scrollBarWidth;
    protected boolean isFreeStanding;
    Color scrollBarShadowColor;

    public static ComponentUI createUI(JComponent component) {
        return new MetalScrollBarUI();
    }

    protected void installDefaults() {
        Boolean prop = (Boolean)this.scrollbar.getClientProperty(FREE_STANDING_PROP);
        boolean bl = true;
        if (prop != null) {
            bl = prop;
        }
        this.isFreeStanding = bl;
        this.scrollBarShadowColor = UIManager.getColor("ScrollBar.shadow");
        super.installDefaults();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new MetalScrollBarPropertyChangeHandler();
    }

    protected JButton createDecreaseButton(int orientation) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.scrollBarWidth = defaults.getInt("ScrollBar.width");
        this.decreaseButton = new MetalScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.scrollBarWidth = defaults.getInt("ScrollBar.width");
        this.increaseButton = new MetalScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(MetalLookAndFeel.getControl());
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        if (this.scrollbar.getOrientation() == 0) {
            this.paintTrackHorizontal(g, c, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        } else {
            this.paintTrackVertical(g, c, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        }
    }

    private final void paintTrackHorizontal(Graphics g, JComponent c, int x, int y, int w, int h) {
        if (c.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(x, y, x, y + h - 1);
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            g.setColor(this.scrollBarShadowColor);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 1);
            g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
            if (this.isFreeStanding) {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawLine(x, y + h - 2, x + w - 1, y + h - 2);
                g.setColor(this.scrollBarShadowColor);
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            if (this.isFreeStanding) {
                g.drawRect(x, y, w - 1, h - 1);
            } else {
                g.drawLine(x, y, x + w - 1, y);
                g.drawLine(x, y, x, y + h - 1);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
        }
    }

    private final void paintTrackVertical(Graphics g, JComponent c, int x, int y, int w, int h) {
        if (c.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(x, y, x, y + h - 1);
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(this.scrollBarShadowColor);
            g.drawLine(x + 1, y + 1, x + w - 1, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
            if (this.isFreeStanding) {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawLine(x + w - 2, y, x + w - 2, y + h - 1);
                g.setColor(MetalLookAndFeel.getControlHighlight());
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            if (this.isFreeStanding) {
                g.drawRect(x, y, w - 1, h - 1);
            } else {
                g.drawLine(x, y, x + w - 1, y);
                g.drawLine(x, y, x, y + h - 1);
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        if (this.scrollbar.getOrientation() == 0) {
            this.paintThumbHorizontal(g, c, thumbBounds);
        } else {
            this.paintThumbVertical(g, c, thumbBounds);
        }
        MetalUtils.fillMetalPattern(c, g, thumbBounds.x + 3, thumbBounds.y + 3, thumbBounds.width - 6, thumbBounds.height - 6, this.thumbHighlightColor, this.thumbLightShadowColor);
    }

    private final void paintThumbHorizontal(Graphics g, JComponent c, Rectangle thumbBounds) {
        int x = thumbBounds.x;
        int y = thumbBounds.y;
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        g.setColor(this.thumbColor);
        if (this.isFreeStanding) {
            g.fillRect(x, y, w, h - 1);
        } else {
            g.fillRect(x, y, w, h);
        }
        g.setColor(this.thumbLightShadowColor);
        if (this.isFreeStanding) {
            g.drawRect(x, y, w - 1, h - 2);
        } else {
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y, x, y + h - 1);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        }
        g.setColor(this.thumbHighlightColor);
        if (this.isFreeStanding) {
            g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 3);
        } else {
            g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 1);
        }
        UIDefaults def = UIManager.getLookAndFeelDefaults();
        g.setColor(def.getColor("ScrollBar.shadow"));
        g.drawLine(x + w, y + 1, x + w, y + h - 1);
    }

    private final void paintThumbVertical(Graphics g, JComponent c, Rectangle thumbBounds) {
        int x = thumbBounds.x;
        int y = thumbBounds.y;
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        g.setColor(this.thumbColor);
        if (this.isFreeStanding) {
            g.fillRect(x, y, w - 1, h);
        } else {
            g.fillRect(x, y, w, h);
        }
        g.setColor(this.thumbLightShadowColor);
        if (this.isFreeStanding) {
            g.drawRect(x, y, w - 2, h - 1);
        } else {
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y, x, y + h - 1);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        }
        g.setColor(this.thumbHighlightColor);
        if (this.isFreeStanding) {
            g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 3);
        } else {
            g.drawLine(x + 1, y + 1, x + w - 1, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 3);
        }
        UIDefaults def = UIManager.getLookAndFeelDefaults();
        g.setColor(def.getColor("ScrollBar.shadow"));
        g.drawLine(x + 1, y + h, x + w - 2, y + h);
    }

    protected Dimension getMinimumThumbSize() {
        if (this.isFreeStanding) {
            return MIN_THUMB_SIZE_FREE_STANDING;
        }
        return MIN_THUMB_SIZE;
    }

    private final /* synthetic */ void this() {
        this.isFreeStanding = true;
    }

    public MetalScrollBarUI() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MetalScrollBarPropertyChangeHandler
    extends BasicScrollBarUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals(MetalScrollBarUI.FREE_STANDING_PROP)) {
                Boolean prop = (Boolean)e.getNewValue();
                boolean bl = true;
                if (prop != null) {
                    bl = MetalScrollBarUI.this.isFreeStanding = prop.booleanValue();
                }
                if (MetalScrollBarUI.this.increaseButton != null) {
                    MetalScrollBarUI.this.increaseButton.setFreeStanding(MetalScrollBarUI.this.isFreeStanding);
                }
                if (MetalScrollBarUI.this.decreaseButton != null) {
                    MetalScrollBarUI.this.decreaseButton.setFreeStanding(MetalScrollBarUI.this.isFreeStanding);
                }
            } else {
                super.propertyChange(e);
            }
        }
    }
}

