/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSelector
extends Selector {
    private boolean closed;
    private SelectorProvider provider;
    private HashSet cancelledKeys;

    public final synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.implCloseSelector();
        this.closed = true;
    }

    public final boolean isOpen() {
        return this.closed ^ true;
    }

    protected final void begin() {
    }

    protected final void end() {
    }

    public final SelectorProvider provider() {
        return this.provider;
    }

    protected final Set cancelledKeys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return this.cancelledKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void cancelKey(AbstractSelectionKey key) {
        HashSet hashSet = this.cancelledKeys;
        synchronized (hashSet) {
            this.cancelledKeys.add(key);
            return;
        }
    }

    protected abstract void implCloseSelector() throws IOException;

    protected abstract SelectionKey register(AbstractSelectableChannel var1, int var2, Object var3);

    protected final void deregister(AbstractSelectionKey key) {
        ((AbstractSelectableChannel)key.channel()).removeSelectionKey(key);
    }

    protected AbstractSelector(SelectorProvider provider) {
        this.provider = provider;
        this.cancelledKeys = new HashSet();
    }
}

