/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public class Properties
extends Hashtable {
    private static final long serialVersionUID = 4112578634029874840L;
    protected Properties defaults;

    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public void load(InputStream inStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "ISO-8859-1"));
        while ((line = reader.readLine()) != null) {
            char c = '\u0000';
            int pos = 0;
            while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
            if (line.length() - pos == 0 || line.charAt(pos) == '#' || line.charAt(pos) == '!') continue;
            StringBuffer key = new StringBuffer();
            block14: while (pos < line.length() && !Character.isWhitespace(c = line.charAt(pos++)) && c != '=' && c != ':') {
                if (c == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        if (line == null) {
                            line = "";
                        }
                        pos = 0;
                        while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                            ++pos;
                        }
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            key.append('\n');
                            break;
                        }
                        case 't': {
                            key.append('\t');
                            break;
                        }
                        case 'r': {
                            key.append('\r');
                            break;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block14;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            key.append(uni);
                            pos += 4;
                            break;
                        }
                        default: {
                            key.append(c);
                            break;
                        }
                    }
                    continue;
                }
                key.append(c);
            }
            boolean bl = false;
            if (c == ':' || c == '=') {
                bl = true;
            }
            boolean isDelim = bl;
            while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
            if (!(isDelim || c != ':' && c != '=')) {
                ++pos;
                while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                    ++pos;
                }
            }
            StringBuffer element = new StringBuffer(line.length() - pos);
            block18: while (pos < line.length()) {
                if ((c = line.charAt(pos++)) == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        if (line == null) break;
                        pos = 0;
                        while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                            ++pos;
                        }
                        element.ensureCapacity(line.length() - pos + element.length());
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            element.append('\n');
                            break;
                        }
                        case 't': {
                            element.append('\t');
                            break;
                        }
                        case 'r': {
                            element.append('\r');
                            break;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block18;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            element.append(uni);
                            pos += 4;
                            break;
                        }
                        default: {
                            element.append(c);
                            break;
                        }
                    }
                    continue;
                }
                element.append(c);
            }
            this.put(key.toString(), element.toString());
        }
    }

    public void save(OutputStream out, String header) {
        try {
            this.store(out, header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void store(OutputStream out, String header) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, "ISO-8859-1"));
        if (header != null) {
            writer.println("#" + header);
        }
        writer.println("#" + Calendar.getInstance().getTime());
        Iterator iter = this.entrySet().iterator();
        int i = this.size();
        StringBuffer s = new StringBuffer();
        while (--i >= 0) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.formatForOutput((String)entry.getKey(), s, true);
            s.append('=');
            this.formatForOutput((String)entry.getValue(), s, false);
            writer.println(s);
        }
        writer.flush();
    }

    public String getProperty(String key) {
        Properties prop = this;
        do {
            String value;
            if ((value = (String)prop.get(key)) == null) continue;
            return value;
        } while ((prop = prop.defaults) != null);
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        String prop = this.getProperty(key);
        if (prop == null) {
            prop = defaultValue;
        }
        return prop;
    }

    public Enumeration propertyNames() {
        Properties prop = this;
        HashSet s = new HashSet();
        do {
            s.addAll(prop.keySet());
        } while ((prop = prop.defaults) != null);
        return Collections.enumeration(s);
    }

    public void list(PrintStream out) {
        PrintWriter writer = new PrintWriter(out);
        this.list(writer);
    }

    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        Iterator iter = this.entrySet().iterator();
        int i = this.size();
        while (--i >= 0) {
            Map.Entry entry = (Map.Entry)iter.next();
            out.print((String)entry.getKey() + '=');
            String s = (String)entry.getValue();
            if (s != null && s.length() > 40) {
                out.println(s.substring(0, 37) + "...");
                continue;
            }
            out.println(s);
        }
        out.flush();
    }

    private final void formatForOutput(String str, StringBuffer buffer, boolean key) {
        if (key) {
            buffer.setLength(0);
            buffer.ensureCapacity(str.length());
        } else {
            buffer.ensureCapacity(buffer.length() + str.length());
        }
        boolean head = true;
        int size = str.length();
        int i = 0;
        while (i < size) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case ' ': {
                    buffer.append(head ? "\\ " : " ");
                    break;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    buffer.append('\\').append(c);
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String hex = Integer.toHexString(c);
                        buffer.append("\\u0000".substring(0, 6 - hex.length()));
                        buffer.append(hex);
                        break;
                    }
                    buffer.append(c);
                }
            }
            if (c != ' ') {
                head = key;
            }
            ++i;
        }
    }

    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.storeToXML(os, comment, "UTF-8");
    }

    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        if (os == null) {
            throw new NullPointerException("Null output stream supplied.");
        }
        if (encoding == null) {
            throw new NullPointerException("Null encoding supplied.");
        }
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementation domImpl = registry.getDOMImplementation("LS 3.0");
            DocumentType doctype = domImpl.createDocumentType("properties", null, "http://java.sun.com/dtd/properties.dtd");
            Document doc = domImpl.createDocument(null, "properties", doctype);
            Element root = doc.getDocumentElement();
            if (comment != null) {
                Element commentElement = doc.createElement("comment");
                commentElement.appendChild(doc.createTextNode(comment));
                root.appendChild(commentElement);
            }
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Element entryElement = doc.createElement("entry");
                entryElement.setAttribute("key", (String)entry.getKey());
                entryElement.appendChild(doc.createTextNode((String)entry.getValue()));
                root.appendChild(entryElement);
            }
            DOMImplementationLS loadAndSave = (DOMImplementationLS)((Object)domImpl);
            LSSerializer serializer = loadAndSave.createLSSerializer();
            LSOutput output = loadAndSave.createLSOutput();
            output.setByteStream(os);
            output.setEncoding(encoding);
            serializer.write(doc, output);
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("The XML classes could not be found.").initCause(e);
        }
        catch (InstantiationException e) {
            throw (IOException)new IOException("The XML classes could not be instantiated.").initCause(e);
        }
        catch (IllegalAccessException e) {
            throw (IOException)new IOException("The XML classes could not be accessed.").initCause(e);
        }
    }

    public void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        if (in == null) {
            throw new NullPointerException("Null input stream supplied.");
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            XMLReader parser = factory.newSAXParser().getXMLReader();
            PropertiesHandler handler = new PropertiesHandler();
            parser.setContentHandler(handler);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(new InputSource(in));
        }
        catch (SAXException e) {
            throw (InvalidPropertiesFormatException)new InvalidPropertiesFormatException("Error in parsing XML.").initCause(e);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("An XML parser could not be found.").initCause(e);
        }
    }

    public Properties() {
    }

    public Properties(Properties defaults) {
        this.defaults = defaults;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PropertiesHandler
    extends DefaultHandler2 {
        private String key = null;
        private String value = null;
        private boolean dtdDeclSeen = false;

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (!name.equals("properties") || publicId != null || !systemId.equals("http://java.sun.com/dtd/properties.dtd")) {
                throw new SAXException("Invalid DTD declaration: " + name);
            }
            this.dtdDeclSeen = true;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("entry")) {
                int index = attributes.getIndex("key");
                if (index != -1) {
                    this.key = attributes.getValue(index);
                }
            } else if (!qName.equals("comment") && !qName.equals("properties")) {
                throw new SAXException("Invalid tag: " + qName);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.key != null) {
                this.value = new String(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("entry")) {
                if (this.value == null) {
                    this.value = "";
                }
                Properties.this.setProperty(this.key, this.value);
                this.key = null;
                this.value = null;
            }
        }

        public void endDocument() throws SAXException {
            if (!this.dtdDeclSeen) {
                throw new SAXException("No appropriate DTD declaration was seen.");
            }
        }
    }
}

