/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.util.Arrays;

public final class Inet6Address
extends InetAddress {
    static final long serialVersionUID = 6880410070516793377L;
    byte[] ipaddress;

    public final boolean isMulticastAddress() {
        boolean bl = false;
        if (this.ipaddress[0] == 255) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAnyLocalAddress() {
        byte[] anylocal = new byte[16];
        return Arrays.equals(this.ipaddress, anylocal);
    }

    public final boolean isLoopbackAddress() {
        byte[] byArray = new byte[16];
        byArray[15] = 1;
        byte[] loopback = byArray;
        return Arrays.equals(this.ipaddress, loopback);
    }

    public final boolean isLinkLocalAddress() {
        boolean bl = false;
        if (this.ipaddress[0] == 250) {
            bl = true;
        }
        return bl;
    }

    public final boolean isSiteLocalAddress() {
        boolean bl = false;
        if (this.ipaddress[0] == 251) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMCGlobal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.ipaddress[1] & 0xF) == 14) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMCNodeLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.ipaddress[1] & 0xF) == 1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.ipaddress[1] & 0xF) == 2) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMCSiteLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.ipaddress[1] & 0xF) == 5) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMCOrgLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.ipaddress[1] & 0xF) == 8) {
            bl = true;
        }
        return bl;
    }

    public final byte[] getAddress() {
        return (byte[])this.ipaddress.clone();
    }

    public final String getHostAddress() {
        StringBuffer sbuf = new StringBuffer(40);
        int i = 0;
        while (i < 16) {
            int x = (this.ipaddress[i] & 0xFF) << 8 | this.ipaddress[i + 1] & 0xFF;
            if (i > 0) {
                sbuf.append(':');
            }
            sbuf.append(Integer.toHexString(x));
            i += 2;
        }
        return sbuf.toString();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Inet6Address)) {
            return false;
        }
        return super.equals(obj);
    }

    public final boolean isIPv4CompatibleAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
    }

    Inet6Address(byte[] addr, String host) {
        super(addr, host);
        this.ipaddress = this.addr;
    }
}

