/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;

public class DirectoryManager
extends NamingManager {
    public static DirContext getContinuationDirContext(CannotProceedException c) throws NamingException {
        return (DirContext)DirectoryManager.getContinuationContext(c);
    }

    private static final Object tryCreateObject(ObjectFactory factory, Object refInfo, Name name, Context nameCtx, Hashtable environment, Attributes attrs) throws Exception {
        if (factory instanceof DirObjectFactory) {
            DirObjectFactory dof = (DirObjectFactory)factory;
            return dof.getObjectInstance(refInfo, name, nameCtx, environment, attrs);
        }
        return factory.getObjectInstance(refInfo, name, nameCtx, environment);
    }

    public static Object getObjectInstance(Object refInfo, Name name, Context nameCtx, Hashtable environment, Attributes attrs) throws Exception {
        ObjectFactory factory = null;
        if (ofb != null) {
            factory = ofb.createObjectFactory(refInfo, environment);
        } else {
            Class k;
            Object ref2 = refInfo;
            if (refInfo instanceof Referenceable) {
                ref2 = ((Referenceable)refInfo).getReference();
            }
            if (ref2 instanceof Reference) {
                Reference ref = (Reference)ref2;
                String fClass = ref.getFactoryClassName();
                if (fClass != null) {
                    k = Class.forName(fClass);
                    factory = (ObjectFactory)k.newInstance();
                } else {
                    Enumeration e = ref.getAll();
                    while (e.hasMoreElements()) {
                        Object obj;
                        RefAddr ra = (RefAddr)e.nextElement();
                        if (!(ra instanceof StringRefAddr) || !"URL".equals(ra.getType()) || (obj = DirectoryManager.tryCreateObject(factory = (ObjectFactory)((Object)DirectoryManager.getURLContext(refInfo, name, nameCtx, (String)ra.getContent(), environment)), refInfo, name, nameCtx, environment, attrs)) == null) continue;
                        return obj;
                    }
                    factory = null;
                }
            }
            if (factory == null) {
                StringTokenizer tokens = DirectoryManager.getPlusPath("java.naming.factory.object", environment, nameCtx);
                while (tokens.hasMoreTokens()) {
                    String klassName = tokens.nextToken();
                    k = Class.forName(klassName);
                    factory = (ObjectFactory)k.newInstance();
                    Object obj = DirectoryManager.tryCreateObject(factory, refInfo, name, nameCtx, environment, attrs);
                    if (obj == null) continue;
                    return obj;
                }
                return refInfo;
            }
        }
        if (factory == null) {
            return refInfo;
        }
        Object obj = DirectoryManager.tryCreateObject(factory, refInfo, name, nameCtx, environment, attrs);
        return obj == null ? refInfo : obj;
    }

    public static DirStateFactory.Result getStateToBind(Object obj, Name name, Context nameCtx, Hashtable environment, Attributes attrs) throws NamingException {
        StringTokenizer tokens = DirectoryManager.getPlusPath("java.naming.factory.state", environment, nameCtx);
        while (tokens.hasMoreTokens()) {
            String klassName = tokens.nextToken();
            try {
                Class k = Class.forName(klassName);
                StateFactory factory = (StateFactory)k.newInstance();
                DirStateFactory.Result result = null;
                if (factory instanceof DirStateFactory) {
                    DirStateFactory dsf = (DirStateFactory)factory;
                    result = dsf.getStateToBind(obj, name, nameCtx, environment, attrs);
                } else {
                    Object o = factory.getStateToBind(obj, name, nameCtx, environment);
                    if (o != null) {
                        result = new DirStateFactory.Result(o, attrs);
                    }
                }
                if (result == null) continue;
                return result;
            }
            catch (ClassNotFoundException _1) {
            }
            catch (ClassCastException _2) {
            }
            catch (InstantiationException _3) {
            }
            catch (IllegalAccessException _4) {
                // empty catch block
            }
        }
        return new DirStateFactory.Result(obj, attrs);
    }

    DirectoryManager() {
    }
}

