/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class I18N {
    public static JButton mkButton(ResourceBundle b, String name) {
        String label;
        try {
            label = b.getString(String.valueOf(name) + ".label");
        }
        catch (MissingResourceException e) {
            label = name;
        }
        return new JButton(label);
    }

    public static JMenu mkMenu(ResourceBundle b, String name) {
        String menuLabel;
        try {
            menuLabel = b.getString(String.valueOf(name) + ".label");
        }
        catch (MissingResourceException e) {
            menuLabel = name;
        }
        return new JMenu(menuLabel);
    }

    public static JMenuItem mkMenuItem(ResourceBundle b, String menu, String name) {
        String miLabel;
        try {
            miLabel = b.getString(String.valueOf(menu) + "." + name + ".label");
        }
        catch (MissingResourceException e) {
            miLabel = name;
        }
        String key = null;
        try {
            key = b.getString(String.valueOf(menu) + "." + name + ".key");
        }
        catch (MissingResourceException e) {
            key = null;
        }
        if (key == null) {
            return new JMenuItem(miLabel);
        }
        return new JMenuItem(miLabel, key.charAt(0));
    }

    public static void mkDialog(ResourceBundle b, JFrame parent, String dialogTag, String titleTag, int messageType) {
        JOptionPane.showMessageDialog(parent, I18N.getString(b, dialogTag, "DIALOG TEXT MISSING: " + dialogTag), I18N.getString(b, titleTag, "DIALOG TITLE MISSING: " + titleTag), messageType);
    }

    public static String getString(ResourceBundle b, String name, String dflt) {
        String result;
        try {
            result = b.getString(name);
        }
        catch (MissingResourceException e) {
            result = dflt;
        }
        return result;
    }
}

