/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import java.util.Calendar;
import java.util.Date;

public class DateRangeUIHelper {
    static final Range[] dateRanges = new Range[]{new Range("1d", 1, "day"), new Range("7d", 7, "week"), new Range("1m", 31, "month"), new Range("3m", 90, "three months"), new Range("6m", 183, "six months"), new Range("1y", 365, "year")};

    public static Range[] getDateRanges() {
        return (Range[])dateRanges.clone();
    }

    public static String[] getDateRangeValues() {
        String[] choices = new String[dateRanges.length];
        int i = 0;
        while (i < dateRanges.length) {
            choices[i] = DateRangeUIHelper.dateRanges[i].choiceValue;
            ++i;
        }
        return choices;
    }

    public static String[] getDateRangeLabels() {
        String[] choices = new String[dateRanges.length];
        int i = 0;
        while (i < dateRanges.length) {
            choices[i] = DateRangeUIHelper.dateRanges[i].choiceLabel;
            ++i;
        }
        return choices;
    }

    public static Date getDateFromRange(String dropdownValue) {
        if (dropdownValue == null) {
            throw new IllegalArgumentException("Logic Error: input argument may not be null");
        }
        int nDays = -1;
        Range[] rangeArray = dateRanges;
        int n = 0;
        int n2 = rangeArray.length;
        while (n < n2) {
            Range d = rangeArray[n];
            if (dropdownValue.equals(d.choiceValue)) {
                nDays = d.days;
                break;
            }
            ++n;
        }
        if (nDays == -1) {
            throw new IllegalArgumentException(String.format("Logic Error: Days dropdown value %s invalid (not one we provided)", dropdownValue));
        }
        Calendar now = Calendar.getInstance();
        now.add(5, -nDays);
        Date dateStart = now.getTime();
        return dateStart;
    }

    public static class Range {
        final String choiceValue;
        final String choiceLabel;
        final int days;

        public Range(String val, int days, String lab) {
            this.choiceValue = val;
            this.choiceLabel = lab;
            this.days = days;
        }

        public String getChoiceLabel() {
            return this.choiceLabel;
        }

        public String getChoiceValue() {
            return this.choiceValue;
        }

        public int getDays() {
            return this.days;
        }

        public String toString() {
            return this.choiceLabel;
        }
    }
}

