/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentItems {
    private List<String> recentNames = new ArrayList<String>();
    public static final int DEFAULT_MAX_RECENT_FILES = 5;
    private final int maxRecentFiles;
    private String RECENT_ITEMS_KEY = "recent_items";
    private final Preferences prefsNode;
    private Callback callback;

    public RecentItems(Preferences prefs, Callback cb, int max) {
        this.prefsNode = prefs;
        this.callback = cb;
        this.maxRecentFiles = max;
    }

    public RecentItems(Preferences prefs, Callback cb) {
        this(prefs, cb, 5);
    }

    public void putRecent(String f) {
        while (this.recentNames.size() > this.maxRecentFiles - 1) {
            this.recentNames.remove(this.recentNames.size() - 1);
        }
        if (this.recentNames.contains(f)) {
            this.recentNames.remove(f);
        }
        this.recentNames.add(0, f);
        int i = 0;
        while (i < this.recentNames.size()) {
            String t = this.recentNames.get(i);
            this.prefsNode.put(this.makeName(i), t);
            ++i;
        }
        this.callCallBack();
    }

    private void callCallBack() {
        if (this.callback != null) {
            this.callback.reload(this.getList());
        }
    }

    String makeName(int i) {
        return String.valueOf(this.RECENT_ITEMS_KEY) + "." + i;
    }

    public List<String> getList() {
        return Collections.unmodifiableList(this.recentNames);
    }

    public void clear() {
        int i = 0;
        while (i < this.maxRecentFiles) {
            this.prefsNode.remove(this.makeName(i));
            ++i;
        }
        this.callCallBack();
    }

    public void remove(String f) {
        this.recentNames.remove(f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Callback {
        public void reload(List<String> var1);
    }
}

