/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.log4j.Logger;

public class TypeMap {
    private static final Logger logger = Logger.getLogger(TypeMap.class);
    TreeMap databases;
    ArrayList EMPTY_LIST = new ArrayList();
    Pattern SPACE_STRIPPER = Pattern.compile("[\\s]+");
    protected static TypeMap mainInstance = new TypeMap();

    public static void main(String[] args) {
        TypeMap tm = TypeMap.getInstance();
        logger.debug((Object)tm);
    }

    public static TypeMap getInstance() {
        return mainInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeMap() {
        this.databases = new TreeMap();
        Pattern p = Pattern.compile("^([\\S]+)[\\s]+([\\S]+)[\\s]+([\\S]+)[\\s]+([\\S]+)[\\s]+([\\S]+)[\\s]+([\\S]+)[\\s]+([\\S]+)[\\s]*");
        BufferedReader br = null;
        try {
            String line = null;
            br = new BufferedReader(new FileReader("mappingrules.properties"));
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0 || line.trim().length() > 0 && line.trim().substring(0, 1).equals("#")) continue;
                Matcher m = p.matcher(line);
                m.find();
                if (m.groupCount() != 7) {
                    logger.error((Object)("badly formatted line in mappingrules.properties:\n" + line));
                    continue;
                }
                MappingRule rule = new MappingRule();
                rule.setDatabase(m.group(1));
                rule.setNativeType(m.group(2));
                rule.setCompField(m.group(3));
                rule.setCompCondition(m.group(4));
                rule.setCompValue(m.group(5));
                rule.setModifyField(m.group(6));
                rule.setModifyValue(m.group(7));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("adding rule: " + rule));
                }
                this.addRule(rule);
            }
        }
        catch (IOException ie) {
            logger.error((Object)"IO error loading typemap", (Throwable)ie);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error((Object)"IO error loading typemap", (Throwable)e);
                }
            }
        }
    }

    public boolean addRule(MappingRule rule) {
        return this.getRulesForNativeType(rule, true).add(rule);
    }

    public boolean removeRule(MappingRule rule) {
        return this.getRulesForNativeType(rule, false).remove(rule);
    }

    protected List getRulesForNativeType(MappingRule rule, boolean createNew) {
        return this.getRulesForNativeType(rule.getDatabase(), rule.getNativeType(), createNew);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List getRulesForNativeType(String database, String nativeType, boolean createNew) {
        TreeMap nativeTypes = null;
        String tDatabase = this.translateDatabaseName(database);
        if (!this.databases.containsKey(tDatabase)) {
            if (!createNew) return this.EMPTY_LIST;
            nativeTypes = new TreeMap();
            this.databases.put(tDatabase, nativeTypes);
        } else {
            nativeTypes = (TreeMap)this.databases.get(tDatabase);
        }
        ArrayList mappingRules = null;
        if (nativeTypes.containsKey(nativeType)) return (ArrayList)nativeTypes.get(nativeType);
        if (!createNew) return this.EMPTY_LIST;
        mappingRules = new ArrayList();
        nativeTypes.put(nativeType, mappingRules);
        return mappingRules;
    }

    protected List getRules(SQLColumn col) {
        SQLDatabase database = col.getParentTable().getParentDatabase();
        List mappingRules = null;
        ArrayList<MappingRule> applicableRules = new ArrayList<MappingRule>();
        if (database != null) {
            mappingRules = this.getRulesForNativeType(database.getDataSource().getPlDbType(), col.getSourceDataTypeName(), false);
        }
        if (mappingRules.size() > 0) {
            for (MappingRule rule : mappingRules) {
                if (rule.getCompCondition().equals("*")) {
                    applicableRules.add(rule);
                    continue;
                }
                try {
                    String propertyVal = BeanUtils.getProperty((Object)col, (String)rule.getCompField());
                    try {
                        Integer iPropertyVal = new Integer(propertyVal);
                        Integer iCompValue = new Integer(rule.getCompValue());
                        if (!this.satisfiesComparison(iPropertyVal, iCompValue, rule.getCompCondition())) continue;
                        applicableRules.add(rule);
                    }
                    catch (NumberFormatException nfe) {
                        logger.debug((Object)"numeric conversion failed, reverting to lexical comparison");
                        if (!this.satisfiesComparison((Comparable)((Object)propertyVal), (Comparable)((Object)rule.getCompValue()), rule.getCompCondition())) continue;
                        applicableRules.add(rule);
                    }
                }
                catch (NoSuchMethodException nsme) {
                    logger.error((Object)("mappingrules.properties references an non-existent column from SQLColumn: " + rule.getCompField()));
                }
                catch (IllegalAccessException iae) {
                    logger.error((Object)("SQLColumn getter was not public: " + rule.getCompField()));
                }
                catch (InvocationTargetException ite) {
                    logger.error((Object)("SQLColumn getter threw an exception: " + rule.getCompField()));
                }
            }
        }
        return applicableRules;
    }

    protected boolean satisfiesComparison(Comparable c1, Comparable c2, String operator) {
        return c1.compareTo(c2) == 0 && operator.equals("=") || c1.compareTo(c2) > 0 && operator.equals(">") || c1.compareTo(c2) < 0 && operator.equals("<");
    }

    public boolean applyRules(SQLColumn col) {
        List mappingRules = this.getRules(col);
        for (MappingRule rule : mappingRules) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("modifying SQLColumn, field=" + rule.getModifyField() + ", value=" + rule.getModifyValue()));
                }
                BeanUtils.setProperty((Object)col, (String)rule.getModifyField(), (Object)rule.getModifyValue());
            }
            catch (ConversionException ce) {
                logger.error((Object)("Tried to set a numeric value with a non-numeric String: " + rule.getModifyField()));
            }
            catch (IllegalAccessException iae) {
                logger.error((Object)("SQLColumn getter was not public: " + rule.getModifyField()));
            }
            catch (InvocationTargetException ite) {
                logger.error((Object)("SQLColumn setter threw an exception: " + rule.getModifyField()));
            }
        }
        return mappingRules.size() > 0;
    }

    public String translateDatabaseName(String name) {
        return this.SPACE_STRIPPER.matcher(name).replaceAll("").toLowerCase();
    }

    static {
        IntegerConverter myConverter = new IntegerConverter();
        ConvertUtils.register((Converter)myConverter, Integer.TYPE);
        ConvertUtils.register((Converter)myConverter, Integer.class);
    }

    public class MappingRule {
        String database;
        String nativeType;
        String compField;
        String compCondition;
        String compValue;
        String modifyField;
        String modifyValue;

        public String getCompCondition() {
            return this.compCondition;
        }

        public void setCompCondition(String compCondition) {
            this.compCondition = compCondition;
        }

        public String getCompField() {
            return this.compField;
        }

        public void setCompField(String compField) {
            this.compField = compField;
        }

        public String getCompValue() {
            return this.compValue;
        }

        public void setCompValue(String compValue) {
            this.compValue = compValue;
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public String getModifyField() {
            return this.modifyField;
        }

        public void setModifyField(String modifyField) {
            this.modifyField = modifyField;
        }

        public String getModifyValue() {
            return this.modifyValue;
        }

        public void setModifyValue(String modifyValue) {
            this.modifyValue = modifyValue;
        }

        public String getNativeType() {
            return this.nativeType;
        }

        public void setNativeType(String nativeType) {
            this.nativeType = nativeType;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("database=" + this.getDatabase());
            sb.append(",nativeType=" + this.getNativeType());
            sb.append(",compField=" + this.getCompField());
            sb.append(",compCondition=" + this.getCompCondition());
            sb.append(",compValue=" + this.getCompValue());
            sb.append(",modifyField=" + this.getModifyField());
            sb.append(",modifyValue=" + this.getModifyValue());
            return sb.toString();
        }
    }
}

