/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.architect.swingui.SQLObjectCompare;
import java.awt.Color;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareSchemaWorker
implements Runnable {
    private static final Logger logger = Logger.getLogger(CompareSchemaWorker.class);
    private TreeSet<SQLTable> sourceTableList;
    private TreeSet<SQLTable> targetTableList;
    private AbstractDocument sourceDiff;
    private AbstractDocument targetDiff;
    private SimpleAttributeSet attrsDelete = null;
    private SimpleAttributeSet attrsAdd = null;
    private SimpleAttributeSet attrsDefault = null;
    private SimpleAttributeSet attrsModify = null;
    int jobSize;
    int progress;
    private boolean finished;
    private Map<Integer, GenericTypeDescriptor> sourceType;
    private Map<Integer, GenericTypeDescriptor> targetType;

    public CompareSchemaWorker(TreeSet<SQLTable> sourceTableList, TreeSet<SQLTable> targetTableList, AbstractDocument sourceDiff, AbstractDocument targetDiff, Map<Integer, GenericTypeDescriptor> leftType, Map<Integer, GenericTypeDescriptor> rightType) {
        this(sourceTableList, targetTableList, leftType, rightType);
        this.sourceDiff = sourceDiff;
        this.targetDiff = targetDiff;
    }

    public CompareSchemaWorker(TreeSet<SQLTable> sourceTableSet, TreeSet<SQLTable> targetTableSet, AbstractDocument sqlDiff, Map<Integer, GenericTypeDescriptor> typeMap, Map<Integer, GenericTypeDescriptor> typeMap2, GenericDDLGenerator sqlDdlgen) {
        this(sourceTableSet, targetTableSet, typeMap, typeMap2);
    }

    private CompareSchemaWorker(TreeSet<SQLTable> sourceTableSet, TreeSet<SQLTable> targetTableSet, Map<Integer, GenericTypeDescriptor> typeMap, Map<Integer, GenericTypeDescriptor> typeMap2) {
        this.targetType = typeMap2;
        this.sourceType = typeMap;
        this.sourceTableList = sourceTableSet;
        this.targetTableList = targetTableSet;
        this.jobSize = this.targetTableList.size() + this.sourceTableList.size();
        this.progress = 0;
        this.finished = false;
        this.attrsDelete = new SimpleAttributeSet();
        this.attrsAdd = new SimpleAttributeSet();
        this.attrsDefault = new SimpleAttributeSet();
        this.attrsModify = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attrsDelete, Color.red);
        StyleConstants.setForeground(this.attrsAdd, Color.green);
        StyleConstants.setForeground(this.attrsModify, Color.yellow);
        StyleConstants.setForeground(this.attrsDefault, Color.black);
    }

    public int getJobSize() {
        return this.jobSize;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void run() {
        this.generateTableDiffs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateTableDiffs() {
        try {
            SQLTable targetTable;
            boolean targetContinue;
            SQLTable sourceTable;
            boolean sourceContinue;
            Iterator<SQLTable> sourceIter = this.sourceTableList.iterator();
            Iterator<SQLTable> targetIter = this.targetTableList.iterator();
            if (sourceIter.hasNext()) {
                sourceContinue = true;
                sourceTable = sourceIter.next();
            } else {
                sourceContinue = false;
                sourceTable = null;
            }
            if (targetIter.hasNext()) {
                targetContinue = true;
                targetTable = targetIter.next();
            } else {
                targetContinue = false;
                targetTable = null;
            }
            block5: while (sourceContinue && targetContinue) {
                SQLObjectCompare comparator = new SQLObjectCompare();
                while (comparator.compare(sourceTable, targetTable) < 0) {
                    if (this.targetDiff != null) {
                        this.targetDiff.insertString(this.targetDiff.getLength(), this.printTable(sourceTable, printType.MISSING), this.attrsAdd);
                    }
                    if (this.sourceDiff != null) {
                        this.sourceDiff.insertString(this.sourceDiff.getLength(), this.printTable(sourceTable, printType.ADDED), this.attrsDelete);
                    }
                    this.generateColumnDiffs(sourceTable, null);
                    if (sourceIter.hasNext()) {
                        sourceTable = sourceIter.next();
                        continue;
                    }
                    sourceContinue = false;
                    break;
                }
                while (comparator.compare(sourceTable, targetTable) > 0) {
                    if (this.targetDiff != null) {
                        this.targetDiff.insertString(this.targetDiff.getLength(), this.printTable(targetTable, printType.ADDED), this.attrsDelete);
                    }
                    if (this.sourceDiff != null) {
                        this.sourceDiff.insertString(this.sourceDiff.getLength(), this.printTable(targetTable, printType.MISSING), this.attrsAdd);
                    }
                    this.generateColumnDiffs(null, targetTable);
                    if (targetIter.hasNext()) {
                        targetTable = targetIter.next();
                        continue;
                    }
                    targetContinue = false;
                    break;
                }
                while (comparator.compare(sourceTable, targetTable) == 0) {
                    if (this.targetDiff != null) {
                        this.targetDiff.insertString(this.targetDiff.getLength(), this.printTable(targetTable, printType.SAME), this.attrsDefault);
                    }
                    if (this.sourceDiff != null) {
                        this.sourceDiff.insertString(this.sourceDiff.getLength(), this.printTable(targetTable, printType.SAME), this.attrsDefault);
                    }
                    this.generateColumnDiffs(sourceTable, targetTable);
                    if (!targetIter.hasNext()) {
                        targetContinue = false;
                        continue block5;
                    }
                    targetTable = targetIter.next();
                    if (sourceIter.hasNext()) {
                        sourceTable = sourceIter.next();
                        continue;
                    }
                    sourceContinue = false;
                    continue block5;
                }
            }
            while (sourceContinue) {
                if (this.targetDiff != null) {
                    this.targetDiff.insertString(this.targetDiff.getLength(), "Missing table: " + sourceTable.getName() + "\n", this.attrsAdd);
                }
                if (this.sourceDiff != null) {
                    this.sourceDiff.insertString(this.sourceDiff.getLength(), "Extra table: " + sourceTable.getName() + "\n", this.attrsDelete);
                }
                this.generateColumnDiffs(sourceTable, null);
                if (sourceIter.hasNext()) {
                    sourceTable = sourceIter.next();
                    continue;
                }
                sourceContinue = false;
            }
            while (targetContinue) {
                if (this.targetDiff != null) {
                    this.targetDiff.insertString(this.targetDiff.getLength(), "Extra table: " + targetTable.getName() + "\n", this.attrsDelete);
                }
                if (this.sourceDiff != null) {
                    this.sourceDiff.insertString(this.sourceDiff.getLength(), "Missing table: " + targetTable.getName() + "\n", this.attrsAdd);
                }
                this.generateColumnDiffs(null, targetTable);
                if (targetIter.hasNext()) {
                    targetTable = targetIter.next();
                    continue;
                }
                targetContinue = false;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        finally {
            this.finished = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }

    public void generateColumnDiffs(SQLTable sourceTable, SQLTable targetTable) {
        TreeSet<SQLColumn> sourceColumnList = new TreeSet<SQLColumn>(new SQLObjectCompare());
        TreeSet<SQLColumn> targetColumnList = new TreeSet<SQLColumn>(new SQLObjectCompare());
        boolean sourceColContinue = false;
        boolean targetColContinue = false;
        Iterator sourceColIter = null;
        Iterator targetColIter = null;
        SQLColumn sourceColumn = null;
        SQLColumn targetColumn = null;
        try {
            if (sourceTable != null) {
                for (SQLColumn col : sourceTable.getColumns()) {
                    sourceColumnList.add(col);
                }
            }
            if (targetTable != null) {
                for (SQLColumn col : targetTable.getColumns()) {
                    targetColumnList.add(col);
                }
            }
            if (sourceColumnList.size() == 0) {
                sourceColumnList = null;
                sourceColContinue = false;
            } else {
                sourceColIter = sourceColumnList.iterator();
                sourceColumn = (SQLColumn)sourceColIter.next();
                sourceColContinue = true;
            }
            if (targetColumnList.size() == 0) {
                targetColumnList = null;
                targetColContinue = false;
            } else {
                targetColIter = targetColumnList.iterator();
                targetColumn = (SQLColumn)targetColIter.next();
                targetColContinue = true;
            }
            block5: while (sourceColContinue && targetColContinue) {
                SQLObjectCompare colComparator = new SQLObjectCompare();
                while (colComparator.compare(sourceColumn, targetColumn) < 0) {
                    if (this.targetDiff != null) {
                        this.targetDiff.insertString(this.targetDiff.getLength(), this.printColumn(printType.MISSING, sourceColumn, null, this.sourceType), this.attrsAdd);
                    }
                    if (this.sourceDiff != null) {
                        this.sourceDiff.insertString(this.sourceDiff.getLength(), this.printColumn(printType.ADDED, sourceColumn, null, this.sourceType), this.attrsDelete);
                    }
                    if (sourceColIter.hasNext()) {
                        sourceColumn = (SQLColumn)sourceColIter.next();
                        continue;
                    }
                    sourceColContinue = false;
                    break;
                }
                while (colComparator.compare(sourceColumn, targetColumn) > 0) {
                    if (this.targetDiff != null) {
                        this.targetDiff.insertString(this.targetDiff.getLength(), this.printColumn(printType.ADDED, targetColumn, null, this.targetType), this.attrsDelete);
                    }
                    if (this.sourceDiff != null) {
                        this.sourceDiff.insertString(this.sourceDiff.getLength(), this.printColumn(printType.MISSING, targetColumn, null, this.targetType), this.attrsAdd);
                    }
                    if (targetColIter.hasNext()) {
                        targetColumn = (SQLColumn)targetColIter.next();
                        continue;
                    }
                    targetColContinue = false;
                    break;
                }
                while (colComparator.compare(sourceColumn, targetColumn) == 0) {
                    GenericTypeDescriptor td = this.targetType.get(targetColumn.getType());
                    if (targetColumn.getType() != sourceColumn.getType() || td.getHasPrecision() && targetColumn.getPrecision() != sourceColumn.getPrecision() || td.getHasScale() && targetColumn.getScale() != sourceColumn.getScale()) {
                        if (this.targetDiff != null) {
                            this.targetDiff.insertString(this.targetDiff.getLength(), this.printColumn(printType.MODIFY, targetColumn, sourceColumn, this.targetType), this.attrsModify);
                        }
                        if (this.sourceDiff != null) {
                            this.sourceDiff.insertString(this.sourceDiff.getLength(), this.printColumn(printType.MODIFY, sourceColumn, targetColumn, this.sourceType), this.attrsModify);
                        }
                    } else {
                        if (this.targetDiff != null) {
                            this.targetDiff.insertString(this.targetDiff.getLength(), this.printColumn(printType.SAME, targetColumn, null, this.targetType), this.attrsDefault);
                        }
                        if (this.sourceDiff != null) {
                            this.sourceDiff.insertString(this.sourceDiff.getLength(), this.printColumn(printType.SAME, targetColumn, null, this.targetType), this.attrsDefault);
                        }
                    }
                    if (targetColIter.hasNext()) {
                        targetColumn = (SQLColumn)targetColIter.next();
                    } else {
                        targetColContinue = false;
                    }
                    if (sourceColIter.hasNext()) {
                        sourceColumn = (SQLColumn)sourceColIter.next();
                    } else {
                        sourceColContinue = false;
                    }
                    if (sourceColContinue && targetColContinue) continue;
                    continue block5;
                }
            }
            while (sourceColContinue) {
                if (this.targetDiff != null) {
                    this.targetDiff.insertString(this.targetDiff.getLength(), this.printColumn(printType.MISSING, sourceColumn, null, this.sourceType), this.attrsAdd);
                }
                if (this.sourceDiff != null) {
                    this.sourceDiff.insertString(this.sourceDiff.getLength(), this.printColumn(printType.ADDED, sourceColumn, null, this.sourceType), this.attrsDelete);
                }
                if (sourceColIter.hasNext()) {
                    sourceColumn = (SQLColumn)sourceColIter.next();
                    continue;
                }
                sourceColContinue = false;
            }
            while (targetColContinue) {
                if (this.targetDiff != null) {
                    this.targetDiff.insertString(this.targetDiff.getLength(), this.printColumn(printType.ADDED, targetColumn, null, this.targetType), this.attrsDelete);
                }
                if (this.sourceDiff != null) {
                    this.sourceDiff.insertString(this.sourceDiff.getLength(), this.printColumn(printType.MISSING, targetColumn, null, this.targetType), this.attrsAdd);
                }
                if (targetColIter.hasNext()) {
                    targetColumn = (SQLColumn)targetColIter.next();
                    continue;
                }
                targetColContinue = false;
            }
        }
        catch (ArchitectException e) {
            logger.debug((Object)"Architect exception in compareSchemaWorker", (Throwable)e);
        }
        catch (BadLocationException e) {
            logger.debug((Object)"Wrong document size", (Throwable)e);
        }
    }

    private String printTable(SQLTable table, printType type) {
        StringBuffer text = new StringBuffer();
        if (type == printType.MISSING) {
            text.append("Missing table: ");
        } else if (type == printType.ADDED) {
            text.append("Extra table: ");
        } else {
            text.append("Same table: ");
        }
        text.append(table.getName() + "\n");
        return text.toString();
    }

    private String printColumn(printType type, SQLColumn originalColumn, SQLColumn modifyTo, Map<Integer, GenericTypeDescriptor> typeMap) {
        StringBuffer text = new StringBuffer();
        GenericTypeDescriptor td = typeMap.get(originalColumn.getType());
        if (type == printType.MODIFY && td != null) {
            GenericTypeDescriptor modifyTd = typeMap.get(modifyTo.getType());
            text.append("\tModify column " + originalColumn.getName() + " from type: " + td.getName());
            if (td.getHasPrecision()) {
                text.append("(" + originalColumn.getPrecision());
                if (td.getHasScale()) {
                    text.append("," + originalColumn.getScale());
                }
                text.append(")");
            }
            text.append(" to type: " + modifyTd.getName());
            if (modifyTd.getHasPrecision()) {
                text.append("(" + modifyTo.getPrecision());
                if (modifyTd.getHasScale()) {
                    text.append("," + modifyTo.getScale());
                }
                text.append(")");
            }
            text.append("\n");
        } else if (type == printType.MISSING) {
            text.append("\tMissing column: ");
        } else if (type == printType.ADDED) {
            text.append("\tExtra column: ");
        } else {
            text.append("\tSame column: ");
        }
        if (td != null && type != printType.MODIFY) {
            text.append(originalColumn.getName() + ": " + td.getName());
            if (td.getHasPrecision()) {
                text.append("(" + originalColumn.getPrecision());
                if (td.getHasScale()) {
                    text.append("," + originalColumn.getScale());
                }
                text.append(")");
            }
            text.append("\n");
        }
        return text.toString();
    }

    public AbstractDocument getLeftDiff() {
        return this.sourceDiff;
    }

    public void setLeftDiff(AbstractDocument leftDiff) {
        this.sourceDiff = leftDiff;
    }

    public AbstractDocument getTargetDiff() {
        return this.targetDiff;
    }

    public void setTargetDiff(AbstractDocument rightDiff) {
        this.targetDiff = rightDiff;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum printType {
        MISSING,
        ADDED,
        SAME,
        MODIFY;

    }
}

