/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLTable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class SQLTableListModel
implements ListModel,
SQLObjectListener {
    private static final Logger logger = Logger.getLogger(SQLTableListModel.class);
    protected SQLTable table;
    protected ArrayList listeners;

    public SQLTableListModel(SQLTable table) {
        this.table = table;
        this.listeners = new ArrayList();
    }

    public int getSize() {
        try {
            return this.table.getColumnsFolder().getChildCount();
        }
        catch (ArchitectException ex) {
            throw new RuntimeException("Couldn't get child count", ex);
        }
    }

    public Object getElementAt(int index) {
        try {
            return this.table.getColumnsFolder().getChild(index);
        }
        catch (ArchitectException ex) {
            throw new RuntimeException("Couldn't get child " + index, ex);
        }
    }

    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    protected void fireContentsChanged(int index0, int index1) {
        ListDataEvent e = new ListDataEvent(this, 0, index0, index1);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ListDataListener)it.next()).contentsChanged(e);
        }
    }

    protected void fireIntervalAdded(int index0, int index1) {
        ListDataEvent e = new ListDataEvent(this, 1, index0, index1);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ListDataListener)it.next()).intervalAdded(e);
        }
    }

    protected void fireIntervalRemoved(int index0, int index1) {
        ListDataEvent e = new ListDataEvent(this, 2, index0, index1);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ListDataListener)it.next()).intervalRemoved(e);
        }
    }

    public void dbChildrenInserted(SQLObjectEvent e) {
        int[] changedIndices = e.getChangedIndices();
        for (int i = 0; i < changedIndices.length; ++i) {
            this.fireIntervalAdded(changedIndices[i], changedIndices[i]);
        }
    }

    public void dbChildrenRemoved(SQLObjectEvent e) {
        int[] changedIndices = e.getChangedIndices();
        for (int i = 0; i < changedIndices.length; ++i) {
            this.fireIntervalRemoved(changedIndices[i], changedIndices[i]);
        }
    }

    public void dbObjectChanged(SQLObjectEvent e) {
        if (e.getSource() == this.table.getColumnsFolder()) {
            int[] changedIndices = e.getChangedIndices();
            for (int i = 0; i < changedIndices.length; ++i) {
                logger.debug((Object)("Firing contentsChanged event for index " + i));
                this.fireContentsChanged(changedIndices[i], changedIndices[i]);
            }
        } else if (e.getSource() instanceof SQLColumn) {
            try {
                int index = this.table.getColumns().indexOf(e.getSource());
                if (index >= 0) {
                    this.fireContentsChanged(index, index);
                }
            }
            catch (ArchitectException ex) {
                logger.error((Object)"Exception in dbObjectChanged", (Throwable)ex);
            }
        } else {
            logger.warn((Object)("Unexpected SQLObjectEvent: " + e));
        }
    }

    public void dbStructureChanged(SQLObjectEvent e) {
        int[] changedIndices = e.getChangedIndices();
        for (int i = 0; i < changedIndices.length; ++i) {
            this.fireContentsChanged(changedIndices[i], changedIndices[i]);
        }
    }
}

