/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbAppDispatch;
import com.sleepycat.db.DbClient;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbEnvFeedback;
import com.sleepycat.db.DbEnvFeedbackHandler;
import com.sleepycat.db.DbErrcall;
import com.sleepycat.db.DbErrorHandler;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbLock;
import com.sleepycat.db.DbLockNotGrantedException;
import com.sleepycat.db.DbLockRequest;
import com.sleepycat.db.DbLockStat;
import com.sleepycat.db.DbLogStat;
import com.sleepycat.db.DbLogc;
import com.sleepycat.db.DbLsn;
import com.sleepycat.db.DbMpoolFStat;
import com.sleepycat.db.DbMpoolStat;
import com.sleepycat.db.DbPanicHandler;
import com.sleepycat.db.DbPreplist;
import com.sleepycat.db.DbRepStat;
import com.sleepycat.db.DbRepTransport;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.DbTxnStat;
import com.sleepycat.db.Dbt;
import com.sleepycat.db.db_java;
import com.sleepycat.db.db_javaJNI;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;

public class DbEnv {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private Object dbenv_ref;
    private DbAppDispatch app_dispatch_handler;
    private DbEnvFeedbackHandler env_feedback_handler;
    private DbErrorHandler error_handler;
    private DbPanicHandler panic_handler;
    private DbRepTransport rep_transport_handler;
    private String errpfx;

    protected DbEnv(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected DbEnv() {
        this(0L, false);
    }

    protected void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(DbEnv dbEnv) {
        return dbEnv == null ? 0L : dbEnv.swigCPtr;
    }

    void initialize() {
        this.dbenv_ref = db_java.initDbEnvRef0(this, this);
        this.set_error_stream(System.err);
    }

    void cleanup() {
        this.swigCPtr = 0L;
        db_java.deleteRef0(this.dbenv_ref);
        this.dbenv_ref = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int n) throws DbException {
        try {
            this.close0(n);
        }
        finally {
            this.cleanup();
        }
    }

    private final int handle_app_dispatch(Dbt dbt, DbLsn dbLsn, int n) {
        return this.app_dispatch_handler.appDispatch(this, dbt, dbLsn, n);
    }

    private final void handle_env_feedback(int n, int n2) {
        this.env_feedback_handler.feedback(this, n, n2);
    }

    private final void handle_error(String string) {
        this.error_handler.error(this.errpfx, string);
    }

    private final void handle_panic(DbException dbException) {
        this.panic_handler.panic(this, dbException);
    }

    private final int handle_rep_transport(Dbt dbt, Dbt dbt2, DbLsn dbLsn, int n, int n2) throws DbException {
        return this.rep_transport_handler.send(this, dbt, dbt2, dbLsn, n, n2);
    }

    public void lock_vec(int n, int n2, DbLockRequest[] dbLockRequestArray, int n3, int n4) throws DbException {
        this.lockVector(n, n2, dbLockRequestArray, n3, n4);
    }

    public void lockVector(int n, int n2, DbLockRequest[] dbLockRequestArray, int n3, int n4) throws DbException {
        db_javaJNI.DbEnv_lock_vec(this.swigCPtr, n, n2, dbLockRequestArray, n3, n4);
    }

    public void open(String string, int n, int n2) throws DbException, FileNotFoundException {
        this.open0(string, n |= Db.DB_THREAD, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(String string, int n) throws DbException, FileNotFoundException {
        try {
            this.remove0(string, n);
        }
        finally {
            this.cleanup();
        }
    }

    public void set_cachesize(int n, int n2, int n3) throws DbException {
        this.set_cachesize((long)n * 0x40000000L + (long)n2, n3);
    }

    public String get_errpfx() {
        return this.getErrorPrefix();
    }

    public String getErrorPrefix() {
        return this.errpfx;
    }

    public void set_errcall(DbErrcall dbErrcall) throws DbException {
        final DbErrcall dbErrcall2 = dbErrcall;
        try {
            this.setErrorHandler(new DbErrorHandler(){

                public void error(String string, String string2) {
                    dbErrcall2.errcall(string, string2);
                }
            });
        }
        catch (DbException dbException) {
            System.err.println("Exception during DbEnv.setErrorHandler: " + dbException);
            dbException.printStackTrace(System.err);
        }
    }

    public void set_error_stream(OutputStream outputStream) {
        this.setErrorStream(outputStream);
    }

    public void setErrorStream(OutputStream outputStream) {
        final PrintWriter printWriter = new PrintWriter(outputStream);
        try {
            this.setErrorHandler(new DbErrorHandler(){

                public void error(String string, String string2) {
                    if (string != null) {
                        printWriter.print(string + ": ");
                    }
                    printWriter.println(string2);
                    printWriter.flush();
                }
            });
        }
        catch (DbException dbException) {
            System.err.println("Exception during DbEnv.setErrorHandler: " + dbException);
            dbException.printStackTrace(System.err);
        }
    }

    public void set_errpfx(String string) {
        this.setErrorPrefix(string);
    }

    public void setErrorPrefix(String string) {
        this.errpfx = string;
    }

    public void set_feedback(DbEnvFeedback dbEnvFeedback) throws DbException {
        final DbEnvFeedback dbEnvFeedback2 = dbEnvFeedback;
        this.setFeedbackHandler(new DbEnvFeedbackHandler(){

            public void feedback(DbEnv dbEnv, int n, int n2) {
                dbEnvFeedback2.feedback(dbEnv, n, n2);
            }
        });
    }

    public void set_rep_limit(int n, int n2) throws DbException {
        this.set_rep_limit((long)n * 0x40000000L + (long)n2);
    }

    public void set_tx_timestamp(Date date) throws DbException {
        this.setTxnTimestamp(date);
    }

    public void setTxnTimestamp(Date date) throws DbException {
        this.set_tx_timestamp0(date.getTime() / 1000L);
    }

    public DbEnv(int n) throws DbException {
        this(db_javaJNI.new_DbEnv(n), true);
        this.initialize();
    }

    void close0(int n) {
        db_javaJNI.DbEnv_close0(this.swigCPtr, n);
    }

    public void dbremove(DbTxn dbTxn, String string, String string2, int n) throws DbException, DbDeadlockException, DbLockNotGrantedException, FileNotFoundException {
        this.dbRemove(dbTxn, string, string2, n);
    }

    public void dbRemove(DbTxn dbTxn, String string, String string2, int n) throws DbException, DbDeadlockException, DbLockNotGrantedException, FileNotFoundException {
        db_javaJNI.DbEnv_dbremove(this.swigCPtr, DbTxn.getCPtr(dbTxn), string, string2, n);
    }

    public void dbrename(DbTxn dbTxn, String string, String string2, String string3, int n) throws DbException, DbDeadlockException, DbLockNotGrantedException, FileNotFoundException {
        this.dbRename(dbTxn, string, string2, string3, n);
    }

    public void dbRename(DbTxn dbTxn, String string, String string2, String string3, int n) throws DbException, DbDeadlockException, DbLockNotGrantedException, FileNotFoundException {
        db_javaJNI.DbEnv_dbrename(this.swigCPtr, DbTxn.getCPtr(dbTxn), string, string2, string3, n);
    }

    public void err(int n, String string) {
        db_javaJNI.DbEnv_err(this.swigCPtr, n, string);
    }

    public void errx(String string) {
        db_javaJNI.DbEnv_errx(this.swigCPtr, string);
    }

    public String[] get_data_dirs() throws DbException {
        return this.getDataDirs();
    }

    public String[] getDataDirs() throws DbException {
        return db_javaJNI.DbEnv_get_data_dirs(this.swigCPtr);
    }

    public int get_encrypt_flags() throws DbException {
        return this.getEncryptFlags();
    }

    public int getEncryptFlags() throws DbException {
        return db_javaJNI.DbEnv_get_encrypt_flags(this.swigCPtr);
    }

    public int get_flags() throws DbException {
        return this.getFlags();
    }

    public int getFlags() throws DbException {
        return db_javaJNI.DbEnv_get_flags(this.swigCPtr);
    }

    public String get_home() throws DbException {
        return this.getDbEnvHome();
    }

    public String getDbEnvHome() throws DbException {
        return db_javaJNI.DbEnv_get_home(this.swigCPtr);
    }

    public int get_open_flags() throws DbException {
        return this.getOpenFlags();
    }

    public int getOpenFlags() throws DbException {
        return db_javaJNI.DbEnv_get_open_flags(this.swigCPtr);
    }

    public long get_shm_key() throws DbException {
        return this.getSegmentId();
    }

    public long getSegmentId() throws DbException {
        return db_javaJNI.DbEnv_get_shm_key(this.swigCPtr);
    }

    public int get_tas_spins() throws DbException {
        return this.getTestAndSetSpins();
    }

    public int getTestAndSetSpins() throws DbException {
        return db_javaJNI.DbEnv_get_tas_spins(this.swigCPtr);
    }

    public String get_tmp_dir() throws DbException {
        return this.getTmpDir();
    }

    public String getTmpDir() throws DbException {
        return db_javaJNI.DbEnv_get_tmp_dir(this.swigCPtr);
    }

    public boolean get_verbose(int n) throws DbException {
        return this.getVerbose(n);
    }

    public boolean getVerbose(int n) throws DbException {
        return db_javaJNI.DbEnv_get_verbose(this.swigCPtr, n);
    }

    void open0(String string, int n, int n2) {
        db_javaJNI.DbEnv_open0(this.swigCPtr, string, n, n2);
    }

    void remove0(String string, int n) {
        db_javaJNI.DbEnv_remove0(this.swigCPtr, string, n);
    }

    public void set_cachesize(long l, int n) throws DbException {
        this.setCacheSize(l, n);
    }

    public void setCacheSize(long l, int n) throws DbException {
        db_javaJNI.DbEnv_set_cachesize(this.swigCPtr, l, n);
    }

    public void set_data_dir(String string) throws DbException {
        this.setDataDir(string);
    }

    public void setDataDir(String string) throws DbException {
        db_javaJNI.DbEnv_set_data_dir(this.swigCPtr, string);
    }

    public void set_encrypt(String string, int n) throws DbException {
        this.setEncrypted(string, n);
    }

    public void setEncrypted(String string, int n) throws DbException {
        db_javaJNI.DbEnv_set_encrypt(this.swigCPtr, string, n);
    }

    public void setErrorHandler(DbErrorHandler dbErrorHandler) throws DbException {
        this.error_handler = dbErrorHandler;
        db_javaJNI.DbEnv_setErrorHandler(this.swigCPtr, this.error_handler);
    }

    public void set_flags(int n, boolean bl) throws DbException {
        this.setFlags(n, bl);
    }

    public void setFlags(int n, boolean bl) throws DbException {
        db_javaJNI.DbEnv_set_flags(this.swigCPtr, n, bl);
    }

    public void setFeedbackHandler(DbEnvFeedbackHandler dbEnvFeedbackHandler) throws DbException {
        this.env_feedback_handler = dbEnvFeedbackHandler;
        db_javaJNI.DbEnv_setFeedbackHandler(this.swigCPtr, this.env_feedback_handler);
    }

    public void set_mp_mmapsize(long l) throws DbException {
        this.setMemoryPoolMapSize(l);
    }

    public void setMemoryPoolMapSize(long l) throws DbException {
        db_javaJNI.DbEnv_set_mp_mmapsize(this.swigCPtr, l);
    }

    public void setPanicHandler(DbPanicHandler dbPanicHandler) throws DbException {
        this.panic_handler = dbPanicHandler;
        db_javaJNI.DbEnv_setPanicHandler(this.swigCPtr, this.panic_handler);
    }

    public void set_rpc_server(DbClient dbClient, String string, long l, long l2, int n) throws DbException {
        this.setRpcServer(dbClient, string, l, l2, n);
    }

    public void setRpcServer(DbClient dbClient, String string, long l, long l2, int n) throws DbException {
        db_javaJNI.DbEnv_set_rpc_server(this.swigCPtr, dbClient, string, l, l2, n);
    }

    public void set_shm_key(long l) throws DbException {
        this.setSegmentId(l);
    }

    public void setSegmentId(long l) throws DbException {
        db_javaJNI.DbEnv_set_shm_key(this.swigCPtr, l);
    }

    public void set_tas_spins(int n) throws DbException {
        this.setTestAndSetSpins(n);
    }

    public void setTestAndSetSpins(int n) throws DbException {
        db_javaJNI.DbEnv_set_tas_spins(this.swigCPtr, n);
    }

    public void set_timeout(long l, int n) throws DbException {
        this.setTimeout(l, n);
    }

    public void setTimeout(long l, int n) throws DbException {
        db_javaJNI.DbEnv_set_timeout(this.swigCPtr, l, n);
    }

    public void set_tmp_dir(String string) throws DbException {
        this.setTmpDir(string);
    }

    public void setTmpDir(String string) throws DbException {
        db_javaJNI.DbEnv_set_tmp_dir(this.swigCPtr, string);
    }

    public void set_tx_max(int n) throws DbException {
        this.setTxnMax(n);
    }

    public void setTxnMax(int n) throws DbException {
        db_javaJNI.DbEnv_set_tx_max(this.swigCPtr, n);
    }

    public void set_app_dispatch(DbAppDispatch dbAppDispatch) throws DbException {
        this.setAppDispatch(dbAppDispatch);
    }

    public void setAppDispatch(DbAppDispatch dbAppDispatch) throws DbException {
        this.app_dispatch_handler = dbAppDispatch;
        db_javaJNI.DbEnv_set_app_dispatch(this.swigCPtr, this.app_dispatch_handler);
    }

    void set_tx_timestamp0(long l) {
        db_javaJNI.DbEnv_set_tx_timestamp0(this.swigCPtr, l);
    }

    public void set_verbose(int n, boolean bl) throws DbException {
        this.setVerbose(n, bl);
    }

    public void setVerbose(int n, boolean bl) throws DbException {
        db_javaJNI.DbEnv_set_verbose(this.swigCPtr, n, bl);
    }

    public byte[][] get_lk_conflicts() throws DbException {
        return this.getLockConflicts();
    }

    public byte[][] getLockConflicts() throws DbException {
        return db_javaJNI.DbEnv_get_lk_conflicts(this.swigCPtr);
    }

    public int get_lk_detect() throws DbException {
        return this.getLockDetect();
    }

    public int getLockDetect() throws DbException {
        return db_javaJNI.DbEnv_get_lk_detect(this.swigCPtr);
    }

    public int get_lk_max_locks() throws DbException {
        return this.getLockMaxLocks();
    }

    public int getLockMaxLocks() throws DbException {
        return db_javaJNI.DbEnv_get_lk_max_locks(this.swigCPtr);
    }

    public int get_lk_max_lockers() throws DbException {
        return this.getLockMaxLockers();
    }

    public int getLockMaxLockers() throws DbException {
        return db_javaJNI.DbEnv_get_lk_max_lockers(this.swigCPtr);
    }

    public int get_lk_max_objects() throws DbException {
        return this.getLockMaxObjects();
    }

    public int getLockMaxObjects() throws DbException {
        return db_javaJNI.DbEnv_get_lk_max_objects(this.swigCPtr);
    }

    public int lock_detect(int n, int n2) throws DbException {
        return this.lockDetect(n, n2);
    }

    public int lockDetect(int n, int n2) throws DbException {
        return db_javaJNI.DbEnv_lock_detect(this.swigCPtr, n, n2);
    }

    public DbLock lock_get(int n, int n2, Dbt dbt, int n3) throws DbException {
        return this.lockGet(n, n2, dbt, n3);
    }

    public DbLock lockGet(int n, int n2, Dbt dbt, int n3) throws DbException {
        long l = db_javaJNI.DbEnv_lock_get(this.swigCPtr, n, n2, dbt, n3);
        return l == 0L ? null : new DbLock(l, true);
    }

    public int lock_id() throws DbException {
        return this.lockId();
    }

    public int lockId() throws DbException {
        return db_javaJNI.DbEnv_lock_id(this.swigCPtr);
    }

    public void lock_id_free(int n) throws DbException {
        this.lockIdFree(n);
    }

    public void lockIdFree(int n) throws DbException {
        db_javaJNI.DbEnv_lock_id_free(this.swigCPtr, n);
    }

    public void lock_put(DbLock dbLock) throws DbException {
        this.lockPut(dbLock);
    }

    public void lockPut(DbLock dbLock) throws DbException {
        db_javaJNI.DbEnv_lock_put(this.swigCPtr, DbLock.getCPtr(dbLock));
    }

    public DbLockStat lock_stat(int n) throws DbException {
        return this.lockStat(n);
    }

    public DbLockStat lockStat(int n) throws DbException {
        return db_javaJNI.DbEnv_lock_stat(this.swigCPtr, n);
    }

    public void set_lk_conflicts(byte[][] byArray) throws DbException {
        this.setLockConflicts(byArray);
    }

    public void setLockConflicts(byte[][] byArray) throws DbException {
        db_javaJNI.DbEnv_set_lk_conflicts(this.swigCPtr, byArray);
    }

    public void set_lk_detect(int n) throws DbException {
        this.setLockDetect(n);
    }

    public void setLockDetect(int n) throws DbException {
        db_javaJNI.DbEnv_set_lk_detect(this.swigCPtr, n);
    }

    public void set_lk_max_lockers(int n) throws DbException {
        this.setLockMaxLockers(n);
    }

    public void setLockMaxLockers(int n) throws DbException {
        db_javaJNI.DbEnv_set_lk_max_lockers(this.swigCPtr, n);
    }

    public void set_lk_max_locks(int n) throws DbException {
        this.setLockMaxLocks(n);
    }

    public void setLockMaxLocks(int n) throws DbException {
        db_javaJNI.DbEnv_set_lk_max_locks(this.swigCPtr, n);
    }

    public void set_lk_max_objects(int n) throws DbException {
        this.setLockMaxObjects(n);
    }

    public void setLockMaxObjects(int n) throws DbException {
        db_javaJNI.DbEnv_set_lk_max_objects(this.swigCPtr, n);
    }

    public int get_lg_bsize() throws DbException {
        return this.getLogBufferSize();
    }

    public int getLogBufferSize() throws DbException {
        return db_javaJNI.DbEnv_get_lg_bsize(this.swigCPtr);
    }

    public String get_lg_dir() throws DbException {
        return this.getLogDir();
    }

    public String getLogDir() throws DbException {
        return db_javaJNI.DbEnv_get_lg_dir(this.swigCPtr);
    }

    public int get_lg_max() throws DbException {
        return this.getLogMax();
    }

    public int getLogMax() throws DbException {
        return db_javaJNI.DbEnv_get_lg_max(this.swigCPtr);
    }

    public int get_lg_regionmax() throws DbException {
        return this.getLogRegionMax();
    }

    public int getLogRegionMax() throws DbException {
        return db_javaJNI.DbEnv_get_lg_regionmax(this.swigCPtr);
    }

    public String[] log_archive(int n) throws DbException {
        return this.logArchive(n);
    }

    public String[] logArchive(int n) throws DbException {
        return db_javaJNI.DbEnv_log_archive(this.swigCPtr, n);
    }

    public static int log_compare(DbLsn dbLsn, DbLsn dbLsn2) {
        return DbEnv.logCompare(dbLsn, dbLsn2);
    }

    public static int logCompare(DbLsn dbLsn, DbLsn dbLsn2) {
        return db_javaJNI.DbEnv_log_compare(DbLsn.getCPtr(dbLsn), DbLsn.getCPtr(dbLsn2));
    }

    public DbLogc log_cursor(int n) throws DbException {
        return this.logCursor(n);
    }

    public DbLogc logCursor(int n) throws DbException {
        long l = db_javaJNI.DbEnv_log_cursor(this.swigCPtr, n);
        return l == 0L ? null : new DbLogc(l, true);
    }

    public String log_file(DbLsn dbLsn) throws DbException {
        return this.logFile(dbLsn);
    }

    public String logFile(DbLsn dbLsn) throws DbException {
        return db_javaJNI.DbEnv_log_file(this.swigCPtr, DbLsn.getCPtr(dbLsn));
    }

    public void log_flush(DbLsn dbLsn) throws DbException {
        this.logFlush(dbLsn);
    }

    public void logFlush(DbLsn dbLsn) throws DbException {
        db_javaJNI.DbEnv_log_flush(this.swigCPtr, DbLsn.getCPtr(dbLsn));
    }

    public void log_put(DbLsn dbLsn, Dbt dbt, int n) throws DbException {
        this.logPut(dbLsn, dbt, n);
    }

    public void logPut(DbLsn dbLsn, Dbt dbt, int n) throws DbException {
        db_javaJNI.DbEnv_log_put(this.swigCPtr, DbLsn.getCPtr(dbLsn), dbt, n);
    }

    public DbLogStat log_stat(int n) throws DbException {
        return this.logStat(n);
    }

    public DbLogStat logStat(int n) throws DbException {
        return db_javaJNI.DbEnv_log_stat(this.swigCPtr, n);
    }

    public void set_lg_bsize(int n) throws DbException {
        this.setLogBufferSize(n);
    }

    public void setLogBufferSize(int n) throws DbException {
        db_javaJNI.DbEnv_set_lg_bsize(this.swigCPtr, n);
    }

    public void set_lg_dir(String string) throws DbException {
        this.setLogDir(string);
    }

    public void setLogDir(String string) throws DbException {
        db_javaJNI.DbEnv_set_lg_dir(this.swigCPtr, string);
    }

    public void set_lg_max(int n) throws DbException {
        this.setLogMax(n);
    }

    public void setLogMax(int n) throws DbException {
        db_javaJNI.DbEnv_set_lg_max(this.swigCPtr, n);
    }

    public void set_lg_regionmax(int n) throws DbException {
        this.setLogRegionMax(n);
    }

    public void setLogRegionMax(int n) throws DbException {
        db_javaJNI.DbEnv_set_lg_regionmax(this.swigCPtr, n);
    }

    public long get_cachesize() throws DbException {
        return this.getCacheSize();
    }

    public long getCacheSize() throws DbException {
        return db_javaJNI.DbEnv_get_cachesize(this.swigCPtr);
    }

    public int get_cachesize_ncache() throws DbException {
        return this.getCacheSizeNcache();
    }

    public int getCacheSizeNcache() throws DbException {
        return db_javaJNI.DbEnv_get_cachesize_ncache(this.swigCPtr);
    }

    public long get_mp_mmapsize() throws DbException {
        return this.getMemoryPoolMapSize();
    }

    public long getMemoryPoolMapSize() throws DbException {
        return db_javaJNI.DbEnv_get_mp_mmapsize(this.swigCPtr);
    }

    public DbMpoolStat memp_stat(int n) throws DbException {
        return this.memoryPoolStat(n);
    }

    public DbMpoolStat memoryPoolStat(int n) throws DbException {
        return db_javaJNI.DbEnv_memp_stat(this.swigCPtr, n);
    }

    public DbMpoolFStat[] memp_fstat(int n) throws DbException {
        return this.memoryPoolFileStat(n);
    }

    public DbMpoolFStat[] memoryPoolFileStat(int n) throws DbException {
        return db_javaJNI.DbEnv_memp_fstat(this.swigCPtr, n);
    }

    public int memp_trickle(int n) throws DbException {
        return this.memoryPoolTrickle(n);
    }

    public int memoryPoolTrickle(int n) throws DbException {
        return db_javaJNI.DbEnv_memp_trickle(this.swigCPtr, n);
    }

    public int get_tx_max() throws DbException {
        return this.getTxnMax();
    }

    public int getTxnMax() throws DbException {
        return db_javaJNI.DbEnv_get_tx_max(this.swigCPtr);
    }

    public long get_tx_timestamp() throws DbException {
        return this.getTxnTimestamp();
    }

    public long getTxnTimestamp() throws DbException {
        return db_javaJNI.DbEnv_get_tx_timestamp(this.swigCPtr);
    }

    public long get_timeout(int n) throws DbException {
        return this.getTimeout(n);
    }

    public long getTimeout(int n) throws DbException {
        return db_javaJNI.DbEnv_get_timeout(this.swigCPtr, n);
    }

    public DbTxn txn_begin(DbTxn dbTxn, int n) throws DbException {
        return this.txnBegin(dbTxn, n);
    }

    public DbTxn txnBegin(DbTxn dbTxn, int n) throws DbException {
        long l = db_javaJNI.DbEnv_txn_begin(this.swigCPtr, DbTxn.getCPtr(dbTxn), n);
        return l == 0L ? null : new DbTxn(l, false);
    }

    public void txn_checkpoint(int n, int n2, int n3) throws DbException {
        this.txnCheckpoint(n, n2, n3);
    }

    public void txnCheckpoint(int n, int n2, int n3) throws DbException {
        db_javaJNI.DbEnv_txn_checkpoint(this.swigCPtr, n, n2, n3);
    }

    public DbPreplist[] txn_recover(int n, int n2) throws DbException {
        return this.txnRecover(n, n2);
    }

    public DbPreplist[] txnRecover(int n, int n2) throws DbException {
        return db_javaJNI.DbEnv_txn_recover(this.swigCPtr, n, n2);
    }

    public DbTxnStat txn_stat(int n) throws DbException {
        return this.txnStat(n);
    }

    public DbTxnStat txnStat(int n) throws DbException {
        return db_javaJNI.DbEnv_txn_stat(this.swigCPtr, n);
    }

    public long get_rep_limit() throws DbException {
        return this.getReplicationLimit();
    }

    public long getReplicationLimit() throws DbException {
        return db_javaJNI.DbEnv_get_rep_limit(this.swigCPtr);
    }

    public int rep_elect(int n, int n2, int n3) throws DbException {
        return this.replicationElect(n, n2, n3);
    }

    public int replicationElect(int n, int n2, int n3) throws DbException {
        return db_javaJNI.DbEnv_rep_elect(this.swigCPtr, n, n2, n3);
    }

    public int rep_process_message(Dbt dbt, Dbt dbt2, RepProcessMessage repProcessMessage, DbLsn dbLsn) throws DbException {
        return this.replicationProcessMessage(dbt, dbt2, repProcessMessage, dbLsn);
    }

    public int replicationProcessMessage(Dbt dbt, Dbt dbt2, RepProcessMessage repProcessMessage, DbLsn dbLsn) throws DbException {
        return db_javaJNI.DbEnv_rep_process_message(this.swigCPtr, dbt, dbt2, repProcessMessage, DbLsn.getCPtr(dbLsn));
    }

    public void rep_start(Dbt dbt, int n) throws DbException {
        this.replicationStart(dbt, n);
    }

    public void replicationStart(Dbt dbt, int n) throws DbException {
        db_javaJNI.DbEnv_rep_start(this.swigCPtr, dbt, n);
    }

    public DbRepStat rep_stat(int n) throws DbException {
        return this.replicationStat(n);
    }

    public DbRepStat replicationStat(int n) throws DbException {
        return db_javaJNI.DbEnv_rep_stat(this.swigCPtr, n);
    }

    public void set_rep_limit(long l) throws DbException {
        this.setReplicationLimit(l);
    }

    public void setReplicationLimit(long l) throws DbException {
        db_javaJNI.DbEnv_set_rep_limit(this.swigCPtr, l);
    }

    public void set_rep_transport(int n, DbRepTransport dbRepTransport) throws DbException {
        this.setReplicationTransport(n, dbRepTransport);
    }

    public void setReplicationTransport(int n, DbRepTransport dbRepTransport) throws DbException {
        this.rep_transport_handler = dbRepTransport;
        db_javaJNI.DbEnv_set_rep_transport(this.swigCPtr, n, this.rep_transport_handler);
    }

    public static String strerror(int n) {
        return db_javaJNI.DbEnv_strerror(n);
    }

    public static int get_version_major() {
        return DbEnv.getVersionMajor();
    }

    public static int getVersionMajor() {
        return db_javaJNI.DbEnv_get_version_major();
    }

    public static int get_version_minor() {
        return DbEnv.getVersionMinor();
    }

    public static int getVersionMinor() {
        return db_javaJNI.DbEnv_get_version_minor();
    }

    public static int get_version_patch() {
        return DbEnv.getVersionPatch();
    }

    public static int getVersionPatch() {
        return db_javaJNI.DbEnv_get_version_patch();
    }

    public static String get_version_string() {
        return DbEnv.getVersionString();
    }

    public static String getVersionString() {
        return db_javaJNI.DbEnv_get_version_string();
    }

    public static class RepProcessMessage {
        public int envid;
    }
}

