/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.exporter.ui.contribution.base;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.ui.contribution.base.ModelConverterWizard;
import org.eclipse.emf.exporter.ExporterPlugin;
import org.eclipse.emf.exporter.ModelExporter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public abstract class ModelExporterWizard
extends ModelConverterWizard {
    protected static final String PREFERENCE_SAVE_EXPORTER = "ModelExporterWizard.SaveExporter";
    protected static final String PREFERENCE_SAVE_PACKAGE_URI = "ModelExporterWizard.SavePackageURI";

    public ModelExporter getModelExporter() {
        return (ModelExporter)this.getModelConverter();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        Object object = selection.getFirstElement();
        try {
            GenModel genModel;
            if (object instanceof IFile) {
                URI uri = URI.createPlatformResourceURI((String)((IFile)object).getFullPath().toString(), (boolean)true);
                this.getModelExporter().loadGenModel(uri);
            } else if (object instanceof GenModel) {
                this.getModelExporter().setGenModel((GenModel)object);
            }
            this.readPreferencesSettings();
            if (this.getModelExporter().getDirectoryURI() == null && (genModel = this.getModelExporter().getGenModel()) != null && genModel.eResource() != null) {
                URI uri = genModel.eResource().getURI().trimSegments(1);
                this.getModelExporter().setDirectoryURI(String.valueOf(uri.toString()) + "/");
            }
        }
        catch (DiagnosticException exception) {
            Diagnostic diagnostic = exception.getDiagnostic();
            ErrorDialog.openError((Shell)this.getShell(), (String)GenModelEditPlugin.INSTANCE.getString("_UI_ModelProblems_title"), (String)ExporterPlugin.INSTANCE.getString("_UI_InvalidModel_message"), (IStatus)BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
        }
    }

    protected void readPreferencesSettings() {
        Preferences preferences = ExporterPlugin.getPlugin().getPluginPreferences();
        ModelExporter modelExporter = this.getModelExporter();
        modelExporter.setSaveEPackageArtifactURI(preferences.getBoolean(PREFERENCE_SAVE_PACKAGE_URI));
        modelExporter.setSaveExporter(preferences.getBoolean(PREFERENCE_SAVE_EXPORTER));
    }

    protected void writePreferencesSettings() {
        Preferences preferences = ExporterPlugin.getPlugin().getPluginPreferences();
        ModelExporter modelExporter = this.getModelExporter();
        preferences.setValue(PREFERENCE_SAVE_PACKAGE_URI, modelExporter.isSaveEPackageArtifactURI());
        preferences.setValue(PREFERENCE_SAVE_EXPORTER, modelExporter.isSaveExporter());
        ExporterPlugin.getPlugin().savePluginPreferences();
    }

    protected Diagnostic doPerformFinish(Monitor monitor) throws Exception {
        Diagnostic diagnostic = this.getModelExporter().export(monitor);
        this.getModelExporter().save();
        this.writePreferencesSettings();
        return diagnostic;
    }
}

