/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.npe.IsNullConditionDecision;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysisFeatures;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.util.Strings;
import edu.umd.cs.findbugs.util.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsNullValueFrame
extends Frame<IsNullValue> {
    private IsNullConditionDecision decision;
    private boolean trackValueNumbers;
    private Map<ValueNumber, IsNullValue> knownValueMap;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$npe$IsNullValueFrame;

    public IsNullValueFrame(int numLocals, boolean trackValueNumbers) {
        super(numLocals);
        this.trackValueNumbers = trackValueNumbers;
        if (trackValueNumbers) {
            this.knownValueMap = new HashMap<ValueNumber, IsNullValue>();
        }
    }

    public void cleanStaleKnowledge(ValueNumberFrame vnaFrameAfter) {
        if (vnaFrameAfter.isTop() && !this.isTop()) {
            throw new IllegalArgumentException("VNA frame is top");
        }
        if (!this.trackValueNumbers) {
            return;
        }
        if (!ValueNumberAnalysisFeatures.REDUNDANT_LOAD_ELIMINATION) {
            return;
        }
        Iterator<ValueNumber> i = this.knownValueMap.keySet().iterator();
        while (i.hasNext()) {
            ValueNumber v = i.next();
            if (vnaFrameAfter.getLoad(v) != null) continue;
            if (IsNullValueAnalysis.DEBUG) {
                System.out.println(new StringBuffer().append("PURGING ").append(v).toString());
            }
            i.remove();
        }
    }

    @Override
    public void setTop() {
        super.setTop();
        if (this.trackValueNumbers) {
            this.knownValueMap.clear();
        }
        this.decision = null;
    }

    public void toExceptionValues() {
        for (int i = 0; i < this.getNumSlots(); ++i) {
            this.setValue(i, ((IsNullValue)this.getValue(i)).toExceptionValue());
        }
        if (this.trackValueNumbers) {
            HashMap<ValueNumber, IsNullValue> replaceMap = new HashMap<ValueNumber, IsNullValue>();
            for (Map.Entry<ValueNumber, IsNullValue> entry : this.knownValueMap.entrySet()) {
                replaceMap.put(entry.getKey(), entry.getValue().toExceptionValue());
            }
            this.knownValueMap = replaceMap;
        }
    }

    public void setDecision(@CheckForNull IsNullConditionDecision decision) {
        this.decision = decision;
    }

    @CheckForNull
    public IsNullConditionDecision getDecision() {
        return this.decision;
    }

    public void setKnownValue(@NonNull ValueNumber valueNumber, @NonNull IsNullValue knownValue) {
        if (!$assertionsDisabled && !this.trackValueNumbers) {
            throw new AssertionError();
        }
        if (valueNumber == null || knownValue == null) {
            throw new NullPointerException();
        }
        this.knownValueMap.put(valueNumber, knownValue);
        if (IsNullValueAnalysis.DEBUG) {
            System.out.println(new StringBuffer().append("Updated information for ").append(valueNumber).toString());
            System.out.println(new StringBuffer().append("                    now ").append(this).toString());
        }
    }

    public void useNewValueNumberForLoad(ValueNumber oldValueNumber, ValueNumber newValueNumber) {
        if (oldValueNumber == null || newValueNumber == null) {
            throw new NullPointerException();
        }
        if (newValueNumber.equals(oldValueNumber) || !this.trackValueNumbers) {
            return;
        }
        IsNullValue isNullValue = this.knownValueMap.get(oldValueNumber);
        if (isNullValue != null) {
            this.knownValueMap.put(newValueNumber, isNullValue);
            this.knownValueMap.remove(oldValueNumber);
        }
    }

    public IsNullValue getKnownValue(ValueNumber valueNumber) {
        if (!$assertionsDisabled && !this.trackValueNumbers) {
            throw new AssertionError();
        }
        return this.knownValueMap.get(valueNumber);
    }

    public Collection<ValueNumber> getKnownValues() {
        if (this.trackValueNumbers) {
            return this.knownValueMap.keySet();
        }
        return TigerSubstitutes.emptySet();
    }

    public Collection<Map.Entry<ValueNumber, IsNullValue>> getKnownValueMapEntrySet() {
        if (this.trackValueNumbers) {
            return this.knownValueMap.entrySet();
        }
        return TigerSubstitutes.emptySet();
    }

    public void mergeKnownValuesWith(IsNullValueFrame otherFrame) {
        if (!$assertionsDisabled && !this.trackValueNumbers) {
            throw new AssertionError();
        }
        if (IsNullValueAnalysis.DEBUG) {
            System.out.println("merge");
            System.out.println(new StringBuffer().append("     ").append(this).toString());
            System.out.println(new StringBuffer().append(" with").append(otherFrame).toString());
        }
        HashMap<ValueNumber, IsNullValue> replaceMap = new HashMap<ValueNumber, IsNullValue>();
        for (Map.Entry<ValueNumber, IsNullValue> entry : this.knownValueMap.entrySet()) {
            IsNullValue otherKnownValue = otherFrame.knownValueMap.get(entry.getKey());
            if (otherKnownValue == null) {
                if (!IsNullValueAnalysis.DEBUG) continue;
                System.out.println(new StringBuffer().append("No match for ").append(entry.getKey()).toString());
                continue;
            }
            IsNullValue mergedValue = IsNullValue.merge(entry.getValue(), otherKnownValue);
            replaceMap.put(entry.getKey(), mergedValue);
            if (!IsNullValueAnalysis.DEBUG || mergedValue.equals(entry.getValue())) continue;
            System.out.println(new StringBuffer().append("Updated information for ").append(entry.getKey()).toString());
            System.out.println(new StringBuffer().append("                    was ").append(entry.getValue()).toString());
            System.out.println(new StringBuffer().append("           merged value ").append(mergedValue).toString());
        }
        this.knownValueMap.clear();
        this.knownValueMap.putAll(replaceMap);
        if (IsNullValueAnalysis.DEBUG) {
            System.out.println(new StringBuffer().append("resulting in ").append(this).toString());
        }
    }

    @Override
    public void copyFrom(Frame<IsNullValue> other) {
        super.copyFrom(other);
        this.decision = ((IsNullValueFrame)other).decision;
        if (this.trackValueNumbers) {
            this.knownValueMap = new HashMap<ValueNumber, IsNullValue>(((IsNullValueFrame)other).knownValueMap);
        }
    }

    @Override
    public boolean sameAs(Frame<IsNullValue> other) {
        if (!(other instanceof IsNullValueFrame)) {
            return false;
        }
        if (!super.sameAs(other)) {
            return false;
        }
        IsNullValueFrame o2 = (IsNullValueFrame)other;
        if (!Util.nullSafeEquals(this.decision, o2.decision)) {
            return false;
        }
        return !this.trackValueNumbers || Util.nullSafeEquals(this.knownValueMap, o2.knownValueMap);
    }

    @Override
    public String toString() {
        String result = super.toString();
        if (this.decision != null) {
            result = new StringBuffer().append(result).append(", [decision=").append(this.decision.toString()).append("]").toString();
        }
        if (this.knownValueMap != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("{");
            boolean first = true;
            for (Map.Entry<ValueNumber, IsNullValue> entry : this.knownValueMap.entrySet()) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(Strings.trimComma(entry.getKey().toString()));
                buf.append("->");
                buf.append(Strings.trimComma(entry.getValue().toString()));
            }
            buf.append("}");
            result = new StringBuffer().append(result).append(", [known=").append(buf.toString()).append("]").toString();
        }
        return result;
    }

    public void downgradeOnControlSplit() {
        int numSlots = this.getNumSlots();
        for (int i = 0; i < numSlots; ++i) {
            IsNullValue value = (IsNullValue)this.getValue(i);
            value = value.downgradeOnControlSplit();
            this.setValue(i, value);
        }
        if (this.knownValueMap != null) {
            for (Map.Entry<ValueNumber, IsNullValue> entry : this.knownValueMap.entrySet()) {
                entry.setValue(entry.getValue().downgradeOnControlSplit());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$ba$npe$IsNullValueFrame == null ? (class$edu$umd$cs$findbugs$ba$npe$IsNullValueFrame = IsNullValueFrame.class$("edu.umd.cs.findbugs.ba.npe.IsNullValueFrame")) : class$edu$umd$cs$findbugs$ba$npe$IsNullValueFrame).desiredAssertionStatus();
    }
}

