/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.ArtifactId;
import fr.jayasoft.ivy.DefaultDependencyDescriptor;
import fr.jayasoft.ivy.DependencyArtifactDescriptor;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.matcher.PatternMatcher;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

public class DefaultDependencyArtifactDescriptor
implements DependencyArtifactDescriptor {
    private DefaultDependencyDescriptor _dd;
    private ArtifactId _id;
    private Collection _confs = new ArrayList();
    private boolean _includes;
    private PatternMatcher _patternMatcher;
    private URL _url;

    public DefaultDependencyArtifactDescriptor(DefaultDependencyDescriptor dd, String name, String type, String ext, boolean includes, PatternMatcher matcher) {
        this(dd, name, type, ext, null, includes, matcher);
    }

    public DefaultDependencyArtifactDescriptor(DefaultDependencyDescriptor dd, String name, String type, String ext, URL url, boolean includes, PatternMatcher matcher) {
        if (dd == null) {
            throw new NullPointerException("dependency descriptor must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        this._dd = dd;
        this._id = new ArtifactId(dd.getDependencyId(), name, type, ext);
        this._includes = includes;
        this._url = url;
        this._patternMatcher = matcher;
    }

    public DefaultDependencyArtifactDescriptor(DefaultDependencyDescriptor dd, ArtifactId aid, boolean includes, PatternMatcher matcher) {
        if (dd == null) {
            throw new NullPointerException("dependency descriptor must not be null");
        }
        this._dd = dd;
        this._id = aid;
        this._includes = includes;
        this._patternMatcher = matcher;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DependencyArtifactDescriptor)) {
            return false;
        }
        DependencyArtifactDescriptor dad = (DependencyArtifactDescriptor)obj;
        return this.getId().equals(dad.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public void addConfiguration(String conf) {
        this._confs.add(conf);
        if (this._includes) {
            this._dd.addDependencyArtifactIncludes(conf, this);
        } else {
            this._dd.addDependencyArtifactExcludes(conf, this);
        }
    }

    public DependencyDescriptor getDependency() {
        return this._dd;
    }

    public ArtifactId getId() {
        return this._id;
    }

    public String getName() {
        return this._id.getName();
    }

    public String getType() {
        return this._id.getType();
    }

    public String getExt() {
        return this._id.getExt();
    }

    public String[] getConfigurations() {
        return this._confs.toArray(new String[this._confs.size()]);
    }

    public PatternMatcher getMatcher() {
        return this._patternMatcher;
    }

    public URL getUrl() {
        return this._url;
    }

    public String toString() {
        return (this._includes ? "I" : "E") + ":" + this._id + "(" + this._confs + ")" + (this._url == null ? "" : this._url.toString());
    }
}

