/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.launcher;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.util.RubyFileSelector;
import org.rubypeople.rdt.internal.ui.util.RubyProjectSelector;

public class RubyEntryPointTab
extends AbstractLaunchConfigurationTab {
    protected String originalFileName;
    protected String originalProjectName;
    protected RubyProjectSelector projectSelector;
    protected RubyFileSelector fileSelector;

    public void createControl(Composite composite) {
        Composite composite2 = this.createPageRoot(composite);
        new Label(composite2, 0).setText(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEntryPoint.projectLabel"));
        this.projectSelector = new RubyProjectSelector(composite2);
        this.projectSelector.setBrowseDialogMessage(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEntryPoint.projectSelectorMessage"));
        this.projectSelector.setLayoutData((Object)new GridData(768));
        this.projectSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RubyEntryPointTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(composite2, 0).setText(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEntryPoint.fileLabel"));
        this.fileSelector = new RubyFileSelector(composite2, this.projectSelector);
        this.fileSelector.setBrowseDialogMessage(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEntryPoint.fileSelectorMessage"));
        this.fileSelector.setLayoutData((Object)new GridData(768));
        this.fileSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RubyEntryPointTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IResource iResource = RubyPlugin.getDefault().getSelectedResource();
        if (!RubyPlugin.getDefault().isRubyFile(iResource)) {
            return;
        }
        IProject iProject = iResource.getProject();
        if (iProject == null || !RubyCore.isRubyProject((IProject)iProject)) {
            return;
        }
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.PROJECT_NAME", iProject.getName());
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.FILE_NAME", iResource.getProjectRelativePath().toString());
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            this.originalProjectName = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.PROJECT_NAME", "");
            this.originalFileName = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.FILE_NAME", "");
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
        this.projectSelector.setSelectionText(this.originalProjectName);
        if (this.originalFileName.length() != 0) {
            this.fileSelector.setSelectionText(new Path(this.originalFileName).toOSString());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.PROJECT_NAME", this.projectSelector.getSelectionText());
        IFile iFile = this.fileSelector.getSelection();
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.FILE_NAME", iFile == null ? "" : iFile.getProjectRelativePath().toString());
    }

    protected Composite createPageRoot(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.setControl((Control)composite2);
        return composite2;
    }

    public String getName() {
        return RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEntryPoint.name");
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.PROJECT_NAME", "");
            if (string.length() == 0) {
                this.setErrorMessage(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEntryPoint.invalidProjectSelectionMessage"));
                return false;
            }
            String string2 = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.FILE_NAME", "");
            if (string2.length() == 0) {
                this.setErrorMessage(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEntryPoint.invalidFileSelectionMessage"));
                return false;
            }
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void log(Throwable throwable) {
        RdtDebugUiPlugin.log(throwable);
    }

    public boolean canSave() {
        return this.getErrorMessage() == null;
    }

    public Image getImage() {
        return RubyPluginImages.get((String)"org.rubypeople.rdt.ui.ruby_page.gif");
    }
}

