/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCompletionProcessor;
import org.rubypeople.rdt.ui.text.IColorManager;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public class ContentAssistPreference {
    private static final String AUTOACTIVATION = "content_assist_autoactivation";
    private static final String AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    private static final String PROPOSALS_FOREGROUND = "content_assist_proposals_foreground";
    private static final String PROPOSALS_BACKGROUND = "content_assist_proposals_background";
    private static final String PARAMETERS_FOREGROUND = "content_assist_parameters_foreground";
    private static final String PARAMETERS_BACKGROUND = "content_assist_parameters_background";
    private static final String AUTOINSERT = "content_assist_autoinsert";
    private static final String PREFIX_COMPLETION = "content_assist_prefix_completion";

    public static void changeConfiguration(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore, PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (AUTOACTIVATION.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(AUTOACTIVATION);
            contentAssistant.enableAutoActivation(bl);
        } else if (AUTOACTIVATION_DELAY.equals(string)) {
            int n = iPreferenceStore.getInt(AUTOACTIVATION_DELAY);
            contentAssistant.setAutoActivationDelay(n);
        } else if (PROPOSALS_FOREGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_FOREGROUND);
            contentAssistant.setProposalSelectorForeground(color);
        } else if (PROPOSALS_BACKGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_BACKGROUND);
            contentAssistant.setProposalSelectorBackground(color);
        } else if (PARAMETERS_FOREGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_FOREGROUND);
            contentAssistant.setContextInformationPopupForeground(color);
            contentAssistant.setContextSelectorForeground(color);
        } else if (PARAMETERS_BACKGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_BACKGROUND);
            contentAssistant.setContextInformationPopupBackground(color);
            contentAssistant.setContextSelectorBackground(color);
        } else if (AUTOINSERT.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(AUTOINSERT);
            contentAssistant.enableAutoInsert(bl);
        } else if (PREFIX_COMPLETION.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(PREFIX_COMPLETION);
            contentAssistant.enablePrefixCompletion(bl);
        }
        ContentAssistPreference.changeRubyProcessor(contentAssistant, iPreferenceStore, string);
    }

    public static void configure(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore) {
        RubyTextTools rubyTextTools = RubyPlugin.getDefault().getRubyTextTools();
        IColorManager iColorManager = rubyTextTools.getColorManager();
        boolean bl = iPreferenceStore.getBoolean(AUTOACTIVATION);
        contentAssistant.enableAutoActivation(bl);
        int n = iPreferenceStore.getInt(AUTOACTIVATION_DELAY);
        contentAssistant.setAutoActivationDelay(n);
        Color color = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_FOREGROUND, iColorManager);
        contentAssistant.setProposalSelectorForeground(color);
        color = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_BACKGROUND, iColorManager);
        contentAssistant.setProposalSelectorBackground(color);
        color = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_FOREGROUND, iColorManager);
        contentAssistant.setContextInformationPopupForeground(color);
        contentAssistant.setContextSelectorForeground(color);
        color = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_BACKGROUND, iColorManager);
        contentAssistant.setContextInformationPopupBackground(color);
        contentAssistant.setContextSelectorBackground(color);
        bl = iPreferenceStore.getBoolean(AUTOINSERT);
        contentAssistant.enableAutoInsert(bl);
        bl = iPreferenceStore.getBoolean(PREFIX_COMPLETION);
        contentAssistant.enablePrefixCompletion(bl);
        ContentAssistPreference.configureRubyProcessor(contentAssistant, iPreferenceStore);
    }

    private static void configureRubyProcessor(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore) {
        RubyCompletionProcessor rubyCompletionProcessor = ContentAssistPreference.getRubyProcessor(contentAssistant);
        if (rubyCompletionProcessor == null) {
            return;
        }
    }

    private static Color getColor(IPreferenceStore iPreferenceStore, String string, IColorManager iColorManager) {
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
        return iColorManager.getColor(rGB);
    }

    private static Color getColor(IPreferenceStore iPreferenceStore, String string) {
        RubyTextTools rubyTextTools = RubyPlugin.getDefault().getRubyTextTools();
        return ContentAssistPreference.getColor(iPreferenceStore, string, rubyTextTools.getColorManager());
    }

    private static void changeRubyProcessor(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore, String string) {
        RubyCompletionProcessor rubyCompletionProcessor = ContentAssistPreference.getRubyProcessor(contentAssistant);
        if (rubyCompletionProcessor == null) {
            return;
        }
    }

    private static RubyCompletionProcessor getRubyProcessor(ContentAssistant contentAssistant) {
        IContentAssistProcessor iContentAssistProcessor = contentAssistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (iContentAssistProcessor instanceof RubyCompletionProcessor) {
            return (RubyCompletionProcessor)iContentAssistProcessor;
        }
        return null;
    }
}

