/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class UpdateResourcesCommand
implements ISVNCommand {
    private SVNWorkspaceRoot root;
    private IResource[] resources;
    private SVNRevision revision;
    private boolean recursive;

    public UpdateResourcesCommand(SVNWorkspaceRoot root, IResource[] resources, SVNRevision revision, boolean recursive) {
        this.root = root;
        this.resources = resources;
        this.revision = revision;
        this.recursive = recursive;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws SVNException {
        try {
            block8: {
                try {
                    monitor.beginTask(null, 100 * this.resources.length);
                    ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
                    OperationManager.getInstance().beginOperation(svnClient, new OperationProgressNotifyListener(monitor));
                    if (this.resources.length == 1) {
                        monitor.subTask(this.resources[0].getName());
                        svnClient.update(this.resources[0].getLocation().toFile(), this.revision, this.recursive);
                        monitor.worked(100);
                        break block8;
                    }
                    File[] files = new File[this.resources.length];
                    int i = 0;
                    while (true) {
                        if (i >= this.resources.length) {
                            svnClient.update(files, this.revision, this.recursive, false);
                            monitor.worked(100);
                            break;
                        }
                        files[i] = this.resources[i].getLocation().toFile();
                        ++i;
                    }
                }
                catch (SVNClientException e) {
                    throw SVNException.wrapException((Exception)((Object)e));
                }
            }
            Object var5_8 = null;
            OperationManager.getInstance().endOperation();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            OperationManager.getInstance().endOperation();
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }
}

