/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.properties.internal.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.ui.properties.internal.CommonUIPropertiesPlugin;
import org.eclipse.wst.common.ui.properties.internal.l10n.Messages;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISectionDescriptor;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISectionDescriptorProvider;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITypeMapper;
import org.eclipse.wst.common.ui.properties.internal.view.DynamicTabListContentProvider;
import org.eclipse.wst.common.ui.properties.internal.view.SectionDescriptor;
import org.eclipse.wst.common.ui.properties.internal.view.TabDescriptor;
import org.eclipse.wst.common.ui.properties.internal.view.TabListContentProvider;
import org.eclipse.wst.common.ui.properties.internal.view.TabbedPropertyRegistryUtils;
import org.osgi.framework.Bundle;

public class TabbedPropertyRegistry {
    private static final String NO_TAB_ERROR = Messages.TabbedPropertyRegistry_Non_existing_tab;
    private static final String CONTRIBUTOR_ERROR = Messages.TabbedPropertyRegistry_contributor_error;
    private static final String EXTPT_CONTRIBUTOR = "propertyContributor";
    private static final String EXTPT_TABS = "propertyTabs";
    private static final String EXTPT_SECTIONS = "propertySections";
    private static final String ELEMENT_TAB = "propertyTab";
    private static final String ELEMENT_SECTION = "propertySection";
    private static final String ELEMENT_PROPERTY_CATEGORY = "propertyCategory";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_CONTRIBUTOR_ID = "contributorId";
    private static final String ATT_TYPE_MAPPER = "typeMapper";
    private static final String ATT_LABEL_PROVIDER = "labelProvider";
    private static final String ATT_SECTION_DESCRIPTOR_PROVIDER = "sectionDescriptorProvider";
    private static final String ATT_DYNAMIC_TAB_LIST_CONTENT_PROVIDER = "dynamicTabListContentProvider";
    private static final String TOP = "top";
    protected String contributorId;
    protected IConfigurationElement contributorConfigurationElement;
    protected String[] propertyCategories;
    protected ILabelProvider labelProvider;
    protected ITypeMapper typeMapper;
    protected ISectionDescriptorProvider sectionDescriptorProvider;
    protected boolean dynamicTabListContentProvider = false;
    protected IStructuredContentProvider tabListContentProvider;
    protected TabDescriptor[] tabDescriptors;
    protected static final TabDescriptor[] EMPTY_DESCRIPTOR_ARRAY = new TabDescriptor[0];

    protected TabbedPropertyRegistry(String id) {
        IConfigurationElement[] extensions = TabbedPropertyRegistryUtils.getConfigurationElements(EXTPT_CONTRIBUTOR);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement configurationElement = extensions[i];
            String contributor = configurationElement.getAttribute(ATT_CONTRIBUTOR_ID);
            if (contributor != null && id.equals(contributor)) {
                this.contributorId = contributor;
                this.contributorConfigurationElement = configurationElement;
                try {
                    if (configurationElement.getAttribute(ATT_LABEL_PROVIDER) != null) {
                        this.labelProvider = (ILabelProvider)configurationElement.createExecutableExtension(ATT_LABEL_PROVIDER);
                    }
                    if (configurationElement.getAttribute(ATT_TYPE_MAPPER) != null) {
                        this.typeMapper = (ITypeMapper)configurationElement.createExecutableExtension(ATT_TYPE_MAPPER);
                    }
                    if (configurationElement.getAttribute(ATT_SECTION_DESCRIPTOR_PROVIDER) != null) {
                        this.sectionDescriptorProvider = (ISectionDescriptorProvider)configurationElement.createExecutableExtension(ATT_SECTION_DESCRIPTOR_PROVIDER);
                    }
                    if (configurationElement.getAttribute(ATT_DYNAMIC_TAB_LIST_CONTENT_PROVIDER) != null) {
                        String attributeBoolean = configurationElement.getAttribute(ATT_DYNAMIC_TAB_LIST_CONTENT_PROVIDER);
                        this.dynamicTabListContentProvider = attributeBoolean.equals("true");
                    }
                }
                catch (CoreException exception) {
                    this.handleConfigurationError(id, exception);
                }
                this.propertyCategories = this.getPropertyCategories(configurationElement);
            }
            ++i;
        }
        if (this.propertyCategories == null || this.contributorId == null) {
            this.handleConfigurationError(id, null);
        }
    }

    private String[] getPropertyCategories(IConfigurationElement configurationElement) {
        ArrayList<String> result = new ArrayList<String>();
        IConfigurationElement[] elements = configurationElement.getChildren(ELEMENT_PROPERTY_CATEGORY);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            result.add(element.getAttribute(ATT_CATEGORY));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private void handleConfigurationError(String id, CoreException exception) {
        String message = MessageFormat.format(CONTRIBUTOR_ERROR, id);
        Status status = new Status(4, CommonUIPropertiesPlugin.getPlugin().getBundle().getSymbolicName(), 6, message, (Throwable)exception);
        CommonUIPropertiesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    protected ISectionDescriptor[] readSectionDescriptors() {
        ArrayList<SectionDescriptor> result = new ArrayList<SectionDescriptor>();
        IConfigurationElement[] extensions = this.getConfigurationElements(EXTPT_SECTIONS);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement extension = extensions[i];
            IConfigurationElement[] sections = extension.getChildren(ELEMENT_SECTION);
            int j = 0;
            while (j < sections.length) {
                IConfigurationElement section = sections[j];
                SectionDescriptor descriptor = new SectionDescriptor(section, this.typeMapper);
                result.add(descriptor);
                ++j;
            }
            ++i;
        }
        return result.toArray(new ISectionDescriptor[result.size()]);
    }

    protected IConfigurationElement[] getConfigurationElements(String extensionPointId) {
        IConfigurationElement[] extensions = TabbedPropertyRegistryUtils.getConfigurationElements(extensionPointId);
        ArrayList<IConfigurationElement> unordered = new ArrayList<IConfigurationElement>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            String contributor;
            IConfigurationElement extension = extensions[i];
            if (extension.getName().equals(extensionPointId) && this.contributorId.equals(contributor = extension.getAttribute(ATT_CONTRIBUTOR_ID))) {
                unordered.add(extension);
            }
            ++i;
        }
        Bundle[] bundles = TabbedPropertyRegistryUtils.getPluginBundles(unordered);
        String[] referenceOrder = TabbedPropertyRegistryUtils.computePrerequisiteOrder(bundles);
        ArrayList ordered = new ArrayList(unordered.size());
        Iterator iter = unordered.iterator();
        while (iter.hasNext()) {
            IConfigurationElement extension = (IConfigurationElement)iter.next();
            this.insertInPluginOrder(referenceOrder, ordered, extension);
        }
        return ordered.toArray(new IConfigurationElement[ordered.size()]);
    }

    private void insertInPluginOrder(String[] referenceOrder, List collection, IConfigurationElement target) {
        String targetPluginId = target.getDeclaringExtension().getNamespaceIdentifier();
        int targetOrder = this.getIndex(referenceOrder, targetPluginId);
        int i = 0;
        while (i < collection.size()) {
            IConfigurationElement element = (IConfigurationElement)collection.get(i);
            String elementPluginId = element.getDeclaringExtension().getNamespaceIdentifier();
            int elementOrder = this.getIndex(referenceOrder, elementPluginId);
            if (targetOrder < elementOrder) {
                collection.add(i, target);
                return;
            }
            ++i;
        }
        collection.add(target);
    }

    private int getIndex(Object[] array, Object target) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return EMPTY_DESCRIPTOR_ARRAY;
        }
        TabDescriptor[] allDescriptors = this.getAllTabDescriptors();
        TabDescriptor[] result = this.filterTabDescriptors(allDescriptors, part, selection);
        return result;
    }

    protected TabDescriptor[] filterTabDescriptors(TabDescriptor[] descriptors, IWorkbenchPart part, ISelection selection) {
        ArrayList<TabDescriptor> result = new ArrayList<TabDescriptor>();
        int i = 0;
        while (i < descriptors.length) {
            TabDescriptor descriptor = this.adaptDescriptorFor(descriptors[i], part, selection);
            if (!descriptor.getSectionDescriptors().isEmpty()) {
                result.add(descriptor);
            }
            ++i;
        }
        if (result.size() == 0) {
            return EMPTY_DESCRIPTOR_ARRAY;
        }
        return result.toArray(new TabDescriptor[result.size()]);
    }

    protected TabDescriptor adaptDescriptorFor(TabDescriptor target, IWorkbenchPart part, ISelection selection) {
        ArrayList<ISectionDescriptor> filteredSectionDescriptors = new ArrayList<ISectionDescriptor>();
        List descriptors = target.getSectionDescriptors();
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            ISectionDescriptor descriptor = (ISectionDescriptor)iter.next();
            if (!descriptor.appliesTo(part, selection)) continue;
            filteredSectionDescriptors.add(descriptor);
        }
        TabDescriptor result = (TabDescriptor)target.clone();
        result.setSectionDescriptors(filteredSectionDescriptors);
        return result;
    }

    protected TabDescriptor[] getAllTabDescriptors() {
        if (this.tabDescriptors == null) {
            List temp = this.readTabDescriptors();
            this.populateWithSectionDescriptors(temp);
            temp = this.sortTabDescriptorsByCategory(temp);
            temp = this.sortTabDescriptorsByAfterTab(temp);
            this.tabDescriptors = temp.toArray(new TabDescriptor[temp.size()]);
        }
        return this.tabDescriptors;
    }

    protected List readTabDescriptors() {
        ArrayList<TabDescriptor> result = new ArrayList<TabDescriptor>();
        IConfigurationElement[] extensions = this.getConfigurationElements(EXTPT_TABS);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement extension = extensions[i];
            IConfigurationElement[] tabs = extension.getChildren(ELEMENT_TAB);
            int j = 0;
            while (j < tabs.length) {
                IConfigurationElement tab = tabs[j];
                TabDescriptor descriptor = new TabDescriptor(tab);
                result.add(descriptor);
                ++j;
            }
            ++i;
        }
        return result;
    }

    protected void populateWithSectionDescriptors(List aTabDescriptors) {
        ISectionDescriptor[] sections = null;
        sections = this.sectionDescriptorProvider != null ? this.sectionDescriptorProvider.getSectionDescriptors() : this.readSectionDescriptors();
        int i = 0;
        while (i < sections.length) {
            ISectionDescriptor section = sections[i];
            this.appendToTabDescriptor(section, aTabDescriptors);
            ++i;
        }
    }

    protected void appendToTabDescriptor(ISectionDescriptor section, List aTabDescriptors) {
        Iterator i = aTabDescriptors.iterator();
        while (i.hasNext()) {
            TabDescriptor tab = (TabDescriptor)i.next();
            if (!tab.append(section)) continue;
            return;
        }
        String message = MessageFormat.format(NO_TAB_ERROR, section.getId(), section.getTargetTab());
        Status status = new Status(4, CommonUIPropertiesPlugin.getPlugin().getBundle().getSymbolicName(), 6, message, null);
        CommonUIPropertiesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    protected List sortTabDescriptorsByCategory(List descriptors) {
        Collections.sort(descriptors, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                TabDescriptor one = (TabDescriptor)arg0;
                TabDescriptor two = (TabDescriptor)arg1;
                String categoryOne = one.getCategory();
                String categoryTwo = two.getCategory();
                int categoryOnePosition = TabbedPropertyRegistry.this.getIndex(TabbedPropertyRegistry.this.propertyCategories, categoryOne);
                int categoryTwoPosition = TabbedPropertyRegistry.this.getIndex(TabbedPropertyRegistry.this.propertyCategories, categoryTwo);
                return categoryOnePosition - categoryTwoPosition;
            }
        });
        return descriptors;
    }

    protected List sortTabDescriptorsByAfterTab(List tabs) {
        ArrayList sorted = new ArrayList();
        int categoryIndex = 0;
        int i = 0;
        while (i < this.propertyCategories.length) {
            ArrayList categoryList = new ArrayList();
            String category = this.propertyCategories[i];
            int topOfCategory = categoryIndex;
            int endOfCategory = categoryIndex;
            while (endOfCategory < tabs.size() && ((TabDescriptor)tabs.get(endOfCategory)).getCategory().equals(category)) {
                ++endOfCategory;
            }
            int j = topOfCategory;
            while (j < endOfCategory) {
                TabDescriptor tab = (TabDescriptor)tabs.get(j);
                if (tab.getAfterTab().equals(TOP)) {
                    categoryList.add(0, tabs.get(j));
                } else {
                    categoryList.add(tabs.get(j));
                }
                ++j;
            }
            Collections.sort(categoryList, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    TabDescriptor one = (TabDescriptor)arg0;
                    TabDescriptor two = (TabDescriptor)arg1;
                    if (two.getAfterTab().equals(one.getId())) {
                        return -1;
                    }
                    if (one.getAfterTab().equals(two.getId())) {
                        return 1;
                    }
                    return 0;
                }
            });
            j = 0;
            while (j < categoryList.size()) {
                sorted.add(categoryList.get(j));
                ++j;
            }
            categoryIndex = endOfCategory;
            ++i;
        }
        return sorted;
    }

    public ITypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IStructuredContentProvider getTabListContentProvider() {
        if (this.dynamicTabListContentProvider) {
            return new DynamicTabListContentProvider(this);
        }
        return new TabListContentProvider(this);
    }
}

