/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.sqlscrapbook.editor;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.sqlscrapbook.editor.SQLScrapbookEditorInput;
import org.eclipse.wst.rdb.internal.sqlscrapbook.util.NodeSQLPage;
import org.eclipse.wst.rdb.internal.sqlscrapbook.util.SQLUtility;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditor;

public class SQLScrapbookDocumentProvider
extends FileDocumentProvider {
    private static String SERVER_EXPLORER = "org.eclipse.wst.rdb.server.ui.navigator.serverExplorer";

    protected IDocument createDocument(Object element) throws CoreException {
        IViewPart viewServerExplorer;
        IWorkbenchPage workbenchPage;
        IWorkbenchWindow workbenchWindow;
        IDocument document = null;
        document = super.createDocument(element);
        ConnectionInfo connectionInfo = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (workbenchPage = workbenchWindow.getActivePage()) != null && ((viewServerExplorer = workbenchPage.findView(SERVER_EXPLORER)) == null || viewServerExplorer.getSite() == null)) {
            workbenchPage.showView(SERVER_EXPLORER);
        }
        if (element instanceof IFileEditorInput) {
            IFile fileResource = ((IFileEditorInput)element).getFile();
            NodeSQLPage nodeSQLPage = null;
            File fileXMLin = null;
            if (fileResource != null) {
                fileXMLin = fileResource.getLocation().toFile();
            }
            if (fileXMLin != null) {
                nodeSQLPage = SQLUtility.getInputSQLPageXML(fileXMLin);
            }
            if (nodeSQLPage != null) {
                connectionInfo = SQLUtility.getConnectionInfo(nodeSQLPage.getNameConnection());
                if (element instanceof SQLScrapbookEditorInput) {
                    ((SQLScrapbookEditorInput)((Object)element)).setConnectionInfo(connectionInfo);
                    ((SQLScrapbookEditorInput)((Object)element)).setStatementSQL(nodeSQLPage.getStatementSQL());
                }
                if (document != null) {
                    document.set(nodeSQLPage.getStatementSQL());
                }
                if (fileResource != null) {
                    fileResource.setPersistentProperty(new QualifiedName("org.eclipse.wst.rdb.internal.sqlscrapbook", "nameConnection"), nodeSQLPage.getNameConnection());
                }
            }
            if (nodeSQLPage == null || connectionInfo == null) {
                String nameConnection = null;
                if (fileResource != null) {
                    nameConnection = fileResource.getPersistentProperty(new QualifiedName("org.eclipse.wst.rdb.internal.sqlscrapbook", "nameConnection"));
                }
                if (element instanceof SQLScrapbookEditorInput && nameConnection != null) {
                    connectionInfo = SQLUtility.getConnectionInfo(nameConnection);
                    ((SQLScrapbookEditorInput)((Object)element)).setConnectionInfo(connectionInfo);
                }
            }
        }
        if (document == null) {
            document = new Document("");
        }
        if (element instanceof SQLScrapbookEditorInput) {
            ((SQLScrapbookEditorInput)((Object)element)).showMessageConnection();
        }
        return document;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        ConnectionInfo connectionInfo;
        ConnectionInfo connectionInfo2;
        IEditorPart editor;
        IDocument storageDocument = null;
        String statementSQL = document.get();
        if (statementSQL == null) {
            statementSQL = "";
        }
        String nameConnection = null;
        IFile fileResource = null;
        SQLEditor sqlEditor = null;
        if (nameConnection == null && (editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)element)) != null && editor instanceof SQLEditor && (connectionInfo2 = (sqlEditor = (SQLEditor)editor).getConnectionInfo()) != null) {
            nameConnection = connectionInfo2.getName();
        }
        if (element instanceof IFileEditorInput) {
            fileResource = ((IFileEditorInput)element).getFile();
        }
        if (nameConnection == null && element instanceof SQLScrapbookEditorInput && (connectionInfo = ((SQLScrapbookEditorInput)((Object)element)).getConnectionInfo()) != null) {
            nameConnection = connectionInfo.getName();
        }
        if (nameConnection == null && fileResource != null && !fileResource.getFileExtension().equalsIgnoreCase("sqlpage") && fileResource.exists()) {
            nameConnection = fileResource.getPersistentProperty(new QualifiedName("org.eclipse.wst.rdb.internal.sqlscrapbook", "nameConnection"));
        }
        if (nameConnection == null) {
            nameConnection = "";
        }
        if (fileResource != null && fileResource.getFileExtension().equalsIgnoreCase("sqlpage")) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nameConnection", nameConnection);
            String pageXML = SQLUtility.getOutputSQLPageXML(statementSQL, map);
            storageDocument = new Document(pageXML);
        }
        if (nameConnection != null && fileResource != null && !fileResource.getFileExtension().equalsIgnoreCase("sqlpage") && fileResource.exists()) {
            fileResource.setPersistentProperty(new QualifiedName("org.eclipse.wst.rdb.internal.sqlscrapbook", "nameConnection"), nameConnection);
        }
        if (storageDocument == null) {
            storageDocument = document;
        }
        super.doSaveDocument(monitor, element, storageDocument, overwrite);
        if (element instanceof SQLScrapbookEditorInput) {
            ((SQLScrapbookEditorInput)((Object)element)).showMessageConnection();
        }
        if (sqlEditor != null) {
            sqlEditor.refreshConnectionStatus();
        }
    }
}

