/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.emf.util;

import org.eclipse.wst.dtd.core.internal.emf.DTDAttribute;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDElementContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDNotation;
import org.eclipse.wst.dtd.core.internal.emf.DTDObject;
import org.eclipse.wst.dtd.core.internal.emf.DTDParameterEntityReference;
import org.eclipse.wst.dtd.core.internal.emf.DTDSourceOffset;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDVisitor;

public class DTDObjectFinder
extends DTDVisitor {
    SourceOffset searchLocation;
    private DTDObject closestObject = null;

    private SourceOffset offsetObjectFor(DTDSourceOffset s) {
        return new SourceOffset(s.getStartOffset(), s.getEndOffset());
    }

    private void checkContainment(DTDObject o) {
        if (this.offsetObjectFor((DTDSourceOffset)((Object)o)).contains(this.searchLocation)) {
            this.closestObject = o;
        }
    }

    public DTDObjectFinder(int startOffset, int endOffset) {
        this.searchLocation = new SourceOffset(startOffset, endOffset);
    }

    public void visitDTDNotation(DTDNotation notation) {
        this.checkContainment(notation);
        super.visitDTDNotation(notation);
    }

    public void visitDTDEntity(DTDEntity entity) {
        this.checkContainment(entity);
        super.visitDTDEntity(entity);
    }

    public void visitDTDElement(DTDElement element) {
        this.checkContainment(element);
        super.visitDTDElement(element);
    }

    public void visitDTDAttribute(DTDAttribute attribute) {
        this.checkContainment(attribute);
        super.visitDTDAttribute(attribute);
    }

    public void visitDTDParameterEntityReference(DTDParameterEntityReference parmEntity) {
        this.checkContainment(parmEntity);
        super.visitDTDParameterEntityReference(parmEntity);
    }

    public void visitDTDElementContent(DTDElementContent content) {
        this.checkContainment(content);
        super.visitDTDElementContent(content);
    }

    public DTDObject getClosestObject() {
        return this.closestObject;
    }

    protected SourceOffset offsetObjectForGen(DTDSourceOffset s) {
        return new SourceOffset(s.getStartOffset(), s.getEndOffset());
    }

    protected void checkContainmentGen(DTDObject o) {
        if (this.offsetObjectFor((DTDSourceOffset)((Object)o)).contains(this.searchLocation)) {
            this.closestObject = o;
        }
    }

    protected void visitDTDNotationGen(DTDNotation notation) {
        this.checkContainment(notation);
        super.visitDTDNotation(notation);
    }

    protected void visitDTDEntityGen(DTDEntity entity) {
        this.checkContainment(entity);
        super.visitDTDEntity(entity);
    }

    protected void visitDTDElementGen(DTDElement element) {
        this.checkContainment(element);
        super.visitDTDElement(element);
    }

    protected void visitDTDAttributeGen(DTDAttribute attribute) {
        this.checkContainment(attribute);
        super.visitDTDAttribute(attribute);
    }

    protected void visitDTDParameterEntityReferenceGen(DTDParameterEntityReference parmEntity) {
        this.checkContainment(parmEntity);
        super.visitDTDParameterEntityReference(parmEntity);
    }

    protected void visitDTDElementContentGen(DTDElementContent content) {
        this.checkContainment(content);
        super.visitDTDElementContent(content);
    }

    protected DTDObject getClosestObjectGen() {
        return this.closestObject;
    }

    public class SourceOffset {
        private int start;
        private int end;

        public SourceOffset(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean contains(SourceOffset other) {
            return this.start <= other.start && other.start <= this.end;
        }
    }
}

