/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.extensions.internal.editorlaunch;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.rdb.sqleditor.internal.ISQLEditorInput;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditor;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorFileEditorInput;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorResources;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorStorageEditorInput;

public class SQLEditorForServerExplorer
extends SQLEditor {
    public void doSave(IProgressMonitor monitor) {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof SQLEditorStorageEditorInput) {
            super.doSaveAs();
        } else {
            super.doSave(monitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performSaveAs(IProgressMonitor progressMonitor) {
        IEditorInput input = this.getEditorInput();
        String inputName = input.getName();
        Shell shell = this.getSite().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        if (input instanceof IFileEditorInput) {
            IFile original;
            IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
            if (original != null) {
                dialog.setOriginalFile(original);
            }
        } else if (input instanceof SQLEditorStorageEditorInput && inputName != null && inputName.length() > 0) {
            if (!inputName.endsWith(".sql") && !inputName.endsWith(".ddl")) {
                inputName = String.valueOf(inputName) + ".sql";
            }
            dialog.setOriginalName(inputName);
        }
        dialog.create();
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        if (provider.isDeleted((Object)input)) {
            String message = MessageFormat.format(SQLEditorResources.getString((String)"SQLEditor.warning.save.delete"), inputName);
            dialog.setErrorMessage(null);
            dialog.setMessage(message, 2);
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        FileEditorInput newInput = null;
        if (input instanceof ISQLEditorInput) {
            ISQLEditorInput sqlEditorInput = (ISQLEditorInput)input;
            newInput = new SQLEditorFileEditorInput(file);
            SQLEditorFileEditorInput newSQLEditorInput = (SQLEditorFileEditorInput)newInput;
            newSQLEditorInput.setConnectionInfo(sqlEditorInput.getConnectionInfo());
            newSQLEditorInput.setDatabase(sqlEditorInput.getDatabase());
            newSQLEditorInput.setDefaultSchemaName(sqlEditorInput.getDefaultSchemaName());
        } else {
            newInput = new FileEditorInput(file);
        }
        boolean success = false;
        try {
            block26: {
                try {
                    provider.aboutToChange((Object)newInput);
                    provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status != null && status.getSeverity() == 8) break block26;
                    String title = SQLEditorResources.getString((String)"SQLEditor.error.save.title");
                    String msg = MessageFormat.format(SQLEditorResources.getString((String)"SQLEditor.error.save.message"), x.getMessage());
                    if (status != null) {
                        switch (status.getSeverity()) {
                            case 1: {
                                MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            case 2: {
                                MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            default: {
                                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                        }
                        break block26;
                    }
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
            Object var16_20 = null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
            throw throwable;
        }
        provider.changed((Object)newInput);
        if (success) {
            this.setInput((IEditorInput)newInput);
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }
}

