/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class PasteBookmarkAction
extends BookmarkAction {
    private BookmarkNavigator view;

    public PasteBookmarkAction(BookmarkNavigator view) {
        super(view, BookmarkMessages.PasteBookmark_text);
        this.view = view;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.paste_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        final IMarker[] markerData = (IMarker[])this.view.getClipboard().getContents((Transfer)transfer);
        if (markerData == null) {
            return;
        }
        final ArrayList newMarkers = new ArrayList();
        try {
            this.view.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < markerData.length) {
                        if (markerData[i].getType().equals("org.eclipse.core.resources.bookmark")) {
                            IResource resource = markerData[i].getResource();
                            Map attributes = markerData[i].getAttributes();
                            IMarker marker = resource.createMarker("org.eclipse.core.resources.bookmark");
                            marker.setAttributes(attributes);
                            newMarkers.add(marker);
                        }
                        ++i;
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.view.getShell(), (String)BookmarkMessages.PasteBookmark_errorTitle, null, (IStatus)e.getStatus());
            return;
        }
        if (newMarkers.size() > 0) {
            this.view.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PasteBookmarkAction.this.view.getViewer().setSelection((ISelection)new StructuredSelection((List)newMarkers));
                    PasteBookmarkAction.this.view.updatePasteEnablement();
                }
            });
        }
    }
}

