/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog2;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenTypeAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public OpenTypeAction() {
        this.setText(JavaUIMessages.OpenTypeAction_label);
        this.setDescription(JavaUIMessages.OpenTypeAction_description);
        this.setToolTipText(JavaUIMessages.OpenTypeAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_TOOL_OPENTYPE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_type_action");
    }

    public void run() {
        Shell parent = JavaPlugin.getActiveWorkbenchShell();
        OpenTypeSelectionDialog2 dialog = new OpenTypeSelectionDialog2(parent, false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), null, 0);
        dialog.setTitle(JavaUIMessages.OpenTypeAction_dialogTitle);
        dialog.setMessage(JavaUIMessages.OpenTypeAction_dialogMessage);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = (IType)types[0];
            try {
                IEditorPart part = EditorUtility.openInEditor(type, true);
                EditorUtility.revealInEditor(part, (IJavaElement)type);
            }
            catch (CoreException x) {
                String title = JavaUIMessages.OpenTypeAction_errorTitle;
                String message = JavaUIMessages.OpenTypeAction_errorMessage;
                ExceptionHandler.handle(x, title, message);
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

