/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.JavaProjectWizardFirstPage;
import org.eclipse.jdt.internal.ui.wizards.JavaProjectWizardSecondPage;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class JavaProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private JavaProjectWizardFirstPage fFirstPage;
    private JavaProjectWizardSecondPage fSecondPage;
    private IConfigurationElement fConfigElement;

    public JavaProjectWizard() {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.JavaProjectWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new JavaProjectWizardFirstPage();
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new JavaProjectWizardSecondPage(this.fFirstPage);
        this.addPage((IWizardPage)this.fSecondPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getJavaProject().getProject());
        }
        return res;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.JavaProjectWizard_op_error_title;
        String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public IJavaElement getCreatedElement() {
        return JavaCore.create((IProject)this.fFirstPage.getProjectHandle());
    }
}

