/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import gnu.classpath.VMStackWalker;
import gnu.java.util.DoubleEnumeration;
import gnu.java.util.EmptyEnumeration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ClassLoader {
    final HashMap definedPackages;
    private final ClassLoader parent;
    private final boolean initialized;
    boolean defaultAssertionStatus;
    Map packageAssertionStatus;
    Map classAssertionStatus;
    transient Object vmdata;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            if (this.parent != null) return this.parent.loadClass(string, bl);
            clazz = VMClassLoader.loadClass(string, bl);
            if (clazz != null) {
                return clazz;
            }
            try {
            }
            catch (ClassNotFoundException classNotFoundException) {}
            clazz = this.findClass(string);
        }
        if (!bl) return clazz;
        this.resolveClass(clazz);
        return clazz;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final Class defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    protected final synchronized Class defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        this.checkInitialized();
        if (protectionDomain == null) {
            protectionDomain = StaticData.defaultProtectionDomain;
        }
        return VMClassLoader.defineClass(this, string, byArray, n, n2, protectionDomain);
    }

    protected final Class defineClass(String string, ByteBuffer byteBuffer, ProtectionDomain protectionDomain) throws ClassFormatError {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return this.defineClass(string, byArray, 0, byArray.length, protectionDomain);
    }

    protected final void resolveClass(Class clazz) {
        this.checkInitialized();
        VMClassLoader.resolveClass(clazz);
    }

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        this.checkInitialized();
        return Class.forName(string, false, StaticData.systemClassLoader);
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null && (classLoader = VMStackWalker.getCallingClassLoader()) != null && !classLoader.isAncestorOf(this)) {
            securityManager.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return this.parent;
    }

    protected final void setSigners(Class clazz, Object[] objectArray) {
        this.checkInitialized();
        clazz.setSigners(objectArray);
    }

    protected final synchronized Class findLoadedClass(String string) {
        this.checkInitialized();
        return VMClassLoader.findLoadedClass(this, string);
    }

    public URL getResource(String string) {
        URL uRL = this.parent == null ? VMClassLoader.getResource(string) : this.parent.getResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public final Enumeration getResources(String string) throws IOException {
        Enumeration enumeration = this.parent == null ? VMClassLoader.getResources(string) : this.parent.getResources(string);
        return new DoubleEnumeration(enumeration, this.findResources(string));
    }

    protected Enumeration findResources(String string) throws IOException {
        return EmptyEnumeration.getInstance();
    }

    protected URL findResource(String string) {
        return null;
    }

    public static final URL getSystemResource(String string) {
        return StaticData.systemClassLoader.getResource(string);
    }

    public static Enumeration getSystemResources(String string) throws IOException {
        return StaticData.systemClassLoader.getResources(string);
    }

    public InputStream getResourceAsStream(String string) {
        try {
            URL uRL = this.getResource(string);
            if (uRL == null) {
                return null;
            }
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static final InputStream getSystemResourceAsStream(String string) {
        try {
            URL uRL = ClassLoader.getSystemResource(string);
            if (uRL == null) {
                return null;
            }
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader classLoader;
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null && (classLoader = VMStackWalker.getCallingClassLoader()) != null && classLoader != StaticData.systemClassLoader) {
            securityManager.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return StaticData.systemClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        if (this.getPackage(string) != null) {
            throw new IllegalArgumentException("Package " + string + " already defined");
        }
        Package package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL);
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            this.definedPackages.put(string, package_);
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Package getPackage(String string) {
        Package package_ = this.parent == null ? VMClassLoader.getPackage(string) : this.parent.getPackage(string);
        if (package_ != null) return package_;
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            return (Package)this.definedPackages.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Package[] getPackages() {
        Package[] packageArray;
        Object[] objectArray;
        block4: {
            block3: {
                HashMap hashMap = this.definedPackages;
                synchronized (hashMap) {
                    objectArray = new Package[this.definedPackages.size()];
                    this.definedPackages.values().toArray(objectArray);
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_1
                    if (this.parent != null) break block3;
                }
                packageArray = VMClassLoader.getPackages();
                break block4;
            }
            packageArray = this.parent.getPackages();
        }
        Package[] packageArray2 = new Package[packageArray.length + objectArray.length];
        System.arraycopy(packageArray, 0, packageArray2, 0, packageArray.length);
        System.arraycopy(objectArray, 0, packageArray2, packageArray.length, objectArray.length);
        return packageArray2;
    }

    protected String findLibrary(String string) {
        return null;
    }

    public void setDefaultAssertionStatus(boolean bl) {
        this.defaultAssertionStatus = bl;
    }

    public synchronized void setPackageAssertionStatus(String string, boolean bl) {
        if (this.packageAssertionStatus == null) {
            this.packageAssertionStatus = new HashMap(StaticData.systemPackageAssertionStatus);
        }
        this.packageAssertionStatus.put(string, bl);
    }

    public synchronized void setClassAssertionStatus(String string, boolean bl) {
        if (this.classAssertionStatus == null) {
            this.classAssertionStatus = new HashMap(StaticData.systemClassAssertionStatus);
        }
        this.classAssertionStatus.put(string.toString(), bl);
    }

    public synchronized void clearAssertionStatus() {
        this.defaultAssertionStatus = false;
        this.packageAssertionStatus = new HashMap();
        this.classAssertionStatus = new HashMap();
    }

    final boolean isAncestorOf(ClassLoader classLoader) {
        while (classLoader != null) {
            if (this == classLoader) {
                return true;
            }
            classLoader = classLoader.parent;
        }
        return false;
    }

    private static final URL[] getExtClassLoaderUrls() {
        Object object;
        String string = SystemProperties.getProperty("java.ext.dirs", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList arrayList = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                object = new File(stringTokenizer.nextToken());
                File[] fileArray = ((File)object).listFiles();
                if (fileArray == null) continue;
                int n = 0;
                while (n < fileArray.length) {
                    arrayList.add(fileArray[n].toURL());
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
        object = new URL[arrayList.size()];
        arrayList.toArray((Object[])object);
        return object;
    }

    private static final void addFileURL(ArrayList arrayList, String string) {
        try {
            arrayList.add(new File(string).toURL());
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private static final URL[] getSystemClassLoaderUrls() {
        Object[] objectArray;
        String string = SystemProperties.getProperty("java.class.path", ".");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator, true);
        ArrayList arrayList = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            if (objectArray.equals(File.pathSeparator)) {
                ClassLoader.addFileURL(arrayList, ".");
                continue;
            }
            ClassLoader.addFileURL(arrayList, (String)objectArray);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) continue;
            ClassLoader.addFileURL(arrayList, ".");
        }
        objectArray = new URL[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    static ClassLoader defaultGetSystemClassLoader() {
        return ClassLoader.createAuxiliarySystemClassLoader(ClassLoader.createSystemClassLoader(ClassLoader.getSystemClassLoaderUrls(), ClassLoader.createExtClassLoader(ClassLoader.getExtClassLoaderUrls(), null)));
    }

    static ClassLoader createExtClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        if (uRLArray.length > 0) {
            return new URLClassLoader(uRLArray, classLoader);
        }
        return classLoader;
    }

    static ClassLoader createSystemClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        return new URLClassLoader(uRLArray, classLoader){

            protected final synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
                int n;
                SecurityManager securityManager = SecurityManager.current;
                if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
                    securityManager.checkPackageAccess(string.substring(0, n));
                }
                return super.loadClass(string, bl);
            }
        };
    }

    static ClassLoader createAuxiliarySystemClassLoader(ClassLoader classLoader) {
        String string = SystemProperties.getProperty("java.system.class.loader", null);
        if (string == null) {
            return classLoader;
        }
        try {
            Class clazz = Class.forName(string, false, classLoader);
            Class[] classArray = new Class[1];
            Class clazz2 = class$java$lang$ClassLoader;
            if (clazz2 == null) {
                clazz2 = class$java$lang$ClassLoader = ClassLoader.class("[Ljava.lang.ClassLoader;", false);
            }
            classArray[0] = clazz2;
            Constructor constructor = clazz.getConstructor(classArray);
            return (ClassLoader)constructor.newInstance(new Object[]{classLoader});
        }
        catch (Exception exception) {
            System.err.println("Requested system classloader " + string + " failed.");
            throw (Error)new Error("Requested system classloader " + string + " failed.").initCause(exception);
        }
    }

    private final void checkInitialized() {
        if (!this.initialized) {
            throw new SecurityException("attempt to use uninitialized class loader");
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.definedPackages = new HashMap();
        this.defaultAssertionStatus = VMClassLoader.defaultAssertionStatus();
    }

    protected ClassLoader() throws SecurityException {
        this(StaticData.systemClassLoader);
    }

    protected ClassLoader(ClassLoader classLoader) {
        this.this();
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = classLoader;
        this.initialized = true;
    }

    static class StaticData {
        static final ClassLoader systemClassLoader = VMClassLoader.getSystemClassLoader();
        static final ProtectionDomain defaultProtectionDomain;
        static final Map systemPackageAssertionStatus;
        static final Map systemClassAssertionStatus;

        StaticData() {
        }

        static {
            String string = SystemProperties.getProperty("java.security.manager");
            if (string != null && SecurityManager.current == null) {
                if (string.equals("") || string.equals("default")) {
                    SecurityManager.current = new SecurityManager();
                } else {
                    try {
                        Class clazz = Class.forName(string, false, systemClassLoader);
                        SecurityManager.current = (SecurityManager)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw (InternalError)new InternalError("Unable to create SecurityManager").initCause(exception);
                    }
                }
            }
            CodeSource codeSource = new CodeSource(null, null);
            PermissionCollection permissionCollection = Policy.getPolicy().getPermissions(codeSource);
            defaultProtectionDomain = new ProtectionDomain(codeSource, permissionCollection);
            systemPackageAssertionStatus = VMClassLoader.packageAssertionStatus();
            systemClassAssertionStatus = VMClassLoader.classAssertionStatus();
        }
    }
}

