/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.naming.NamingException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.ServiceLocatorStrategy;
import org.netbeans.modules.javacore.api.JavaModel;

public class JMSDestination {
    private static final String PRODUCES = "Produces";
    private String destination;
    private Project project;
    private String type;
    private boolean supportsInjection;

    public JMSDestination(String destination, Project p, String type) {
        this.destination = destination;
        this.project = p;
        this.type = type;
    }

    public String toString() {
        return this.destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getType() {
        return this.type;
    }

    public Project getProject() {
        return this.project;
    }

    private String generateConnectionFactoryReference(EnterpriseReferenceContainer erc, String className) throws IOException {
        ResourceRef ref = erc.createResourceRef(className);
        ref.setResRefName(this.getConnectionFactoryName());
        ref.setResAuth("Container");
        ref.setResSharingScope("Shareable");
        ref.setResType("javax.jms.ConnectionFactory");
        return erc.addResourceRef(ref, className);
    }

    private String generateDestinationReference(EnterpriseReferenceContainer erc, String className, Project thisProject) throws IOException {
        MessageDestinationRef ref = erc.createDestinationRef(className);
        ref.setMessageDestinationUsage(PRODUCES);
        ref.setMessageDestinationType(this.getType());
        ref.setMessageDestinationRefName(this.getDestinationName());
        ProjectInformation pi = ProjectUtils.getInformation((Project)this.getProject());
        ref.setMessageDestinationLink(pi.getName() + ".jar#" + this.getDestination());
        if (this.getProject().equals(thisProject)) {
            String linkWithoutModule = ref.getMessageDestinationLink();
            linkWithoutModule = linkWithoutModule.substring(linkWithoutModule.indexOf(35) + 1);
            ref.setMessageDestinationLink(linkWithoutModule);
        }
        return erc.addDestinationRef(ref, className);
    }

    private String getConnectionFactoryName() {
        return "jms/" + this.getDestination() + "Factory";
    }

    private String getDestinationName() {
        return "jms/" + this.getDestination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genMethods(EnterpriseReferenceContainer erc, String className, Project currentProject, JavaClass target, ServiceLocatorStrategy sl) throws IOException {
        this.supportsInjection = InjectionTargetQuery.isInjectionTarget((JavaClass)target);
        String destinationFieldName = null;
        String connectionFactoryFieldName = null;
        String factoryName = null;
        String destinationName = null;
        ArrayList<Object> addedFeatures = new ArrayList<Object>();
        if (this.supportsInjection) {
            factoryName = this.getConnectionFactoryName();
            destinationName = this.getDestinationName();
            Field connectionFactoryField = this.createInjectedField(target, factoryName, "javax.jms.ConnectionFactory");
            Field destinationField = this.createInjectedField(target, destinationName, this.type);
            destinationFieldName = destinationField.getName();
            connectionFactoryFieldName = connectionFactoryField.getName();
            if (!Utils.containsFeature(target, (Feature)connectionFactoryField)) {
                target.getFeatures().add(0, connectionFactoryField);
                addedFeatures.add(connectionFactoryField);
            }
            if (!Utils.containsFeature(target, (Feature)destinationField)) {
                target.getFeatures().add(1, destinationField);
                addedFeatures.add(destinationField);
            }
        } else {
            factoryName = this.generateConnectionFactoryReference(erc, className);
            destinationName = this.generateDestinationReference(erc, className, currentProject);
        }
        Method sendMethod = this.createSendMethod(target, this.getDestination());
        Method producer = this.createJMSProducer(target, factoryName, connectionFactoryFieldName, destinationName, destinationFieldName, sendMethod.getName(), target, sl);
        if (!Utils.containsFeature(target, (Feature)sendMethod)) {
            target.getContents().add(sendMethod);
            addedFeatures.add(sendMethod);
        }
        if (!Utils.containsFeature(target, (Feature)producer)) {
            target.getContents().add(producer);
            addedFeatures.add(producer);
        }
        boolean failed = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            for (Feature feature : addedFeatures) {
                JMIUtils.fixImports((JavaClass)target, (Feature)feature);
            }
            failed = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(failed);
        }
    }

    private Field createInjectedField(JavaClass target, String mappedName, String clazz) {
        String fieldName = Utils.jndiNameToCamelCase(mappedName, true, "jms");
        int modifier = InjectionTargetQuery.isStaticReferenceRequired((JavaClass)target) ? 10 : 2;
        Field field = JMIGenerationUtil.createField((Element)target, (String)fieldName, (int)modifier, (String)clazz);
        AttributeValue av = JMIGenerationUtil.createAttributeValue((Element)target, (String)"mappedName", (String)mappedName);
        Annotation a = JMIGenerationUtil.createAnnotation((Element)target, (String)"javax.annotation.Resource", Collections.singletonList(av));
        field.getAnnotations().add(a);
        return field;
    }

    private Method createSendMethod(JavaClass jc, String destination) {
        Method me = JMIUtils.createMethod((JavaClass)jc);
        me.setModifiers(2);
        me.setName("createJMSMessageFor" + destination);
        me.setType(JMIUtils.resolveType((String)"javax.jms.Message"));
        JMIUtils.addException((Method)me, (String)"javax.jms.JMSException");
        JavaModelPackage jmp = (JavaModelPackage)me.refImmediatePackage();
        Parameter param = jmp.getParameter().createParameter("session", Collections.EMPTY_LIST, false, (TypeReference)jmp.getMultipartId().createMultipartId("javax.jms.Session", null, null), 0, false);
        Parameter context = jmp.getParameter().createParameter("messageData", Collections.EMPTY_LIST, false, (TypeReference)jmp.getMultipartId().createMultipartId(Object.class.getName(), null, null), 0, false);
        Parameter[] params = new Parameter[]{param, context};
        me.getParameters().addAll(Arrays.asList(params));
        String methodBody = "// TODO create and populate message to send\n// javax.jms.TextMessage tm = session.createTextMessage();\n// tm.setText(messageData.toString());\n// return tm;\n";
        me.setBodyText(methodBody);
        return me;
    }

    private Method createJMSProducer(JavaClass jc, String connectionFactoryName, String connectionFactoryFieldName, String destinationName, String destinationFieldName, String sendMethodName, JavaClass target, ServiceLocatorStrategy sl) {
        Method me = JMIUtils.createMethod((JavaClass)jc);
        me.setModifiers(2);
        String destName = destinationName.substring(destinationName.lastIndexOf(47) + 1);
        StringBuffer destBuff = new StringBuffer(destName);
        destBuff.setCharAt(0, Character.toUpperCase(destBuff.charAt(0)));
        me.setName("sendJMSMessageTo" + destBuff);
        JavaModelPackage jmp = (JavaModelPackage)me.refImmediatePackage();
        Parameter context = jmp.getParameter().createParameter("messageData", Collections.EMPTY_LIST, false, (TypeReference)jmp.getMultipartId().createMultipartId(Object.class.getName(), null, null), 0, false);
        Parameter[] params = new Parameter[]{context};
        me.getParameters().addAll(Arrays.asList(params));
        me.setType(JMIUtils.resolveType((String)"void"));
        JMIUtils.addException((Method)me, (String)NamingException.class.getName());
        JMIUtils.addException((Method)me, (String)"javax.jms.JMSException");
        if (this.supportsInjection) {
            me.setBodyText(this.getSendJMSCodeWithInjectedFields(connectionFactoryFieldName, destinationFieldName, sendMethodName));
        } else if (sl == null) {
            me.setBodyText(this.getSendJMSCode(connectionFactoryName, destinationName, sendMethodName));
        } else {
            me.setBodyText(this.getSendJMSCode(connectionFactoryName, destinationName, sendMethodName, sl, target));
        }
        return me;
    }

    private String getSendJMSCodeWithInjectedFields(String connectionFactoryFieldName, String destinationFieldName, String messageMethodName) {
        return MessageFormat.format("javax.jms.Connection connection = null;\njavax.jms.Session session = null;\ntry '{' \nconnection = {0}.createConnection();\nsession = connection.createSession(false,javax.jms.Session.AUTO_ACKNOWLEDGE);\njavax.jms.MessageProducer messageProducer = session.createProducer({1});\nmessageProducer.send({2}(session, messageData));\n '}' finally '{'\nif (session != null) '{'\n session.close();\n'}'\nif (connection != null) '{'\nconnection.close();\n'}'\n'}'\n", connectionFactoryFieldName, destinationFieldName, messageMethodName);
    }

    private String getSendJMSCode(String connectionName, String destinationName, String messageMethodName, ServiceLocatorStrategy sls, JavaClass targetClass) {
        String connectionFactory = sls.genJMSFactory(connectionName, targetClass);
        String destination = sls.genDestinationLookup(destinationName, targetClass);
        return MessageFormat.format("javax.jms.ConnectionFactory cf = (javax.jms.ConnectionFactory) " + connectionFactory + ";\n" + "javax.jms.Connection conn = null;\n" + "javax.jms.Session s = null;\n" + "try '{' \n" + "conn = cf.createConnection();\n" + "s = conn.createSession(false,s.AUTO_ACKNOWLEDGE);\n" + "javax.jms.Destination destination = (javax.jms.Destination) " + destination + ";\n" + "javax.jms.MessageProducer mp = s.createProducer(destination);\n" + "mp.send({2}(s,messageData));\n" + " '}' finally '{'\n" + "if (s != null) '{'\n" + " s.close();\n" + "'}'\n" + "if (conn != null) '{'\n" + "conn.close();\n" + "'}'\n" + "'}'\n", connectionName, destinationName, messageMethodName);
    }

    private String getSendJMSCode(String connectionName, String destinationName, String messageMethodName) {
        return MessageFormat.format("javax.naming.Context c = new javax.naming.InitialContext();\njavax.jms.ConnectionFactory cf = (javax.jms.ConnectionFactory) c.lookup(\"java:comp/env/{0}\");\njavax.jms.Connection conn = null;\njavax.jms.Session s = null;\ntry '{' \nconn = cf.createConnection();\ns = conn.createSession(false,s.AUTO_ACKNOWLEDGE);\njavax.jms.Destination destination = (javax.jms.Destination) c.lookup(\"java:comp/env/{1}\");\njavax.jms.MessageProducer mp = s.createProducer(destination);\nmp.send({2}(s,messageData));\n '}' finally '{'\nif (s != null) '{'\n s.close();\n'}'\nif (conn != null) '{'\nconn.close();\n'}'\n'}'\n", connectionName, destinationName, messageMethodName);
    }
}

