/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.scenario;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.xml.api.scenario.Scenario;
import org.netbeans.modules.xml.api.scenario.ScenarioFactory;
import org.netbeans.modules.xml.core.scenario.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class NewScenarioPanel
extends JPanel {
    private static final String FOLDER = "Plugins/XML/ScenarioFactories";
    private JComboBox typeCombo;
    private JTextField nameField;
    private JLabel jLabel2;
    private JLabel jLabel1;

    public NewScenarioPanel(String defaultName, DataObject dataObject) throws NoFactoriesException {
        this.initComponents();
        this.nameField.setText(defaultName);
        this.nameField.setSelectionStart(0);
        this.nameField.setSelectionEnd(defaultName.length());
        try {
            Vector<ScenarioFactory> allowedFactories;
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource(FOLDER);
            if (fo == null) {
                throw new NoFactoriesException();
            }
            DataObject df = DataObject.find((FileObject)fo);
            if (df instanceof DataObject.Container) {
                FolderLookup lookup = new FolderLookup((DataObject.Container)df);
                Lookup.Template template = new Lookup.Template(ScenarioFactory.class);
                Lookup.Result registrations = lookup.getLookup().lookup(template);
                Collection allFactories = registrations.allInstances();
                allowedFactories = new Vector<ScenarioFactory>();
                Iterator iter = allFactories.iterator();
                while (iter.hasNext()) {
                    ScenarioFactory factory = (ScenarioFactory)iter.next();
                    if (!factory.isEnabled(dataObject)) continue;
                    allowedFactories.add(factory);
                }
                if (allowedFactories.size() == 0) {
                    throw new NoFactoriesException();
                }
            } else {
                throw new NoFactoriesException();
            }
            this.typeCombo.setModel(new DefaultComboBoxModel<Object>(allowedFactories.toArray()));
        }
        catch (DataObjectNotFoundException ex) {
            throw new NoFactoriesException();
        }
    }

    public static Scenario createScenario(DataObject dataObject, DefaultComboBoxModel scenarioModel) {
        NewScenarioPanel newScenarioPanel;
        String defaultName = null;
        int nameInd = 1;
        while (defaultName == null) {
            defaultName = Util.THIS.getString("NAME_Scenario_default", Integer.toString(nameInd));
            for (int ind = 0; ind < scenarioModel.getSize(); ++ind) {
                if (!defaultName.equals(((Scenario)scenarioModel.getElementAt(ind)).getName())) continue;
                defaultName = null;
                break;
            }
            ++nameInd;
        }
        try {
            newScenarioPanel = new NewScenarioPanel(defaultName, dataObject);
        }
        catch (NoFactoriesException e) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)e.getMessage(), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return null;
        }
        DialogDescriptor newDD = new DialogDescriptor((Object)newScenarioPanel, Util.THIS.getString("NAME_New_scenario_dialog_title"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(NewScenarioPanel.class), null);
        newDD.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(newDD);
        dialog.show();
        if (newDD.getValue() == DialogDescriptor.OK_OPTION) {
            Scenario newScenario = newScenarioPanel.createScenario();
            scenarioModel.addElement(newScenario);
            return newScenario;
        }
        return null;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.typeCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameField.setToolTipText("null");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameField, gridBagConstraints);
        this.jLabel2.setText("Type:");
        this.jLabel2.setToolTipText("null");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.typeCombo, gridBagConstraints);
    }

    public Scenario createScenario() {
        ScenarioFactory factory = (ScenarioFactory)this.typeCombo.getSelectedItem();
        if (factory != null) {
            Scenario scenario = factory.createScenario();
            scenario.setName(this.nameField.getText());
            return scenario;
        }
        return null;
    }

    public class NoFactoriesException
    extends Exception {
        public NoFactoriesException() {
            super(Util.THIS.getString("MSG_no_factories"));
        }
    }
}

