/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class CompletionPopup {
    private static final int WINDOW_GAP = 1;
    private JTextComponent component;
    private Popup completionPopup = null;
    private Popup docPopup = null;
    private Popup tipPopup = null;
    private JComponent completionComponent = null;
    private int completionOffset = -1;
    private JComponent docComponent = null;
    private int docOffset = -1;
    private JToolTip tipComponent = null;
    private int tipOffset = -1;
    private boolean isCompletionAbove = false;
    private boolean isTipAbove = false;

    public void setCompletion(JComponent contents, int offset) {
        if (this.isCompletionShowing()) {
            this.completionPopup.hide();
            this.completionPopup = null;
            this.completionComponent = null;
            this.completionOffset = -1;
        }
        if (contents != null) {
            try {
                this.completionComponent = contents;
                this.completionOffset = offset;
                Dimension prefSize = this.completionComponent.getPreferredSize();
                Rectangle rect = this.component.modelToView(offset < 0 ? this.component.getCaret().getDot() : offset);
                Point caretPos = rect.getLocation();
                SwingUtilities.convertPointToScreen(caretPos, this.component);
                Rectangle screenBounds = this.component.getGraphicsConfiguration().getBounds();
                int xDelta = Math.min(0, screenBounds.x + screenBounds.width - caretPos.x - prefSize.width);
                int yDelta = 0;
                if (caretPos.y + rect.height + prefSize.height > screenBounds.y + screenBounds.height) {
                    this.isCompletionAbove = true;
                    yDelta = -prefSize.height - 1;
                } else {
                    this.isCompletionAbove = false;
                    yDelta = rect.height + 1;
                }
                caretPos.translate(xDelta, yDelta);
                PopupFactory factory = PopupFactory.getSharedInstance();
                this.completionPopup = factory.getPopup(null, contents, caretPos.x, caretPos.y);
                this.completionPopup.show();
                if (this.isTipShowing() && this.isTipAbove == this.isCompletionAbove) {
                    this.setTip(this.tipComponent, this.tipOffset);
                }
                if (this.isDocShowing()) {
                    this.setDoc(this.docComponent, this.docOffset, true);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public boolean isCompletionShowing() {
        return this.completionPopup != null;
    }

    public void setDoc(JComponent contents, int offset) {
        this.setDoc(contents, offset, false);
    }

    private void setDoc(JComponent contents, int offset, boolean force) {
        if (!force && this.docComponent == contents && this.docOffset == offset) {
            return;
        }
        if (this.isDocShowing()) {
            this.docPopup.hide();
            this.docPopup = null;
            this.docComponent = null;
            this.docOffset = -1;
        }
        if (contents != null) {
            try {
                int tipHeight;
                this.docComponent = contents;
                this.docOffset = this.isCompletionShowing() ? this.completionOffset : (offset < 0 ? this.component.getCaret().getDot() : offset);
                Dimension prefSize = this.docComponent.getPreferredSize();
                Rectangle rect = this.component.modelToView(this.docOffset);
                Point caretPos = rect.getLocation();
                SwingUtilities.convertPointToScreen(caretPos, this.component);
                Rectangle screenBounds = this.component.getGraphicsConfiguration().getBounds();
                int xDelta = Math.min(0, screenBounds.x + screenBounds.width - caretPos.x - prefSize.width);
                int yDelta = 0;
                int n = tipHeight = this.isTipShowing() ? this.tipComponent.getHeight() : 0;
                if (this.isCompletionShowing()) {
                    int completionHeight = this.completionComponent.getHeight();
                    yDelta = this.isCompletionAbove ? (caretPos.y - prefSize.height - completionHeight > screenBounds.y ? -prefSize.height - completionHeight - 1 : rect.height + (this.isTipShowing() ? tipHeight : 0) + 1) : (caretPos.y + rect.height + completionHeight + prefSize.height > screenBounds.y + screenBounds.height ? -prefSize.height - (this.isTipShowing() ? tipHeight : 0) - 1 : rect.height + completionHeight + 1);
                } else {
                    yDelta = caretPos.y - prefSize.height - (this.isTipAbove ? tipHeight : 0) > screenBounds.y ? -prefSize.height - (this.isTipAbove ? tipHeight : 0) - 1 : rect.height + (this.isTipAbove ? tipHeight : 0) + 1;
                }
                caretPos.translate(xDelta, yDelta);
                PopupFactory factory = PopupFactory.getSharedInstance();
                this.docPopup = factory.getPopup(null, contents, caretPos.x, caretPos.y);
                this.docPopup.show();
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public boolean isDocShowing() {
        return this.docPopup != null;
    }

    public void setTip(JToolTip contents, int offset) {
        this.setTip(contents, offset, false);
    }

    private void setTip(JToolTip contents, int offset, boolean force) {
        if (this.tipComponent == contents && this.tipOffset == offset) {
            return;
        }
        if (this.isTipShowing()) {
            this.tipPopup.hide();
            this.tipPopup = null;
            this.tipComponent = null;
            this.tipOffset = -1;
        }
        if (contents != null) {
            try {
                this.tipComponent = contents;
                this.tipOffset = offset;
                Dimension prefSize = this.tipComponent.getPreferredSize();
                Rectangle rect = this.component.modelToView(offset < 0 ? this.component.getCaret().getDot() : offset);
                Point caretPos = rect.getLocation();
                SwingUtilities.convertPointToScreen(caretPos, this.component);
                Rectangle screenBounds = this.component.getGraphicsConfiguration().getBounds();
                int xDelta = Math.min(0, screenBounds.x + screenBounds.width - caretPos.x - prefSize.width);
                int yDelta = 0;
                if (this.isCompletionShowing() && this.isCompletionAbove) {
                    this.isTipAbove = false;
                    yDelta = rect.height + 1;
                } else {
                    this.isTipAbove = true;
                    yDelta = -prefSize.height - 1;
                }
                caretPos.translate(xDelta, yDelta);
                PopupFactory factory = PopupFactory.getSharedInstance();
                this.tipPopup = factory.getPopup(null, contents, caretPos.x, caretPos.y);
                this.tipPopup.show();
                if (this.isDocShowing()) {
                    this.setDoc(this.docComponent, this.docOffset, true);
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public boolean isTipShowing() {
        return this.tipPopup != null;
    }

    public void setComponent(JTextComponent component) {
        this.hide();
        this.component = component;
    }

    private void hide() {
        this.setCompletion(null, -1);
        this.setDoc(null, -1);
        this.setTip(null, -1);
    }
}

