/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.model;

import com.sun.tools.ws.processor.model.Block;
import com.sun.tools.ws.processor.model.ModelException;
import com.sun.tools.ws.processor.model.ModelObject;
import com.sun.tools.ws.processor.model.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Message
extends ModelObject {
    private Map<QName, Block> _attachmentBlocks = new HashMap<QName, Block>();
    private Map<QName, Block> _bodyBlocks = new HashMap<QName, Block>();
    private Map<QName, Block> _headerBlocks = new HashMap<QName, Block>();
    private Map<QName, Block> _unboundBlocks = new HashMap<QName, Block>();
    private List<Parameter> _parameters = new ArrayList<Parameter>();
    private Map<String, Parameter> _parametersByName = new HashMap<String, Parameter>();

    public void addBodyBlock(Block b) {
        if (this._bodyBlocks.containsKey(b.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this._bodyBlocks.put(b.getName(), b);
        b.setLocation(1);
    }

    public Iterator<Block> getBodyBlocks() {
        return this._bodyBlocks.values().iterator();
    }

    public int getBodyBlockCount() {
        return this._bodyBlocks.size();
    }

    public Map<QName, Block> getBodyBlocksMap() {
        return this._bodyBlocks;
    }

    public void setBodyBlocksMap(Map<QName, Block> m) {
        this._bodyBlocks = m;
    }

    public boolean isBodyEmpty() {
        return this.getBodyBlocks().hasNext();
    }

    public boolean isBodyEncoded() {
        boolean isEncoded = false;
        Iterator<Block> iter = this.getBodyBlocks();
        while (iter.hasNext()) {
            Block bodyBlock = iter.next();
            if (!bodyBlock.getType().isSOAPType()) continue;
            isEncoded = true;
        }
        return isEncoded;
    }

    public void addHeaderBlock(Block b) {
        if (this._headerBlocks.containsKey(b.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this._headerBlocks.put(b.getName(), b);
        b.setLocation(2);
    }

    public Iterator<Block> getHeaderBlocks() {
        return this._headerBlocks.values().iterator();
    }

    public Collection<Block> getHeaderBlockCollection() {
        return this._headerBlocks.values();
    }

    public int getHeaderBlockCount() {
        return this._headerBlocks.size();
    }

    public Map<QName, Block> getHeaderBlocksMap() {
        return this._headerBlocks;
    }

    public void setHeaderBlocksMap(Map<QName, Block> m) {
        this._headerBlocks = m;
    }

    public void addAttachmentBlock(Block b) {
        if (this._attachmentBlocks.containsKey(b.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this._attachmentBlocks.put(b.getName(), b);
        b.setLocation(3);
    }

    public void addUnboundBlock(Block b) {
        if (this._unboundBlocks.containsKey(b.getName())) {
            return;
        }
        this._unboundBlocks.put(b.getName(), b);
        b.setLocation(0);
    }

    public Iterator<Block> getUnboundBlocks() {
        return this._unboundBlocks.values().iterator();
    }

    public Map<QName, Block> getUnboundBlocksMap() {
        return this._unboundBlocks;
    }

    public int getUnboundBlocksCount() {
        return this._unboundBlocks.size();
    }

    public void setUnboundBlocksMap(Map<QName, Block> m) {
        this._unboundBlocks = m;
    }

    public Iterator<Block> getAttachmentBlocks() {
        return this._attachmentBlocks.values().iterator();
    }

    public int getAttachmentBlockCount() {
        return this._attachmentBlocks.size();
    }

    public Map<QName, Block> getAttachmentBlocksMap() {
        return this._attachmentBlocks;
    }

    public void setAttachmentBlocksMap(Map<QName, Block> m) {
        this._attachmentBlocks = m;
    }

    public void addParameter(Parameter p) {
        if (this._parametersByName.containsKey(p.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this._parameters.add(p);
        this._parametersByName.put(p.getName(), p);
    }

    public Parameter getParameterByName(String name) {
        if (this._parametersByName.size() != this._parameters.size()) {
            this.initializeParametersByName();
        }
        return this._parametersByName.get(name);
    }

    public Iterator<Parameter> getParameters() {
        return this._parameters.iterator();
    }

    public List<Parameter> getParametersList() {
        return this._parameters;
    }

    public void setParametersList(List<Parameter> l) {
        this._parameters = l;
    }

    private void initializeParametersByName() {
        this._parametersByName = new HashMap<String, Parameter>();
        if (this._parameters != null) {
            for (Parameter param : this._parameters) {
                if (param.getName() != null && this._parametersByName.containsKey(param.getName())) {
                    throw new ModelException("model.uniqueness", new Object[0]);
                }
                this._parametersByName.put(param.getName(), param);
            }
        }
    }

    public Set<Block> getAllBlocks() {
        HashSet<Block> blocks = new HashSet<Block>();
        blocks.addAll(this._bodyBlocks.values());
        blocks.addAll(this._headerBlocks.values());
        blocks.addAll(this._attachmentBlocks.values());
        return blocks;
    }
}

