/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.junit.DefaultPlugin;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.wizards.Utils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtil {
    private static final String JAVA_SOURCES_SUFFIX = "java";
    private static final String JAVA_MIME_TYPE = "text/x-java";

    private static String getTestClassSuffix() {
        return JUnitSettings.TEST_CLASSNAME_SUFFIX;
    }

    private static String getTestClassPrefix() {
        return JUnitSettings.TEST_CLASSNAME_PREFIX;
    }

    private static String getTestSuiteSuffix() {
        return JUnitSettings.SUITE_CLASSNAME_SUFFIX;
    }

    private static String getTestSuitePrefix() {
        return JUnitSettings.SUITE_CLASSNAME_PREFIX;
    }

    private static String getRootSuiteName() {
        return JUnitSettings.getDefault().getRootSuiteClassName();
    }

    public static String getTestClassFullName(String sourceClassName, String packageName) {
        StringBuffer name = new StringBuffer();
        if (packageName != null) {
            name.append(packageName.replace('.', '/'));
            if (name.length() > 0) {
                name.append('/');
            }
        }
        name.append(TestUtil.getTestClassName(sourceClassName));
        return name.toString();
    }

    public static String getTestClassName(String sourceClassName) {
        return TestUtil.getTestClassPrefix() + sourceClassName + TestUtil.getTestClassSuffix();
    }

    public static String convertPackage2SuiteName(String packageFileName) {
        if (packageFileName.length() == 0) {
            return TestUtil.getRootSuiteName();
        }
        int index = packageFileName.lastIndexOf(47);
        String pkg = index > -1 ? packageFileName.substring(index + 1) : packageFileName;
        pkg = pkg.substring(0, 1).toUpperCase() + pkg.substring(1);
        return packageFileName + "/" + TestUtil.getTestSuitePrefix() + pkg + TestUtil.getTestSuiteSuffix();
    }

    public static String convertClass2TestName(String classFileName) {
        int index = classFileName.lastIndexOf(47);
        String pkg = index > -1 ? classFileName.substring(0, index) : "";
        String clazz = index > -1 ? classFileName.substring(index + 1) : classFileName;
        clazz = clazz.substring(0, 1).toUpperCase() + clazz.substring(1);
        if (pkg.length() > 0) {
            pkg = pkg + "/";
        }
        return pkg + TestUtil.getTestClassPrefix() + clazz + TestUtil.getTestClassSuffix();
    }

    public static void notifyUser(String msg) {
        TestUtil.notifyUser(msg, 0);
    }

    public static void notifyUser(String msg, int errorLevel) {
        NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)msg, errorLevel);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
    }

    public static FileObject getFileObjectFromNode(Node node) {
        DataObject dO = (DataObject)node.getCookie(DataObject.class);
        if (null != dO) {
            return dO.getPrimaryFile();
        }
        DataFolder df = (DataFolder)node.getCookie(DataFolder.class);
        if (null != df) {
            return df.getPrimaryFile();
        }
        ClassElement ce = (ClassElement)node.getCookie(ClassElement.class);
        if (null != ce) {
            while (null != (node = node.getParentNode())) {
                dO = (DataObject)node.getCookie(DataObject.class);
                if (null == dO) continue;
                return dO.getPrimaryFile();
            }
        }
        return null;
    }

    static boolean isClassTest(JavaClass jc) {
        return TestUtil.isClassImplementingTestInterface(jc);
    }

    static boolean isClassImplementingTestInterface(JavaClass cls) {
        JavaModelPackage pkg = (JavaModelPackage)cls.refImmediatePackage();
        JavaClass testInterface = (JavaClass)pkg.getJavaClass().resolve("junit.framework.Test");
        return cls.isSubTypeOf((ClassDefinition)testInterface);
    }

    static boolean isClassException(JavaClass cls) {
        JavaModelPackage pkg = (JavaModelPackage)cls.refImmediatePackage();
        ClassDefinition throwable = (ClassDefinition)pkg.getType().resolve("java.lang.Throwable");
        return cls.isSubTypeOf(throwable);
    }

    static Collection getAllClassesFromFile(FileObject fo) {
        if (fo == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator it = JavaModel.getResource((FileObject)fo).getChildren().iterator();
        LinkedList<JavaClass> ret = new LinkedList<JavaClass>();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!(e instanceof JavaClass)) continue;
            ret.add((JavaClass)e);
        }
        return ret;
    }

    public static JavaClass getMainJavaClass(Resource res) {
        Iterator it = res.getChildren().iterator();
        String resName = TestUtil.fileToClassName(res.getName());
        if (resName != null) {
            while (it.hasNext()) {
                Element e = (Element)it.next();
                if (!(e instanceof JavaClass) || !((JavaClass)e).getName().equals(resName)) continue;
                return (JavaClass)e;
            }
        }
        return null;
    }

    static String fileToClassName(String fileName) {
        if (fileName.endsWith(".java")) {
            return fileName.substring(0, fileName.length() - 5).replace('/', '.');
        }
        return null;
    }

    public static List getJavaFileNames(FileObject packageFolder, ClassPath classPath) {
        FileObject[] children = packageFolder.getChildren();
        if (children.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>(children.length);
        for (int i = 0; i < children.length; ++i) {
            DataObject dataObject;
            FileObject child = children[i];
            if (child.isFolder() || child.isVirtual() || !child.getMIMEType().equals(JAVA_MIME_TYPE)) continue;
            try {
                dataObject = DataObject.find((FileObject)child);
            }
            catch (DataObjectNotFoundException ex) {
                continue;
            }
            Resource rc = JavaModel.getResource((FileObject)dataObject.getPrimaryFile());
            result.add(TestUtil.getMainJavaClass(rc).getName());
        }
        return result.isEmpty() ? Collections.EMPTY_LIST : result;
    }

    public static List filterFeatures(JavaClass cls, Class type) {
        LinkedList<Feature> ret = new LinkedList<Feature>();
        for (Feature f : cls.getFeatures()) {
            if (!type.isAssignableFrom(f.getClass())) continue;
            ret.add(f);
        }
        return ret;
    }

    public static Feature getFeatureByName(JavaClass src, Class cls, String name) {
        if (!Feature.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("cls is not Feature");
        }
        for (Object o : src.getFeatures()) {
            Feature f;
            if (!cls.isAssignableFrom(o.getClass()) || !(f = (Feature)o).getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public static JavaClass getClassBySimpleName(JavaClass cls, String name) {
        return cls.getInnerClass(name, false);
    }

    public static String createNewName(int i, Set usedNames) {
        String ret;
        while (usedNames.contains(ret = "p" + i++)) {
        }
        return ret;
    }

    public static Parameter cloneParam(Parameter p, JavaModelPackage pkg, int order, Set usedNames) {
        String name = p.getName();
        if (name == null || name.length() == 0 || usedNames.contains(name)) {
            name = TestUtil.createNewName(order, usedNames);
        }
        usedNames.add(name);
        Parameter ret = pkg.getParameter().createParameter(name, p.getAnnotations(), p.isFinal(), null, 0, p.isVarArg());
        ret.setType(p.getType());
        return ret;
    }

    public static List cloneParams(List params, JavaModelPackage pkg) {
        Iterator origParams = params.iterator();
        LinkedList<Parameter> newParams = new LinkedList<Parameter>();
        int o = 0;
        HashSet usedNames = new HashSet(params.size() * 2);
        while (origParams.hasNext()) {
            Parameter p = (Parameter)origParams.next();
            newParams.add(TestUtil.cloneParam(p, pkg, o++, usedNames));
        }
        return newParams;
    }

    public static List getParameterTypes(List params) {
        ArrayList<Type> ret = new ArrayList<Type>(params.size());
        Iterator it = params.iterator();
        while (it.hasNext()) {
            ret.add(((Parameter)it.next()).getType());
        }
        return ret;
    }

    public static List collectFeatures(JavaClass c, Class cls, int modifiers, boolean recursive) {
        return TestUtil.collectFeatures(c, cls, modifiers, recursive, new LinkedList(), new HashSet());
    }

    private static List collectFeatures(JavaClass c, Class cls, int modifiers, boolean recursive, List list, Set visited) {
        if (!visited.add(c)) {
            return list;
        }
        int mo = c.isInterface() ? 1024 : 0;
        for (Feature m : TestUtil.filterFeatures(c, cls)) {
            if (((m.getModifiers() | mo) & modifiers) != modifiers) continue;
            list.add(m);
        }
        if (recursive) {
            JavaClass sup = c.getSuperClass();
            if (sup != null) {
                TestUtil.collectFeatures(sup, cls, modifiers, recursive, list, visited);
            }
            Iterator ifaces = c.getInterfaces().iterator();
            while (ifaces.hasNext()) {
                TestUtil.collectFeatures((JavaClass)ifaces.next(), cls, modifiers, recursive, list, visited);
            }
        }
        return list;
    }

    public static boolean hasMainMethod(JavaClass cls) {
        JavaModelPackage pkg = (JavaModelPackage)cls.refImmediatePackage();
        return cls.getMethod("main", Collections.singletonList(pkg.getArray().resolveArray(TestUtil.getStringType(pkg))), false) != null;
    }

    public static Type getStringType(JavaModelPackage pkg) {
        return pkg.getType().resolve("java.lang.String");
    }

    public static TypeReference getTypeReference(JavaModelPackage pkg, String name) {
        return pkg.getMultipartId().createMultipartId(name, null, Collections.EMPTY_LIST);
    }

    public static Object[] getTestTargets(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return new Object[0];
        }
        SourceGroup sourceGroupOwner = TestUtil.findSourceGroupOwner(fileObject);
        if (sourceGroupOwner == null) {
            return new Object[0];
        }
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroupOwner.getRootFolder());
        if (rootURLs.length == 0) {
            return new Object[0];
        }
        boolean someSkipped = false;
        Object[] sourceRoots = new FileObject[rootURLs.length];
        for (int i = 0; i < rootURLs.length; ++i) {
            sourceRoots[i] = URLMapper.findFileObject((URL)rootURLs[i]);
            if (sourceRoots[i] == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("No FileObject found for the following URL: " + rootURLs[i]));
                someSkipped = true;
                continue;
            }
            if (FileOwnerQuery.getOwner((FileObject)sourceRoots[i]) == project) continue;
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Source root found by FileOwnerQuery points to a different project for the following URL: " + rootURLs[i]));
            sourceRoots[i] = null;
            someSkipped = true;
        }
        if (someSkipped) {
            Object[] roots = TestUtil.skipNulls(sourceRoots, new FileObject[0]);
            if (roots.length == 0) {
                return new Object[0];
            }
            sourceRoots = (FileObject[])roots;
        }
        Object[] targets = new Object[sourceRoots.length];
        Map map = TestUtil.getFileObject2SourceGroupMap(project);
        for (int i = 0; i < sourceRoots.length; ++i) {
            Object srcGroup = map.get(sourceRoots[i]);
            targets[i] = srcGroup != null ? srcGroup : sourceRoots[i];
        }
        return targets;
    }

    public static SourceGroup findSourceGroupOwner(FileObject file) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        return TestUtil.findSourceGroupOwner(project, file);
    }

    public static SourceGroup findSourceGroupOwner(Project project, FileObject file) {
        SourceGroup[] sourceGroups = new Utils(project).getJavaSourceGroups();
        for (int i = 0; i < sourceGroups.length; ++i) {
            SourceGroup srcGroup = sourceGroups[i];
            FileObject root = srcGroup.getRootFolder();
            if (file != root && !FileUtil.isParentOf((FileObject)root, (FileObject)file) || !srcGroup.contains(file)) continue;
            return srcGroup;
        }
        return null;
    }

    public static Collection findSourceGroupOwners(Project project, String className) {
        SourceGroup[] sourceGroups = new Utils(project).getJavaSourceGroups();
        if (sourceGroups.length == 0) {
            return Collections.EMPTY_LIST;
        }
        String relativePath = className.replace('.', '/') + ".java";
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>(4);
        for (int i = 0; i < sourceGroups.length; ++i) {
            SourceGroup srcGroup = sourceGroups[i];
            FileObject root = srcGroup.getRootFolder();
            FileObject file = root.getFileObject(relativePath);
            if (file == null || !FileUtil.isParentOf((FileObject)root, (FileObject)file) || !srcGroup.contains(file)) continue;
            result.add(srcGroup);
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        result.trimToSize();
        return Collections.unmodifiableList(result);
    }

    public static Object[] skipNulls(Object[] objs, Object[] type) {
        ArrayList<Object> resultList = new ArrayList<Object>(objs.length);
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            resultList.add(objs[i]);
        }
        return resultList.toArray(type);
    }

    public static Map getFileObject2SourceGroupMap(Project project) {
        SourceGroup[] sourceGroups = new Utils(project).getJavaSourceGroups();
        if (sourceGroups.length == 0) {
            return Collections.EMPTY_MAP;
        }
        if (sourceGroups.length == 1) {
            return Collections.singletonMap(sourceGroups[0].getRootFolder(), sourceGroups[0]);
        }
        HashMap<FileObject, SourceGroup> map = new HashMap<FileObject, SourceGroup>(Math.round((float)sourceGroups.length * 1.4f + 0.5f), 0.75f);
        for (int i = 0; i < sourceGroups.length; ++i) {
            map.put(sourceGroups[i].getRootFolder(), sourceGroups[i]);
        }
        return map;
    }

    public static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    public static JUnitPlugin getPluginForProject(Project project) {
        Object pluginObj = project.getLookup().lookup(JUnitPlugin.class);
        return pluginObj != null ? (JUnitPlugin)pluginObj : new DefaultPlugin();
    }

    public static Map<JUnitPlugin.CreateTestParam, Object> getSettingsMap(boolean multipleFiles) {
        JUnitSettings settings = JUnitSettings.getDefault();
        HashMap<JUnitPlugin.CreateTestParam, Object> params = new HashMap<JUnitPlugin.CreateTestParam, Object>(17);
        params.put(JUnitPlugin.CreateTestParam.INC_PUBLIC, settings.isMembersPublic());
        params.put(JUnitPlugin.CreateTestParam.INC_PROTECTED, settings.isMembersProtected());
        params.put(JUnitPlugin.CreateTestParam.INC_PKG_PRIVATE, settings.isMembersPackage());
        params.put(JUnitPlugin.CreateTestParam.INC_CODE_HINT, settings.isBodyComments());
        params.put(JUnitPlugin.CreateTestParam.INC_METHOD_BODIES, settings.isBodyContent());
        params.put(JUnitPlugin.CreateTestParam.INC_JAVADOC, settings.isJavaDoc());
        if (multipleFiles) {
            params.put(JUnitPlugin.CreateTestParam.INC_GENERATE_SUITE, settings.isGenerateSuiteClasses());
            params.put(JUnitPlugin.CreateTestParam.INC_PKG_PRIVATE_CLASS, settings.isIncludePackagePrivateClasses());
            params.put(JUnitPlugin.CreateTestParam.INC_ABSTRACT_CLASS, settings.isGenerateAbstractImpl());
            params.put(JUnitPlugin.CreateTestParam.INC_EXCEPTION_CLASS, settings.isGenerateExceptionClasses());
        }
        params.put(JUnitPlugin.CreateTestParam.INC_SETUP, settings.isGenerateSetUp());
        params.put(JUnitPlugin.CreateTestParam.INC_TEAR_DOWN, settings.isGenerateTearDown());
        return params;
    }
}

