/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.EventQueue;
import java.util.Collection;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.RootNodeChildren;
import org.netbeans.modules.junit.output.TestsuiteNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;

final class RootNode
extends AbstractNode {
    static final String name = "JUnit results root node";
    static final int ALL_PASSED_ABSENT = 0;
    static final int SOME_PASSED_ABSENT = 1;
    static final int ALL_PASSED_DISPLAYED = 2;
    private final RootNodeChildren children;
    private volatile boolean filtered;
    private volatile String message;
    private volatile int totalTests = 0;
    private volatile int failures = 0;
    private volatile int errors = 0;
    private volatile int elapsedTimeMillis = 0;
    private volatile int detectedPassedTests = 0;

    public RootNode(boolean filtered) {
        super((Children)new RootNodeChildren(filtered));
        this.filtered = filtered;
        this.children = (RootNodeChildren)this.getChildren();
        this.setName(name);
        this.setIconBaseWithExtension("org/netbeans/modules/junit/output/res/empty.gif");
    }

    void displayMessage(String msg) {
        assert (EventQueue.isDispatchThread());
        this.message = msg;
        this.updateDisplayName();
    }

    void displaySuiteRunning(String suiteName) {
        assert (EventQueue.isDispatchThread());
        this.children.displaySuiteRunning(suiteName);
    }

    TestsuiteNode displayReport(Report report) {
        assert (EventQueue.isDispatchThread());
        this.updateStatistics(report);
        this.updateDisplayName();
        return this.children.displayReport(report);
    }

    void displayReports(Collection reports) {
        assert (EventQueue.isDispatchThread());
        for (Report report : reports) {
            this.updateStatistics(report);
        }
        this.updateDisplayName();
        this.children.displayReports(reports);
    }

    private void updateStatistics(Report report) {
        this.totalTests += report.totalTests;
        this.failures += report.failures;
        this.errors += report.errors;
        this.detectedPassedTests += report.detectedPassedTests;
        this.elapsedTimeMillis += report.elapsedTimeMillis;
    }

    void setFiltered(boolean filtered) {
        assert (EventQueue.isDispatchThread());
        if (filtered == this.filtered) {
            return;
        }
        this.filtered = filtered;
        Children children = this.getChildren();
        if (children != Children.LEAF) {
            ((RootNodeChildren)children).setFiltered(filtered);
        }
    }

    private void updateDisplayName() {
        String msg;
        assert (EventQueue.isDispatchThread());
        Class<?> bundleRefClass = ((Object)((Object)this)).getClass();
        if (this.totalTests == 0) {
            msg = null;
        } else if (this.failures == 0 && this.errors == 0) {
            msg = NbBundle.getMessage(bundleRefClass, (String)"MSG_TestsInfoAllOK", (Object)new Integer(this.totalTests));
        } else {
            String errorTestsInfo;
            String passedTestsInfo = NbBundle.getMessage(bundleRefClass, (String)"MSG_PassedTestsInfo", (Object)new Integer(this.totalTests - this.failures - this.errors));
            String failedTestsInfo = this.failures == 0 ? null : NbBundle.getMessage(bundleRefClass, (String)"MSG_FailedTestsInfo", (Object)new Integer(this.failures));
            String string = errorTestsInfo = this.errors == 0 ? null : NbBundle.getMessage(bundleRefClass, (String)"MSG_ErrorTestsInfo", (Object)new Integer(this.errors));
            msg = failedTestsInfo == null || errorTestsInfo == null ? NbBundle.getMessage(bundleRefClass, (String)"MSG_TestsOneIssueType", (Object)passedTestsInfo, (Object)(failedTestsInfo != null ? failedTestsInfo : errorTestsInfo)) : NbBundle.getMessage(bundleRefClass, (String)"MSG_TestsFailErrIssues", (Object)passedTestsInfo, (Object)failedTestsInfo, (Object)errorTestsInfo);
        }
        if (this.totalTests != 0) {
            assert (msg != null);
            int successDisplayedLevel = this.getSuccessDisplayedLevel();
            switch (successDisplayedLevel) {
                case 1: {
                    msg = msg + ' ';
                    msg = msg + NbBundle.getMessage(bundleRefClass, (String)"MSG_SomePassedNotDisplayed");
                    break;
                }
                case 0: {
                    msg = msg + ' ';
                    msg = msg + NbBundle.getMessage(bundleRefClass, (String)"MSG_PassedNotDisplayed");
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (this.message != null) {
            msg = msg == null ? this.message : msg + ' ' + this.message;
        }
        this.setDisplayName(msg);
    }

    int getSuccessDisplayedLevel() {
        int reportedPassedTestsCount = this.totalTests - this.failures - this.errors;
        if (this.detectedPassedTests >= reportedPassedTestsCount) {
            return 2;
        }
        if (this.detectedPassedTests == 0) {
            return 0;
        }
        return 1;
    }
}

