/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.IndentFileEntry;
import org.netbeans.modules.java.JMapFormat;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.settings.JavaSettings;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;

public class JavaDataLoader
extends MultiFileLoader {
    public static final String JAVA_EXTENSION = "java";
    public static final String PROP_PARSER_ENGINE = "parserEngine";
    static ArrayList parsingListeners = new ArrayList();
    static final long serialVersionUID = -6286836352608877232L;

    public JavaDataLoader() {
        this("org.netbeans.modules.java.JavaDataObject");
    }

    public JavaDataLoader(String recognizedObject) {
        super(recognizedObject);
    }

    public JavaDataLoader(Class recognizedObject) {
        super(recognizedObject);
    }

    protected String actionsContext() {
        return "Loaders/text/x-java/Actions/";
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)JavaDataLoader.class, (String)"PROP_JavaLoader_Name");
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new JavaDataObject(primaryFile, this);
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        if (fo.getExt().equals(JAVA_EXTENSION)) {
            return fo;
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new JavaFileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        ErrorManager.getDefault().log("Subclass of JavaDataLoader (" + ((Object)((Object)this)).getClass().getName() + ") has secondary entries but does not override createSecondaryEntries (MultidataObject, FileObject) method.");
        return new FileEntry.Numb(obj, secondaryFile);
    }

    protected Map createStringsMap() {
        Properties map = JavaSettings.getDefault().getReplaceableStringsProps();
        map.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
        map.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
        return map;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (in.available() > 0) {
            int v = in.readInt();
            if (v >= 1) {
                in.readObject();
            }
            if (v >= 2) {
                in.readBoolean();
            }
        }
    }

    public class JavaFileEntry
    extends IndentFileEntry {
        static final long serialVersionUID = 8244159045498569616L;
        boolean disableInputStream;
        private Collection activeReaders;

        public JavaFileEntry(MultiDataObject obj, FileObject file) {
            super(obj, file);
        }

        protected Format createFormat(FileObject target, String n, String e) {
            Map map = JavaDataLoader.this.createStringsMap();
            this.modifyMap(map, target, n, e);
            JMapFormat format = new JMapFormat(map);
            format.setLeftBrace("__");
            format.setRightBrace("__");
            format.setCondDelimiter("$");
            format.setExactMatch(false);
            return format;
        }

        protected void modifyMap(Map map, FileObject target, String n, String e) {
            ClassPath cp = ClassPath.getClassPath((FileObject)target, (String)"classpath/source");
            String resourcePath = "";
            if (cp != null) {
                resourcePath = cp.getResourceName(target);
            } else {
                ErrorManager.getDefault().log(16, "No classpath was found for folder: " + target);
            }
            map.put("NAME", n);
            map.put("PACKAGE", resourcePath.replace('/', '.'));
            map.put("PACKAGE_SLASHES", resourcePath);
            if (target.isRoot()) {
                map.put("PACKAGE_AND_NAME", n);
                map.put("PACKAGE_AND_NAME_SLASHES", n);
            } else {
                map.put("PACKAGE_AND_NAME", resourcePath.replace('/', '.') + '.' + n);
                map.put("PACKAGE_AND_NAME_SLASHES", resourcePath + '/' + n);
            }
            map.put("QUOTES", "\"");
        }

        public synchronized void addReader(InputStream r) {
            if (this.activeReaders == null) {
                this.activeReaders = new LinkedList();
            }
            this.activeReaders.add(r);
        }

        public synchronized void removeReader(InputStream r) {
            if (this.activeReaders == null) {
                return;
            }
            this.activeReaders.remove(r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() throws IOException {
            JavaFileEntry javaFileEntry = this;
            synchronized (javaFileEntry) {
                int size;
                if (this.activeReaders != null && (size = this.activeReaders.size()) > 0) {
                    InputStream[] readers = this.activeReaders.toArray(new InputStream[size]);
                    for (int i = 0; i < readers.length; ++i) {
                        readers[i].close();
                    }
                }
                this.activeReaders = null;
                this.disableInputStream = true;
            }
            super.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream() throws FileNotFoundException {
            FileObject fob = this.getFile();
            JavaFileEntry javaFileEntry = this;
            synchronized (javaFileEntry) {
                if (this.disableInputStream) {
                    throw new FileNotFoundException("File is being deleted.");
                }
                NotifyInputStream s = new NotifyInputStream(fob.getInputStream());
                this.addReader(s);
                return s;
            }
        }

        private class NotifyInputStream
        extends FilterInputStream {
            public NotifyInputStream(InputStream is) {
                super(is);
            }

            public void close() throws IOException {
                super.close();
                JavaFileEntry.this.removeReader(this);
            }
        }
    }
}

