/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.ErrConsumer;
import org.netbeans.modules.java.Util;
import org.netbeans.modules.java.parser.DocumentModelBuilder;
import org.netbeans.modules.java.parser.JavaParser;
import org.netbeans.modules.java.parser.ParsableObjectRequest;
import org.netbeans.modules.java.parser.ParserMessageImpl;
import org.netbeans.modules.java.settings.JavaSettings;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;

public class ParseSourceRequest
implements ParsableObjectRequest,
ErrConsumer {
    public static final int STATE_WAITING = 0;
    public static final int STATE_READING = 1;
    public static final int STATE_CANCELLED = 2;
    public static final int STATE_ANALYSIS = 3;
    public static final int STATE_UPDATING = 4;
    public static final int STATE_COMPLETED = 10;
    private static final int READ_THRESHOLD = 2048;
    JavaParser.Env environment;
    ChangeListener listener;
    int state;
    boolean valid;
    int syntaxErrors;
    ElementFactory builder;
    CloneableEditorSupport editSupp;
    private List errors = null;
    private Object parserType;
    private String sourceName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ParseSourceRequest() {
        this((Object)"shallow");
    }

    public ParseSourceRequest(String filename) {
        this();
        this.sourceName = filename;
    }

    public ParseSourceRequest(Object parserType) {
        JavaSettings settings = JavaSettings.getDefault();
        this.parserType = parserType;
        this.state = 0;
        this.valid = true;
    }

    ParseSourceRequest(JavaParser.Env env, CloneableEditorSupport editSupp) {
        this();
        this.editSupp = editSupp;
        this.environment = env;
    }

    public synchronized void addChangeListener(ChangeListener l) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = l;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.listener == l) {
            this.listener = null;
        }
    }

    public void setEnvironment(JavaParser.Env env) {
        this.environment = env;
    }

    public void setEditorSupport(CloneableEditorSupport editor) {
        this.editSupp = editor;
    }

    public void sourceChanged() {
        if (this.state == 1) {
            this.valid = false;
        }
    }

    public void modelChanged() {
        if (this.state != 0 && this.state != 10) {
            this.valid = false;
        }
    }

    public void setSyntaxErrors(int errors) {
        this.syntaxErrors = errors;
    }

    public int getSyntaxErrors() {
        return this.syntaxErrors;
    }

    public void setSemanticErrors(int errors) {
    }

    public ElementFactory getFactory() {
        if (this.builder == null) {
            this.builder = this.createBuilder(this.editSupp);
        }
        return this.builder;
    }

    protected ElementFactory createBuilder(CloneableEditorSupport supp) {
        return new DocumentModelBuilder(supp);
    }

    public void notifyReschedule() {
        this.builder = null;
        this.enterState(0);
    }

    protected void enterState(int state) {
        this.state = state;
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public char[] getSource() throws IOException {
        this.valid = true;
        this.enterState(1);
        Reader r = this.environment.getSourceText();
        char[] buf = Util.readContents(r);
        ElementFactory builder = this.getFactory();
        if (builder instanceof DocumentModelBuilder) {
            ((DocumentModelBuilder)builder).setContent(buf, this.editSupp.isDocumentLoaded());
        }
        return buf;
    }

    public InputStream findCompiledClass(String className) {
        return this.environment.findCompiledClass(className);
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean needsProcessing() {
        return this.valid;
    }

    public void notifyStart() {
    }

    public void notifyComplete() {
        this.enterState(10);
        if (this.errors == null && "deep".equals(this.getParserType())) {
            this.errors = new ArrayList();
        }
    }

    public String getSourceName() {
        if (this.sourceName != null) {
            return this.sourceName;
        }
        return this.environment.getSourceName();
    }

    public Object getParserType() {
        return this.parserType;
    }

    public ErrConsumer getErrConsumer() {
        if ("deep".equals(this.getParserType())) {
            return this;
        }
        return null;
    }

    public void pushError(Object severity, FileObject errorFile, int line, int column, String message, String referenceText) {
        if (errorFile != null && !errorFile.getNameExt().equals(this.getSourceName())) {
            return;
        }
        ParserMessageImpl newErr = new ParserMessageImpl(severity, line, column, message);
        if (this.errors == null) {
            this.errors = new ArrayList(50);
        }
        this.errors.add(newErr);
    }

    public Collection getMessages() {
        return this.errors;
    }

    public ClassPath getSourcePath() {
        if (!$assertionsDisabled && this.environment == null) {
            throw new AssertionError();
        }
        FileObject fo = this.environment.getSourceFile();
        if (!$assertionsDisabled && fo == null) {
            throw new AssertionError();
        }
        return ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
    }

    public ClassPath getLibraryPath() {
        if (!$assertionsDisabled && this.environment == null) {
            throw new AssertionError();
        }
        FileObject fo = this.environment.getSourceFile();
        if (!$assertionsDisabled && fo == null) {
            throw new AssertionError();
        }
        return ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
    }

    public ClassPath getBootClassPath() {
        if (!$assertionsDisabled && this.environment == null) {
            throw new AssertionError();
        }
        FileObject fo = this.environment.getSourceFile();
        if (!$assertionsDisabled && fo == null) {
            throw new AssertionError();
        }
        return ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
    }

    static {
        $assertionsDisabled = !ParseSourceRequest.class.desiredAssertionStatus();
    }
}

