/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.jmi.reflect.JmiException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AnnotationTypeCustomizer
extends JPanel {
    private final JavaClass element;
    private final JavaClass jclass;
    private final Resource resource;
    private boolean isOK = true;
    private JLabel accessLabel;
    private JPanel accessPanel;
    private JPanel jPanel1;
    private JLabel modifiersLabel;
    private JPanel modifiersPanel;
    private JLabel nameLabel;
    private JTextField nameTextField;

    public AnnotationTypeCustomizer(JavaClass jclass, AnnotationType element) {
        this(null, jclass, element);
    }

    public AnnotationTypeCustomizer(Resource resource, AnnotationType element) {
        this(resource, null, element);
    }

    private AnnotationTypeCustomizer(Resource resource, JavaClass jclass, AnnotationType element) {
        this.resource = resource;
        this.jclass = jclass;
        this.element = element;
        this.initComponents();
        this.nameTextField.setText(element.getSimpleName());
        int mask = 1025;
        if (resource == null) {
            mask |= 0xF;
        }
        this.accessPanel.add((Component)SourceEditSupport.createAccessModifiersPanel((ClassMember)this.element, mask), "Center");
        this.modifiersPanel.add((Component)SourceEditSupport.createOtherModifiersPanel((ClassMember)this.element, mask), "Center");
        HelpCtx.setHelpIDString((JComponent)this, (String)"java.annotationType.customizer");
        this.nameLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)AnnotationTypeCustomizer.class, (String)"CTL_Name_Mnemonic").charAt(0));
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)AnnotationTypeCustomizer.class, (String)"ACSN_AnnotationTypeNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)AnnotationTypeCustomizer.class, (String)"ACSD_AnnotationTypeNameTextField"));
        this.accessLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)AnnotationTypeCustomizer.class, (String)"CTL_AccessRights_Mnemonic").charAt(0));
        this.getAccessibleContext().setAccessibleDescription("ACSD_AnnotationTypeCustomizer");
    }

    public void addNotify() {
        super.addNotify();
        int l = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(l);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnnotationTypeCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.accessLabel = new JLabel();
        this.accessPanel = new JPanel();
        this.modifiersLabel = new JLabel();
        this.modifiersPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage((Class)AnnotationTypeCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setColumns(25);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                AnnotationTypeCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.accessLabel.setLabelFor(this.accessPanel);
        Mnemonics.setLocalizedText((JLabel)this.accessLabel, (String)NbBundle.getMessage((Class)AnnotationTypeCustomizer.class, (String)"CTL_AccessRights"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.accessLabel, gridBagConstraints);
        this.accessPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.accessPanel, gridBagConstraints);
        this.modifiersLabel.setLabelFor(this.modifiersPanel);
        Mnemonics.setLocalizedText((JLabel)this.modifiersLabel, (String)NbBundle.getMessage((Class)AnnotationTypeCustomizer.class, (String)"CTL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.modifiersLabel, gridBagConstraints);
        this.modifiersPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.add((Component)this.modifiersPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        if (evt != null && evt.isTemporary()) {
            return;
        }
        String newName = this.nameTextField.getText().trim();
        String oldName = this.element.getSimpleName();
        boolean ok = false;
        if (!Utilities.isJavaIdentifier((String)newName)) {
            IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName);
            ErrorManager.getDefault().annotate((Throwable)x, 256, null, NbBundle.getMessage((Class)AnnotationTypeCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
            ErrorManager.getDefault().notify((Throwable)x);
        } else {
            if (oldName.equals(newName)) {
                return;
            }
            if (this.resource == null && this.jclass.getInnerClass(newName, true) != null) {
                IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName);
                ErrorManager.getDefault().annotate((Throwable)x, 256, null, NbBundle.getMessage((Class)AnnotationTypeCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
                ErrorManager.getDefault().notify((Throwable)x);
            } else if (this.jclass == null && SourceEditSupport.findTopLevelClass(this.resource, newName) != null) {
                IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName);
                ErrorManager.getDefault().annotate((Throwable)x, 256, null, NbBundle.getMessage((Class)AnnotationTypeCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
                ErrorManager.getDefault().notify((Throwable)x);
            } else {
                try {
                    this.element.setSimpleName(newName);
                    ok = true;
                }
                catch (JmiException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
        this.isOK = ok;
        if (!ok) {
            this.nameTextField.setText(oldName);
        }
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        return this.isOK;
    }
}

