/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.elements.ChildrenProvider;
import org.netbeans.modules.java.ui.nodes.elements.ClassElementFilter;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.cookies.FilterCookie;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class ClassChildren
extends Children.Keys
implements FilterCookie,
ChildrenProvider.KeyHandler {
    private static int PPP_MASK = 7;
    protected static HashMap propToFilter;
    private static Comparator comparator;
    protected ClassDefinition element;
    protected ClassElementFilter filter;
    private SourceNodeFactory factory;
    private JMIElementListener wPropL;
    private boolean nodesInited = false;
    private final ChildrenProvider chprovider = new ChildrenProvider(this);

    public ClassChildren(SourceNodeFactory factory, ClassDefinition element) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.element = element;
        this.factory = factory;
        this.filter = null;
    }

    protected SourceNodeFactory getFactory() {
        return this.factory;
    }

    public Class getFilterClass() {
        return ClassElementFilter.class;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object filter) {
        if (!(filter instanceof ClassElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (ClassElementFilter)filter;
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    protected void addNotify() {
        super.addNotify();
        if (this.wPropL == null) {
            this.wPropL = new JMIElementListener(this);
        }
        this.refreshAllKeys();
        ((MDRChangeSource)this.element).addListener((MDRChangeListener)this.wPropL);
        this.nodesInited = true;
    }

    protected void removeNotify() {
        this.chprovider.clear();
        this.nodesInited = false;
        super.removeNotify();
    }

    protected final void hookNodeName(Element el) {
        if (el instanceof MDRChangeSource) {
            ((MDRChangeSource)el).addListener((MDRChangeListener)this.wPropL);
        }
    }

    protected final Node[] createNodes(Object key) {
        Node[] nodes;
        if (key instanceof Node) {
            nodes = new Node[]{new FilterNode((Node)key)};
        } else if (key instanceof Node[]) {
            Node[] ns = (Node[])key;
            nodes = new Node[ns.length];
            for (int i = 0; i < ns.length; ++i) {
                Node orig = ns[i];
                nodes[i] = orig == null ? orig : new FilterNode(orig);
            }
        } else {
            nodes = new Node[]{this.factory.createErrorNode()};
            ErrorManager.getDefault().notify(16, (Throwable)new IllegalStateException("key: " + key));
        }
        return nodes;
    }

    protected Node[] createNodesImpl(Object key) throws JmiException {
        Node n;
        if (key instanceof Method) {
            Method m = (Method)key;
            this.hookNodeName((Element)m);
            n = this.factory.createMethodNode(m);
        } else if (key instanceof Field) {
            Field f = (Field)key;
            this.hookNodeName((Element)f);
            n = this.factory.createFieldNode(f);
        } else if (key instanceof Constructor) {
            n = this.factory.createConstructorNode((Constructor)key);
        } else if (key instanceof JavaEnum) {
            JavaEnum en = (JavaEnum)key;
            this.hookNodeName((Element)en);
            n = this.factory.createEnumNode(en);
        } else if (key instanceof AnnotationType) {
            AnnotationType at = (AnnotationType)key;
            this.hookNodeName((Element)at);
            n = this.factory.createAnnotationTypeNode(at);
        } else if (key instanceof JavaClass) {
            JavaClass jc = (JavaClass)key;
            this.hookNodeName((Element)jc);
            n = this.factory.createClassNode(jc);
        } else {
            n = key instanceof Initializer ? this.factory.createInitializerNode((Initializer)key) : this.factory.createErrorNode();
        }
        return new Node[]{n};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List collectKeys() {
        List keys = new LinkedList();
        int[] order = this.getOrder();
        try {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                if (!this.element.isValid()) {
                    List list = keys;
                    return list;
                }
                List features = this.element.getFeatures();
                ArrayList members = new ArrayList(features.size());
                this.filterModifiers(features, members);
                int i = 0;
                while (i < order.length) {
                    List keysOfType = this.getKeysOfType(members, order[i]);
                    if (this.filter == null || this.filter.isSorted()) {
                        Collections.sort(keysOfType, comparator);
                    }
                    keys.addAll(keysOfType);
                    ++i;
                }
                return keys;
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }
        catch (InvalidObjectException ex) {
            return Collections.EMPTY_LIST;
        }
        catch (JmiException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
        }
        return keys;
    }

    public Node[] prepareNodes(Object key) {
        return this.createNodesImpl(key);
    }

    public void presentKeys(List keys, List nodes) {
        JMIElementListener l = this.wPropL;
        if (l != null) {
            l.updateElements(keys);
        }
        this.setKeys(nodes);
    }

    public Node[] getNodes(boolean optimalResult) {
        if (!optimalResult) {
            return this.getNodes();
        }
        this.chprovider.waitFinished();
        return this.getNodes();
    }

    public Node findChild(String name) {
        Node n = super.findChild(name);
        if (n == null) {
            this.chprovider.waitFinished();
            n = super.findChild(name);
        }
        return n;
    }

    protected void refreshAllKeys() {
        this.refreshKeys(1023);
    }

    protected final void refreshKeys(int filter) {
        if (!this.doRefresh(filter)) {
            return;
        }
        this.chprovider.recomputeChildren();
    }

    private boolean doRefresh(int filter) {
        int[] order = this.getOrder();
        for (int i = order.length - 1; i >= 0; --i) {
            if ((order[i] & filter) == 0) continue;
            return true;
        }
        return false;
    }

    protected List getKeysOfType(Collection elements, int elementType) {
        LinkedList<Object> keys = new LinkedList<Object>();
        if ((elementType & 0x100) != 0) {
            keys.add(this.element.getSuperClass());
        }
        if ((elementType & 0x200) != 0) {
            keys.addAll(this.element.getInterfaces());
        }
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Object member = it.next();
            if ((elementType & 0x40) != 0 && member instanceof Field && !(member instanceof EnumConstant)) {
                keys.add(member);
            } else if ((elementType & 0x20) != 0 && (member instanceof Constructor || member instanceof Initializer)) {
                keys.add(member);
            } else if ((elementType & 0x80) != 0 && member instanceof Method) {
                keys.add(member);
            }
            if (!(member instanceof JavaClass)) continue;
            boolean isInterface = ((JavaClass)member).isInterface();
            if ((elementType & 2) != 0 && !isInterface) {
                keys.add(member);
                continue;
            }
            if ((elementType & 4) == 0 || !isInterface) continue;
            keys.add(member);
        }
        return keys;
    }

    protected int[] getOrder() {
        return this.filter == null || this.filter.getOrder() == null ? ClassElementFilter.DEFAULT_ORDER : this.filter.getOrder();
    }

    private int getModifierFilter() {
        if (this.filter == null) {
            return 65543;
        }
        return this.filter.getModifiers();
    }

    private void filterModifiers(Collection elements, Collection keys) {
        int ff = this.getModifierFilter();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            ClassMember element = (ClassMember)it.next();
            int f = element.getModifiers();
            if ((f & PPP_MASK) == 0) {
                f += 65536;
            }
            if ((f & ff) == 0) continue;
            keys.add(element);
        }
    }

    static {
        comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof NamedElement) {
                    if (o2 instanceof NamedElement) {
                        String o1Name = this.getName((NamedElement)o1);
                        String o2Name = this.getName((NamedElement)o2);
                        if (o1Name == null || o2Name == null) {
                            return 1;
                        }
                        return o1Name.compareToIgnoreCase(o2Name);
                    }
                    return -1;
                }
                if (o2 instanceof NamedElement) {
                    return 1;
                }
                return 0;
            }

            private String getName(NamedElement el) {
                String name = el instanceof Constructor ? ((Constructor)el).getDeclaringClass().getName() : (el instanceof Initializer ? "" : el.getName());
                return name;
            }
        };
        propToFilter = new HashMap();
        propToFilter.put("classes", new Integer(6));
        propToFilter.put("methods", new Integer(128));
        propToFilter.put("fields", new Integer(64));
        propToFilter.put("constructors", new Integer(32));
        propToFilter.put("initializers", new Integer(32));
    }

    private static final class JMIElementListener
    extends WeakReference
    implements Runnable,
    MDRChangeListener {
        Collection elements;
        MDRChangeSource celem;

        JMIElementListener(ClassChildren cc) {
            super(cc, Utilities.activeReferenceQueue());
            this.celem = (MDRChangeSource)cc.element;
        }

        ClassChildren getClassChildren() {
            Object o = this.get();
            return (ClassChildren)o;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void change(MDRChangeEvent e) {
            int filter;
            Object src = e.getSource();
            if (src instanceof Element && !((Element)src).isValid()) {
                return;
            }
            ClassChildren cc = this.getClassChildren();
            if (cc == null || !(e instanceof AttributeEvent)) {
                return;
            }
            AttributeEvent evt = (AttributeEvent)e;
            String propName = evt.getAttributeName();
            if (src != cc.element) {
                if (!(src instanceof Element) || propName != null && "name" != propName) return;
                filter = this.chooseFilter((Element)src);
            } else if ("contents".equals(propName)) {
                Element cm = (Element)evt.getOldElement();
                cm = cm == null ? (Element)evt.getNewElement() : cm;
                filter = this.chooseFilter(cm);
            } else {
                if (!"constants".equals(propName)) return;
                filter = 1024;
            }
            if (!cc.nodesInited) return;
            cc.refreshKeys(filter);
        }

        int chooseFilter(Element src) {
            int filter = src instanceof Method ? 128 : (src instanceof Constructor || src instanceof Initializer ? 32 : (src instanceof Field ? 64 : (src instanceof EnumConstant ? 1024 : (src instanceof Attribute ? 1024 : 30))));
            return filter;
        }

        void updateElements(Collection c) {
            Collection old = this.elements;
            if (old != null) {
                old.removeAll(c);
                this.removeListeners(old);
            }
            this.elements = c;
        }

        public void run() {
            this.celem.removeListener((MDRChangeListener)this);
            this.removeListeners(this.elements);
        }

        private void removeListeners(Collection c) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof MDRChangeSource)) continue;
                MDRChangeSource el = (MDRChangeSource)o;
                el.removeListener((MDRChangeListener)this);
            }
        }
    }
}

