/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.jmi.reflect.JmiException;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.java.ui.nodes.elements.IconResolver;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

public final class ConstructorNode
extends ElementNode {
    private static final Map mapAttributeName = new HashMap();

    public ConstructorNode(Constructor element, boolean writeable) {
        super((Element)element, Children.LEAF, writeable);
        this.setElementFormat0(this.getElementFormatProperty());
        this.superSetName(((JavaClass)element.getDeclaringClass()).getSimpleName());
        NameListener.getInstance(this, element);
    }

    protected String resolveIconBase() {
        return IconResolver.getIconBaseForConstructor(this.getConstructor());
    }

    protected ElementFormat getElementFormatProperty() {
        return ConstructorNode.getSourceOptions().getConstructorElementFormat();
    }

    protected ElementFormat getHintElementFormat() {
        return ConstructorNode.getSourceOptions().getConstructorElementLongFormat();
    }

    protected Map getAttributeNameMap() {
        return mapAttributeName;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createModifiersProperty(this.writeable));
        ps.put(this.createNameProperty());
        ps.put(this.createParametersProperty(false));
        ps.put(this.createExceptionsProperty(this.writeable));
        return sheet;
    }

    public boolean canRename() {
        return false;
    }

    private Node.Property createNameProperty() {
        return new ElementNode.ElementProp("name", String.class, false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getValue() throws IllegalAccessException, InvocationTargetException {
                String string;
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    String name;
                    ClassDefinition cd = ConstructorNode.this.getConstructor().getDeclaringClass();
                    string = name = cd instanceof JavaClass ? ((JavaClass)cd).getSimpleName() : cd.getName();
                }
                catch (Throwable throwable) {
                    try {
                        JavaMetamodel.getDefaultRepository().endTrans();
                        throw throwable;
                    }
                    catch (JmiException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                JavaMetamodel.getDefaultRepository().endTrans();
                return string;
            }
        };
    }

    private Node.Property createParametersProperty(boolean canW) {
        Node.Property p = ConstructorNode.createParametersProperty((CallableFeature)this.getConstructor(), canW);
        p.setValue("changeImmediate", (Object)Boolean.FALSE);
        return p;
    }

    private Node.Property createExceptionsProperty(boolean canW) {
        Node.Property p = ConstructorNode.createExceptionsProperty((CallableFeature)this.getConstructor(), canW);
        p.setValue("changeImmediate", (Object)Boolean.FALSE);
        return p;
    }

    private Constructor getConstructor() {
        return (Constructor)this.element;
    }

    static {
        mapAttributeName.put("modifiers", "modifiers");
        mapAttributeName.put("name", "name");
        mapAttributeName.put("parameters", "parameters");
        mapAttributeName.put("exceptionNames", "exceptions");
    }

    private static final class NameListener
    extends WeakReference
    implements MDRChangeListener,
    Runnable {
        private final JavaClass declClass;

        public static NameListener getInstance(ConstructorNode node, Constructor c) {
            JavaClass cd = (JavaClass)c.getDeclaringClass();
            MDRChangeSource source = (MDRChangeSource)cd;
            NameListener l = new NameListener(node, cd);
            source.addListener((MDRChangeListener)l, 0x101FFFF);
            return l;
        }

        private NameListener(ConstructorNode referent, JavaClass declClass) {
            super(referent, Utilities.activeReferenceQueue());
            this.declClass = declClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void change(MDRChangeEvent e) {
            if (!(e instanceof AttributeEvent)) {
                return;
            }
            final ConstructorNode node = (ConstructorNode)this.get();
            AttributeEvent ae = (AttributeEvent)e;
            String attrName = ae.getAttributeName();
            ElementFormat format = null;
            if (node != null && (attrName == null || "name".equals(attrName)) && (format = node.getElementFormat()).dependsOnProperty(attrName)) {
                final String[] names = new String[2];
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    try {
                        if (this.declClass.isValid()) {
                            names[0] = format.format(node.element);
                            names[1] = this.declClass.getSimpleName();
                        }
                    }
                    finally {
                        JavaMetamodel.getDefaultRepository().endTrans();
                    }
                }
                catch (JmiException ex) {
                    ErrorManager.getDefault().notify(16, (Throwable)ex);
                }
                if (names[0] != null) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            node.setDisplayName(names[0]);
                            node.superSetName(names[1]);
                            node.superPropertyChange("name", null, null);
                        }
                    });
                }
            }
        }

        public void run() {
            ((MDRChangeSource)this.declClass).removeListener((MDRChangeListener)this);
        }
    }
}

