/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.common.DatasourceCustomizer;
import org.netbeans.modules.j2ee.common.EventRequestProcessor;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatasourceUIHelper {
    static final Separator SEPARATOR_ITEM = new Separator();
    static final Object NEW_ITEM = new Object(){

        public String toString() {
            return NbBundle.getMessage(DatasourceUIHelper.class, (String)"LBL_NEW_DATASOURCE");
        }
    };

    private DatasourceUIHelper() {
    }

    public static void connect(J2eeModuleProvider provider, JComboBox combo) {
        DatasourceUIHelper.connect(provider, combo, null);
    }

    private static final void connect(final J2eeModuleProvider provider, final JComboBox combo, Datasource selectedDatasource) {
        assert (provider != null);
        combo.setEditor(new DatasourceComboBoxEditor(combo.getEditor()));
        combo.setRenderer(new DatasourceListCellRenderer());
        ArrayList<EventRequestProcessor.Action> actions = new ArrayList<EventRequestProcessor.Action>();
        final List[] datasources = new List[1];
        actions.add(new EventRequestProcessor.AsynchronousAction(){

            public void run(EventRequestProcessor.Context actionContext) {
                String msg = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_retrievingDS");
                actionContext.getProgress().progress(msg);
                datasources[0] = DatasourceUIHelper.getDatasources(provider);
            }
        });
        EventRequestProcessor eventRP = new EventRequestProcessor();
        eventRP.invoke(actions);
        DatasourceUIHelper.populate(datasources[0], provider.isDatasourceCreationSupported(), combo, selectedDatasource, false);
        JComboBox toListenOn = combo.isEditable() ? combo.getEditor().getEditorComponent() : combo;
        toListenOn.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object selectedItem;
                int keyCode = e.getKeyCode();
                if (10 == keyCode && (selectedItem = combo.getSelectedItem()) == NEW_ITEM) {
                    DatasourceUIHelper.performCreateDatasource(provider, combo, false);
                    e.consume();
                }
            }
        });
        combo.addActionListener(new ActionListener(){
            Object previousItem;
            int previousIndex;
            {
                this.previousIndex = combo.getSelectedIndex();
            }

            public void actionPerformed(ActionEvent e) {
                Object selectedItem = combo.getSelectedItem();
                if (selectedItem == SEPARATOR_ITEM) {
                    int selectedIndex = combo.getSelectedIndex();
                    if (selectedIndex > this.previousIndex) {
                        this.previousIndex = selectedIndex + 1;
                        this.previousItem = combo.getItemAt(this.previousIndex);
                    } else {
                        this.previousIndex = selectedIndex - 1;
                        this.previousItem = combo.getItemAt(this.previousIndex);
                    }
                    combo.setSelectedItem(this.previousItem);
                } else if ((e.getModifiers() & 0x10) != 0 && selectedItem == NEW_ITEM) {
                    DatasourceUIHelper.performCreateDatasource(provider, combo, true);
                }
            }
        });
    }

    private static void performCreateDatasource(final J2eeModuleProvider provider, final JComboBox combo, boolean selectItemLater) {
        final DatasourceComboBoxModel model = (DatasourceComboBoxModel)combo.getModel();
        DatasourceCustomizer dsc = new DatasourceCustomizer(model.getDatasources());
        boolean accept = dsc.showDialog();
        ArrayList<EventRequestProcessor.Action> actions = new ArrayList<EventRequestProcessor.Action>();
        final Datasource[] ds = new Datasource[1];
        if (accept) {
            final String password = dsc.getPassword();
            final String jndiName = dsc.getJndiName();
            final String url = dsc.getUrl();
            final String username = dsc.getUsername();
            final String driverClassName = dsc.getDriverClassName();
            actions.add(new EventRequestProcessor.AsynchronousAction(){

                public void run(EventRequestProcessor.Context actionContext) {
                    String msg = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_creatingDS");
                    actionContext.getProgress().progress(msg);
                    try {
                        ds[0] = provider.createDatasource(jndiName, url, username, password, driverClassName);
                    }
                    catch (DatasourceAlreadyExistsException daee) {
                        StringBuilder sb = new StringBuilder();
                        for (Datasource conflict : daee.getDatasources()) {
                            sb.append(conflict.toString() + "\n");
                        }
                        ErrorManager.getDefault().annotate((Throwable)daee, NbBundle.getMessage(DatasourceUIHelper.class, (String)"ERR_DsConflict", (Object)sb.toString()));
                        ErrorManager.getDefault().notify(1, (Throwable)daee);
                    }
                }

                public boolean isEnabled() {
                    return password != null;
                }
            });
        }
        final List[] datasources = new List[1];
        actions.add(new EventRequestProcessor.AsynchronousAction(){

            public void run(EventRequestProcessor.Context actionContext) {
                String msg = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_retrievingDS");
                actionContext.getProgress().progress(msg);
                datasources[0] = DatasourceUIHelper.getDatasources(provider);
            }

            public boolean isEnabled() {
                return ds[0] != null;
            }
        });
        EventRequestProcessor eventRP = new EventRequestProcessor();
        eventRP.invoke(actions);
        combo.setPopupVisible(false);
        if (ds[0] == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DatasourceUIHelper.setSelectedItem(combo, model.getPreviousItem());
                }
            });
        } else {
            DatasourceUIHelper.populate(datasources[0], provider.isDatasourceCreationSupported(), combo, ds[0], selectItemLater);
        }
    }

    private static List<Datasource> getDatasources(J2eeModuleProvider provider) {
        Set moduleDatasources = provider.getModuleDatasources();
        Set serverDatasources = provider.getServerDatasources();
        int initSize = moduleDatasources.size() + serverDatasources.size();
        HashSet datasources = new HashSet(initSize);
        datasources.addAll(moduleDatasources);
        datasources.addAll(serverDatasources);
        ArrayList<Datasource> sortedDatasources = new ArrayList<Datasource>(datasources);
        Collections.sort(sortedDatasources, new DatasourceComparator());
        return sortedDatasources;
    }

    private static List populate(List<Datasource> datasources, boolean creationSupported, final JComboBox combo, final Datasource selectedDatasource, boolean selectItemLater) {
        LinkedList<Object> items;
        LinkedList<Object> linkedList = items = datasources == null ? new LinkedList<Object>() : new LinkedList<Datasource>(datasources);
        if (items.size() > 0) {
            items.add(SEPARATOR_ITEM);
        }
        if (creationSupported) {
            items.add(NEW_ITEM);
        }
        Object[] itemsArray = items.toArray();
        DatasourceComboBoxModel model = new DatasourceComboBoxModel(datasources, itemsArray);
        combo.setModel(model);
        if (selectedDatasource != null) {
            DatasourceUIHelper.setSelectedItem(combo, selectedDatasource);
            if (selectItemLater) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DatasourceUIHelper.setSelectedItem(combo, selectedDatasource);
                    }
                });
            }
        }
        return datasources;
    }

    private static void setSelectedItem(JComboBox combo, Object item) {
        combo.setSelectedItem(item);
        if (combo.isEditable() && combo.getEditor() != null) {
            combo.configureEditor(combo.getEditor(), combo.getSelectedItem());
        }
    }

    private static class DatasourceComboBoxEditor
    implements ComboBoxEditor {
        private ComboBoxEditor delegate;
        private Object oldValue;

        DatasourceComboBoxEditor(ComboBoxEditor delegate) {
            this.delegate = delegate;
        }

        public Component getEditorComponent() {
            return this.delegate.getEditorComponent();
        }

        public void setItem(Object anObject) {
            JTextComponent editor = this.getEditor();
            if (anObject != null) {
                String text = anObject instanceof Datasource ? ((Datasource)anObject).getJndiName() : anObject.toString();
                editor.setText(text);
                this.oldValue = anObject;
            } else {
                editor.setText("");
            }
        }

        public Object getItem() {
            JTextComponent editor = this.getEditor();
            Object newValue = editor.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (newValue.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> cls = this.oldValue.getClass();
                try {
                    Method method = cls.getMethod("valueOf", String.class);
                    newValue = method.invoke(this.oldValue, editor.getText());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return newValue;
        }

        public void selectAll() {
            this.delegate.selectAll();
        }

        public void addActionListener(ActionListener l) {
            this.delegate.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.delegate.removeActionListener(l);
        }

        private JTextComponent getEditor() {
            Component comp = this.getEditorComponent();
            assert (comp instanceof JTextComponent);
            return (JTextComponent)comp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DatasourceComparator
    implements Comparator<Datasource> {
        private DatasourceComparator() {
        }

        @Override
        public int compare(Datasource ds1, Datasource ds2) {
            if (ds1 == null) {
                return ds2 == null ? 0 : -1;
            }
            if (ds2 == null) {
                return 1;
            }
            String dispName1 = ds1.getDisplayName();
            String dispName2 = ds2.getDisplayName();
            if (dispName1 == null) {
                return dispName2 == null ? 0 : -1;
            }
            return dispName2 == null ? 1 : dispName1.compareToIgnoreCase(dispName2);
        }
    }

    private static class DatasourceListCellRenderer
    extends DefaultListCellRenderer {
        private DatasourceListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Datasource) {
                Datasource ds = (Datasource)value;
                this.setText(ds != null ? ds.getDisplayName() : "");
                this.setToolTipText(ds.toString());
            } else {
                if (value == SEPARATOR_ITEM) {
                    return SEPARATOR_ITEM;
                }
                this.setText(value != null ? value.toString() : "");
                this.setToolTipText("");
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DatasourceComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Object[] items;
        private Object selectedItem;
        private List<Datasource> datasources;
        private Object previousItem;

        private DatasourceComboBoxModel(List<Datasource> datasources, Object[] items) {
            this.datasources = datasources;
            this.items = items;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.selectedItem == null || !this.selectedItem.equals(anItem)) {
                this.previousItem = this.selectedItem;
                this.selectedItem = anItem;
                this.fireContentsChanged(this, 0, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public Object getElementAt(int index) {
            return this.items[index];
        }

        @Override
        public int getSize() {
            return this.items.length;
        }

        Object getPreviousItem() {
            return this.previousItem;
        }

        List<Datasource> getDatasources() {
            return this.datasources;
        }
    }

    private static final class Separator
    extends JSeparator {
        Separator() {
            this.setPreferredSize(new Dimension(this.getWidth(), 1));
            this.setForeground(Color.BLACK);
        }
    }
}

