/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.query.mof;

import java.util.Comparator;
import javax.jmi.model.Feature;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.model.StructuralFeature;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import org.netbeans.lib.jmi.query.Query;
import org.netbeans.lib.jmi.query.ValueFilter;

public class FeatureFilter
extends ValueFilter {
    protected String featureName;
    private Feature feature = null;
    private MofClass metaClazz = null;

    public FeatureFilter(Query query, String featureName, Object value) {
        super(query, value);
        this.featureName = featureName;
    }

    public FeatureFilter(Query query, String featureName, Object value, Comparator comparator) {
        super(query, value, comparator);
        this.featureName = featureName;
    }

    protected boolean accept(Object object) {
        if (object instanceof RefFeatured) {
            this.resolveFeature((RefFeatured)object);
            if (this.feature == null) {
                return false;
            }
            Object featureValue = ((RefFeatured)object).refGetValue((RefObject)((StructuralFeature)this.feature));
            return super.accept(featureValue);
        }
        return false;
    }

    private void resolveFeature(RefFeatured refFeatured) {
        MofClass clazz = (MofClass)refFeatured.refMetaObject();
        if (this.metaClazz == null || !this.metaClazz.equals(clazz) || this.feature != null) {
            this.metaClazz = null;
            this.feature = null;
            try {
                this.metaClazz = clazz;
                ModelElement me = clazz.lookupElementExtended(this.featureName);
                if (me instanceof Feature) {
                    this.feature = (Feature)me;
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }
}

