/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.awt.Dialog;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.RegisterDerby;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.ui.CreateDatabasePanel;
import org.netbeans.modules.derby.ui.DerbySystemHomePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class CreateDatabaseAction
extends CallableSystemAction {
    public CreateDatabaseAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        if (!Util.hasInstallLocation()) {
            Util.showInformation(NbBundle.getMessage((Class)RegisterDerby.class, (String)"MSG_DerbyLocationIncorrect"));
            return;
        }
        String derbySystemHome = DerbyOptions.getDefault().getSystemHome();
        if (derbySystemHome.length() <= 0 && (derbySystemHome = DerbySystemHomePanel.findDerbySystemHome()).length() > 0) {
            DerbyOptions.getDefault().setSystemHome(derbySystemHome);
        }
        if (derbySystemHome.length() <= 0) {
            return;
        }
        CreateDatabasePanel panel = new CreateDatabasePanel(derbySystemHome);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage((Class)CreateDatabaseAction.class, (String)"LBL_CreateDatabaseTitle"), true, null);
        panel.setDialogDescriptor(desc);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        String acsd = NbBundle.getMessage((Class)CreateDatabaseAction.class, (String)"ACSD_CreateDatabaseAction");
        dialog.getAccessibleContext().setAccessibleDescription(acsd);
        dialog.setVisible(true);
        dialog.dispose();
        if (!DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
            return;
        }
        String databaseName = panel.getDatabaseName();
        String user = panel.getUser();
        String password = panel.getPassword();
        if (user == null || password == null) {
            user = null;
            password = null;
        }
        try {
            this.makeDatabase(databaseName, user, password);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
        }
    }

    void makeDatabase(String dbname, String user, String password) throws Exception {
        RegisterDerby.getDefault().postCreateNewDatabase(dbname, user, password);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getBundle((Class)CreateDatabaseAction.class).getString("LBL_CreateDBAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateDatabaseAction.class);
    }
}

