/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.editors.ui;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class MessageArea
extends JLabel {
    private static final int WIDTH = 600;
    private static final int[] sizeMap = new int[]{8, 10, 12, 14, 18, 24, 36};
    private static final char[] hexVals = new char[]{'A', 'B', 'C', 'D', 'E', 'F'};
    private int width = 600;
    private String fontString;
    private boolean isBold;
    private boolean isItalic;
    private String msgs;
    private String msgString;
    private String endMsgs;
    private String endMsgString;
    private Vector bulletItems = new Vector();
    private String bulletItemString;

    public MessageArea() {
    }

    public MessageArea(String text) {
        this();
        this.setText(text);
    }

    public void addNotify() {
        super.addNotify();
        UIDefaults defs = UIManager.getDefaults();
        Color c = defs.getColor("OptionPane.background");
        if (c != null) {
            this.setBackground(c);
        }
        if ((c = defs.getColor("OptionPane.foreground")) != null) {
            this.setForeground(c);
        }
        if (this.fontString == null) {
            this.makeFontString(this.getFont(), this.getForeground());
        }
    }

    private void makeEntireMsg() {
        StringBuffer sbuf = new StringBuffer("<html><table width=\"" + this.width + "\"><tr>");
        if (this.fontString != null) {
            sbuf.append(this.fontString);
        }
        if (this.msgString != null) {
            sbuf.append(this.msgString);
        }
        if (this.bulletItemString != null) {
            sbuf.append(this.bulletItemString);
        }
        if (this.endMsgString != null) {
            sbuf.append(this.endMsgString);
        }
        if (this.isItalic) {
            sbuf.append("</i>");
        }
        if (this.isBold) {
            sbuf.append("</b>");
        }
        if (this.fontString != null) {
            sbuf.append("</font>");
        }
        sbuf.append("</tr></table></html>");
        super.setText(sbuf.toString());
    }

    private void makeMsgString() {
        if (this.msgs == null || this.msgs.length() < 1) {
            this.msgString = null;
        }
        this.msgString = this.msgs;
        this.makeEntireMsg();
    }

    private void makeEndMsgString() {
        if (this.endMsgs == null || this.endMsgs.length() < 1) {
            this.endMsgString = null;
        }
        this.endMsgString = this.endMsgs;
        this.makeEntireMsg();
    }

    private String toHex(int i) {
        StringBuffer sbuf = new StringBuffer();
        int val = i / 16;
        if (val > 10) {
            sbuf.append(hexVals[val - 10]);
        } else {
            sbuf.append(val);
        }
        val = i % 16;
        if (val > 10) {
            sbuf.append(hexVals[val - 10]);
        } else {
            sbuf.append(val);
        }
        return sbuf.toString();
    }

    private String indexToOffset(int idx) {
        int middle = sizeMap.length / 2;
        if (idx < middle) {
            return "-" + (middle - idx);
        }
        return "+" + (idx - middle);
    }

    private String closestSize(int ptSize) {
        if (ptSize < sizeMap[0]) {
            return this.indexToOffset(0);
        }
        if (ptSize >= sizeMap[sizeMap.length - 1]) {
            return this.indexToOffset(sizeMap.length - 1);
        }
        for (int i = 0; i < sizeMap.length - 1; ++i) {
            if (ptSize == sizeMap[i]) {
                return this.indexToOffset(i);
            }
            if (ptSize <= sizeMap[i] || ptSize >= sizeMap[i + 1]) continue;
            int diff1 = ptSize - sizeMap[i];
            int diff2 = sizeMap[i + 1] - ptSize;
            if (diff1 < diff2) {
                return this.indexToOffset(i);
            }
            return this.indexToOffset(i + 1);
        }
        return this.indexToOffset(sizeMap.length / 2);
    }

    private void makeFontString(Font f, Color c) {
        StringBuffer sbuf = new StringBuffer("<font");
        if (f != null) {
            sbuf.append(" face=");
            sbuf.append(f.getName());
            sbuf.append(" size=");
            sbuf.append(this.closestSize(f.getSize()));
        }
        if (c != null) {
            sbuf.append(" color=\"#");
            sbuf.append(this.toHex(c.getRed()));
            sbuf.append(this.toHex(c.getGreen()));
            sbuf.append(this.toHex(c.getBlue()));
            sbuf.append("\"");
        }
        sbuf.append(">");
        if (f != null) {
            if ((f.getStyle() & 1) == 1) {
                sbuf.append("<b>");
                this.isBold = true;
            }
            if ((f.getStyle() & 2) == 1) {
                sbuf.append("<i>");
                this.isItalic = true;
            }
        }
        this.fontString = sbuf.toString();
        this.makeEntireMsg();
    }

    private void makeBulletItems() {
        if (this.bulletItems.isEmpty()) {
            this.bulletItemString = null;
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<ul>");
        for (int i = 0; i < this.bulletItems.size(); ++i) {
            String s = (String)this.bulletItems.elementAt(i);
            sbuf.append("<li>" + s + "</li>");
        }
        sbuf.append("</ul>");
        this.bulletItemString = sbuf.toString();
        this.makeEntireMsg();
    }

    public void setWidth(int wid) {
        this.width = wid;
        this.makeEntireMsg();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.makeFontString(f, this.getForeground());
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.makeFontString(this.getFont(), c);
    }

    private void tokenizeString(String s, Vector v) {
        StringTokenizer st = new StringTokenizer(s, "\n");
        if (st.countTokens() > 1) {
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
        } else {
            v.add(s);
        }
    }

    public void setText(String s) {
        this.msgs = s.replace('\n', ' ');
        this.makeMsgString();
    }

    public void setEndText(String s) {
        this.endMsgs = s.replace('\n', ' ');
        this.makeEndMsgString();
    }

    public void appendText(String s) {
        String noNewLine = s.replace('\n', ' ');
        this.msgs = this.msgs.concat(noNewLine);
        this.makeMsgString();
    }

    public void setBulletItems(String s) {
        this.bulletItems.clear();
        this.tokenizeString(s, this.bulletItems);
        this.makeBulletItems();
    }

    public void setBulletItems(List l) {
        this.bulletItems.clear();
        this.bulletItems.addAll(l);
        this.makeBulletItems();
    }

    public void setBulletItems(String[] s) {
        this.bulletItems.clear();
        for (int i = 0; i < s.length; ++i) {
            this.bulletItems.add(s[i]);
        }
        this.makeBulletItems();
    }

    public void appendBulletItem(String s) {
        this.tokenizeString(s, this.bulletItems);
        this.makeBulletItems();
    }

    public void appendBulletItems(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.bulletItems.add(s[i]);
        }
        this.makeBulletItems();
    }

    public void appendBulletItems(List l) {
        this.bulletItems.addAll(l);
        this.makeBulletItems();
    }
}

