/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public final class Branding
extends Task {
    private File cluster;
    private File overrides;
    private String token;

    public void setCluster(File cluster) {
        this.cluster = cluster;
    }

    public void setOverrides(File overrides) {
        this.overrides = overrides;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void execute() throws BuildException {
        if (this.cluster == null || !this.cluster.isDirectory()) {
            throw new BuildException("Must specify a valid cluster directory", this.getLocation());
        }
        if (this.overrides == null || !this.overrides.isDirectory()) {
            throw new BuildException("Must specify a valid overrides directory", this.getLocation());
        }
        if (this.token == null || !this.token.matches("[a-z][a-z0-9]*(_[a-z][a-z0-9]*)*")) {
            throw new BuildException("Must specify a valid branding token: " + this.token, this.getLocation());
        }
        try {
            this.lookForBrandingJars(this.overrides, this.cluster, this.overrides.getAbsolutePath() + File.separatorChar);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    private boolean excluded(File f, String prefix) {
        String pathAbs = f.getAbsolutePath();
        if (!pathAbs.startsWith(prefix)) {
            throw new BuildException("Examined file " + f + " should have a path starting with " + prefix, this.getLocation());
        }
        String path = pathAbs.substring(prefix.length());
        String[] excludes = DirectoryScanner.getDefaultExcludes();
        for (int i = 0; i < excludes.length; ++i) {
            if (!SelectorUtils.matchPath((String)excludes[i], (String)path)) continue;
            return true;
        }
        return false;
    }

    private boolean lookForBrandingJars(File srcDir, File destDir, String srcPrefix) throws IOException {
        if (srcDir.getName().endsWith(".jar")) {
            this.packBrandingJar(srcDir, destDir);
            return true;
        }
        String[] kids = srcDir.list();
        if (kids == null) {
            throw new IOException("Could not list children of " + srcDir);
        }
        boolean used = false;
        for (int i = 0; i < kids.length; ++i) {
            File kid = new File(srcDir, kids[i]);
            if (this.excluded(kid, srcPrefix)) continue;
            if (!kid.isDirectory()) {
                this.log("Warning: stray file " + kid + " encountered; ignoring", 1);
                continue;
            }
            used |= this.lookForBrandingJars(kid, new File(destDir, kids[i]), srcPrefix);
        }
        if (!used) {
            this.log("Warning: stray directory " + srcDir + " with no brandables encountered; ignoring", 1);
        }
        return used;
    }

    private void packBrandingJar(File srcDir, File destJarBase) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(srcDir);
        scanner.addDefaultExcludes();
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        Zip zip = (Zip)this.getProject().createTask("zip");
        String name = destJarBase.getName();
        String nameBase = name.substring(0, name.length() - ".jar".length());
        File destFolder = new File(destJarBase.getParentFile(), "locale");
        if (!destFolder.isDirectory() && !destFolder.mkdirs()) {
            throw new IOException("Could not create directory " + destFolder);
        }
        File destJar = new File(destFolder, nameBase + "_" + this.token + ".jar");
        zip.setDestFile(destJar);
        zip.setCompress(true);
        for (int i = 0; i < files.length; ++i) {
            ZipFileSet entry = new ZipFileSet();
            entry.setFile(new File(srcDir, files[i]));
            String basePath = files[i].replace(File.separatorChar, '/');
            int slash = basePath.lastIndexOf(47);
            int dot = basePath.lastIndexOf(46);
            String infix = "_" + this.token;
            String brandedPath = dot == -1 || dot < slash ? basePath + infix : basePath.substring(0, dot) + infix + basePath.substring(dot);
            entry.setFullpath(brandedPath);
            zip.addZipfileset(entry);
        }
        zip.setLocation(this.getLocation());
        zip.init();
        zip.execute();
    }
}

