/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.logging;

import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.logging.Level;

public class LoggerJDK14
extends java.util.logging.Logger
implements Logger {
    protected String sourceClassName;
    protected String sourceMethodName;

    public LoggerJDK14(String loggerName, String bundleName) {
        super(loggerName, bundleName);
    }

    public boolean isLoggable() {
        return this.isLoggable(Level.FINE);
    }

    public void fine(String msg, Object[] o) {
        if (this.isLoggable(Level.FINE)) {
            this.inferCaller();
            this.logp(Level.FINE, this.sourceClassName, this.sourceMethodName, msg, o);
        }
    }

    public void fine(String msg, Object o1) {
        if (this.isLoggable(Level.FINE)) {
            this.inferCaller();
            this.logp(Level.FINE, this.sourceClassName, this.sourceMethodName, msg, o1);
        }
    }

    public void fine(String msg, Object o1, Object o2) {
        if (this.isLoggable(Level.FINE)) {
            this.inferCaller();
            this.logp(Level.FINE, this.sourceClassName, this.sourceMethodName, msg, new Object[]{o1, o2});
        }
    }

    public void fine(String msg, Object o1, Object o2, Object o3) {
        if (this.isLoggable(Level.FINE)) {
            this.inferCaller();
            this.logp(Level.FINE, this.sourceClassName, this.sourceMethodName, msg, new Object[]{o1, o2, o3});
        }
    }

    public void finer(String msg, Object[] o) {
        if (this.isLoggable(Level.FINER)) {
            this.inferCaller();
            this.logp(Level.FINER, this.sourceClassName, this.sourceMethodName, msg, o);
        }
    }

    public void finer(String msg, Object o1) {
        if (this.isLoggable(Level.FINER)) {
            this.inferCaller();
            this.logp(Level.FINER, this.sourceClassName, this.sourceMethodName, msg, o1);
        }
    }

    public void finer(String msg, Object o1, Object o2) {
        if (this.isLoggable(Level.FINER)) {
            this.inferCaller();
            this.logp(Level.FINER, this.sourceClassName, this.sourceMethodName, msg, new Object[]{o1, o2});
        }
    }

    public void finer(String msg, Object o1, Object o2, Object o3) {
        if (this.isLoggable(Level.FINER)) {
            this.inferCaller();
            this.logp(Level.FINER, this.sourceClassName, this.sourceMethodName, msg, new Object[]{o1, o2, o3});
        }
    }

    public void finest(String msg, Object[] o) {
        if (this.isLoggable(Level.FINEST)) {
            this.inferCaller();
            this.logp(Level.FINEST, this.sourceClassName, this.sourceMethodName, msg, o);
        }
    }

    public void finest(String msg, Object o1) {
        if (this.isLoggable(Level.FINEST)) {
            this.inferCaller();
            this.logp(Level.FINEST, this.sourceClassName, this.sourceMethodName, msg, o1);
        }
    }

    public void finest(String msg, Object o1, Object o2) {
        if (this.isLoggable(Level.FINEST)) {
            this.inferCaller();
            this.logp(Level.FINEST, this.sourceClassName, this.sourceMethodName, msg, new Object[]{o1, o2});
        }
    }

    public void finest(String msg, Object o1, Object o2, Object o3) {
        if (this.isLoggable(Level.FINEST)) {
            this.inferCaller();
            this.logp(Level.FINEST, this.sourceClassName, this.sourceMethodName, msg, new Object[]{o1, o2, o3});
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("LoggerJDK14: ");
        buf.append(" name: ");
        buf.append(this.getName());
        buf.append(", super: ");
        buf.append(super.toString());
        buf.append(", logging level: ");
        buf.append(this.getLevel());
        return buf.toString();
    }

    public void log(int level, String msg, Object o1) {
        Level lvl = this.convertLevel(level);
        if (this.isLoggable(lvl)) {
            this.inferCaller();
            this.logp(lvl, this.sourceClassName, this.sourceMethodName, msg, o1);
        }
    }

    public void log(int level, String msg, Object o1, Object o2) {
        Level lvl = this.convertLevel(level);
        if (this.isLoggable(lvl)) {
            this.inferCaller();
            this.logp(lvl, this.sourceClassName, this.sourceMethodName, msg, new Object[]{o1, o2});
        }
    }

    public void log(int level, String msg, Object o1, Object o2, Object o3) {
        Level lvl = this.convertLevel(level);
        if (this.isLoggable(lvl)) {
            this.inferCaller();
            this.logp(lvl, this.sourceClassName, this.sourceMethodName, msg, new Object[]{o1, o2, o3});
        }
    }

    public void log(int level, String msg, Object[] o) {
        Level lvl = this.convertLevel(level);
        if (this.isLoggable(lvl)) {
            this.inferCaller();
            this.logp(lvl, this.sourceClassName, this.sourceMethodName, msg, o);
        }
    }

    public void log(int level, String msg) {
        Level lvl = this.convertLevel(level);
        if (this.isLoggable(lvl)) {
            this.inferCaller();
            this.logp(lvl, this.sourceClassName, this.sourceMethodName, msg);
        }
    }

    public void log(int level, String msg, Throwable thrown) {
        Level lvl = this.convertLevel(level);
        if (this.isLoggable(lvl)) {
            this.inferCaller();
            this.logp(lvl, this.sourceClassName, this.sourceMethodName, msg, thrown);
        }
    }

    public boolean isLoggable(int levelValue) {
        return this.isLoggable(this.convertLevel(levelValue));
    }

    protected Level convertLevel(int level) {
        int index = level / 100;
        switch (index) {
            case 3: {
                return Level.FINEST;
            }
            case 4: {
                return Level.FINER;
            }
            case 5: {
                return Level.FINE;
            }
            case 7: {
                return Level.CONFIG;
            }
            case 8: {
                return Level.INFO;
            }
            case 9: {
                return Level.WARNING;
            }
            case 10: {
                return Level.SEVERE;
            }
        }
        return Level.CONFIG;
    }

    protected void inferCaller() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int ix = 0; ix < stack.length; ++ix) {
            StackTraceElement frame = stack[ix];
            String cname = frame.getClassName();
            if (this.isLoggerClass(cname)) continue;
            this.sourceClassName = cname;
            this.sourceMethodName = frame.getMethodName();
            return;
        }
    }

    protected boolean isLoggerClass(String className) {
        return "com.sun.jdo.spi.persistence.utility.logging.LoggerJDK14".equals(className);
    }
}

