/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.ErrorManager;

public abstract class AbstractOutputPane
extends JScrollPane
implements DocumentListener,
MouseListener,
MouseMotionListener,
KeyListener,
ChangeListener,
MouseWheelListener,
Runnable {
    private boolean locked = true;
    private int fontHeight = -1;
    private int fontWidth = -1;
    protected JEditorPane textView = this.createTextView();
    int lastCaretLine = 0;
    boolean hadSelection = false;
    boolean recentlyReset = false;
    private boolean enqueued = false;
    private int lastLength = -1;
    private int pendingCaretLine = -1;
    private boolean pendingCaretSelect = false;
    private boolean inSendCaretToLine = false;
    private int mouseLine = -1;

    public AbstractOutputPane() {
        this.init();
    }

    public void requestFocus() {
        this.textView.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.textView.requestFocusInWindow();
    }

    protected abstract JEditorPane createTextView();

    protected void documentChanged() {
        this.lastLength = -1;
        if (this.pendingCaretLine != -1) {
            if (!this.sendCaretToLine(this.pendingCaretLine, this.pendingCaretSelect)) {
                this.ensureCaretPosition();
            }
        } else {
            this.ensureCaretPosition();
        }
        if (this.recentlyReset && this.isShowing()) {
            this.recentlyReset = false;
        }
        if (this.locked) {
            this.setMouseLine(-1);
        }
        if (this.isWrapped()) {
            this.getViewport().revalidate();
            this.getViewport().repaint();
        }
    }

    public abstract boolean isWrapped();

    public abstract void setWrapped(boolean var1);

    public boolean hasSelection() {
        return this.textView.getSelectionStart() != this.textView.getSelectionEnd();
    }

    boolean isScrollLocked() {
        return this.locked;
    }

    public final void ensureCaretPosition() {
        if (this.locked && !this.enqueued) {
            SwingUtilities.invokeLater(this);
            this.enqueued = true;
        }
    }

    public void run() {
        this.enqueued = false;
        this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getModel().getMaximum());
        this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getModel().getMinimum());
    }

    public int getSelectionStart() {
        return this.textView.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textView.getSelectionEnd();
    }

    public void setSelection(int start, int end) {
        int rend;
        int rstart = Math.min(start, end);
        if (rstart == (rend = Math.max(start, end))) {
            this.getCaret().setDot(rstart);
        } else {
            this.textView.setSelectionStart(rstart);
            this.textView.setSelectionEnd(rend);
        }
    }

    public void selectAll() {
        this.unlockScroll();
        this.getCaret().setVisible(true);
        this.textView.setSelectionStart(0);
        this.textView.setSelectionEnd(this.getLength());
    }

    public boolean isAllSelected() {
        return this.textView.getSelectionStart() == 0 && this.textView.getSelectionEnd() == this.getLength();
    }

    protected void init() {
        Font f;
        this.setViewportView(this.textView);
        this.textView.setEditable(false);
        this.textView.addMouseListener(this);
        this.textView.addMouseWheelListener(this);
        this.textView.addMouseMotionListener(this);
        this.textView.addKeyListener(this);
        this.textView.setCaret(new OCaret());
        this.getCaret().setVisible(true);
        this.getCaret().setBlinkRate(0);
        this.getCaret().setSelectionVisible(true);
        this.getVerticalScrollBar().getModel().addChangeListener(this);
        this.getVerticalScrollBar().addMouseMotionListener(this);
        this.getViewport().addMouseListener(this);
        this.getVerticalScrollBar().addMouseListener(this);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(22);
        this.addMouseListener(this);
        this.getCaret().addChangeListener(this);
        Integer i = (Integer)UIManager.get("customFontSize");
        int size = i != null ? i : ((f = (Font)UIManager.get("controlFont")) != null ? f.getSize() : 11);
        this.textView.setFont(new Font("Monospaced", 0, size));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportBorder(BorderFactory.createEmptyBorder());
        Color c = UIManager.getColor("nb.output.selectionBackground");
        if (c != null) {
            this.textView.setSelectionColor(c);
        }
    }

    public final Document getDocument() {
        return this.textView.getDocument();
    }

    public final JTextComponent getTextView() {
        return this.textView;
    }

    public final void copy() {
        if (this.getCaret().getDot() != this.getCaret().getMark()) {
            this.textView.copy();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected void setDocument(Document doc) {
        if (this.hasSelection()) {
            this.hasSelectionChanged(false);
        }
        this.hadSelection = false;
        this.lastCaretLine = 0;
        this.lastLength = -1;
        Document old = this.textView.getDocument();
        old.removeDocumentListener(this);
        if (doc != null) {
            this.textView.setDocument(doc);
            doc.addDocumentListener(this);
            this.lockScroll();
            this.recentlyReset = true;
            this.pendingCaretLine = -1;
        } else {
            this.textView.setDocument(new PlainDocument());
            this.textView.setEditorKit(new DefaultEditorKit());
        }
    }

    protected void setEditorKit(EditorKit kit) {
        Document doc = this.textView.getDocument();
        this.textView.setEditorKit(kit);
        this.textView.setDocument(doc);
        this.updateKeyBindings();
        this.getCaret().setVisible(true);
        this.getCaret().setBlinkRate(0);
    }

    protected final void updateKeyBindings() {
        Keymap keymap = this.textView.getKeymap();
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(27, 0));
    }

    protected EditorKit getEditorKit() {
        return this.textView.getEditorKit();
    }

    public final int getLineCount() {
        return this.textView.getDocument().getDefaultRootElement().getElementCount();
    }

    public final int getLength() {
        if (this.lastLength == -1) {
            this.lastLength = this.textView.getDocument().getLength();
        }
        return this.lastLength;
    }

    public final boolean sendCaretToLine(int idx, boolean select) {
        int count = this.getLineCount();
        if (count - idx < 3) {
            this.pendingCaretLine = idx;
            this.pendingCaretSelect = select;
            return false;
        }
        this.inSendCaretToLine = true;
        this.pendingCaretLine = -1;
        this.unlockScroll();
        this.getCaret().setVisible(true);
        this.getCaret().setSelectionVisible(true);
        Element el = this.textView.getDocument().getDefaultRootElement().getElement(Math.min(idx, this.getLineCount() - 1));
        int position = el.getStartOffset();
        if (select) {
            this.getCaret().setDot(el.getEndOffset() - 1);
            this.getCaret().moveDot(position);
            this.getCaret().setSelectionVisible(true);
            this.textView.repaint();
        } else {
            this.getCaret().setDot(position);
        }
        if (idx + 3 < this.getLineCount()) {
            try {
                Rectangle r = this.textView.modelToView(this.textView.getDocument().getDefaultRootElement().getElement(idx + 3).getStartOffset());
                if (r != null) {
                    this.textView.scrollRectToVisible(r);
                }
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
        }
        this.inSendCaretToLine = false;
        return true;
    }

    public final void lockScroll() {
        if (!this.locked) {
            this.locked = true;
        }
    }

    public final void unlockScroll() {
        if (this.locked) {
            this.locked = false;
        }
    }

    protected abstract void caretEnteredLine(int var1);

    protected abstract void lineClicked(int var1, Point var2);

    protected abstract void postPopupMenu(Point var1, Component var2);

    public final int getCaretLine() {
        int result = -1;
        int charPos = this.getCaret().getDot();
        if (charPos > 0) {
            result = this.textView.getDocument().getDefaultRootElement().getElementIndex(charPos);
        }
        return result;
    }

    public final int getCaretPos() {
        return this.getCaret().getDot();
    }

    public final void paint(Graphics g) {
        if (this.fontHeight == -1) {
            this.fontHeight = g.getFontMetrics(this.textView.getFont()).getHeight();
            this.fontWidth = g.getFontMetrics(this.textView.getFont()).charWidth('m');
        }
        super.paint(g);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JViewport) {
            if (this.locked) {
                this.ensureCaretPosition();
            }
        } else if (e.getSource() == this.getVerticalScrollBar().getModel()) {
            BoundedRangeModel mdl;
            if (!this.locked && (mdl = this.getVerticalScrollBar().getModel()).getValue() + mdl.getExtent() == mdl.getMaximum()) {
                this.lockScroll();
            }
        } else {
            boolean hasSelection;
            if (!this.locked) {
                this.maybeSendCaretEnteredLine();
            }
            boolean bl = hasSelection = this.textView.getSelectionStart() != this.textView.getSelectionEnd();
            if (hasSelection != this.hadSelection) {
                this.hadSelection = hasSelection;
                this.hasSelectionChanged(hasSelection);
            }
        }
    }

    private boolean caretLineChanged() {
        int line = this.getCaretLine();
        boolean result = line != this.lastCaretLine;
        this.lastCaretLine = line;
        return result;
    }

    private void maybeSendCaretEnteredLine() {
        if (EventQueue.getCurrentEvent() instanceof MouseEvent) {
            return;
        }
        if (!this.locked && this.caretLineChanged() && !this.inSendCaretToLine) {
            boolean sel;
            int line = this.getCaretLine();
            boolean bl = sel = this.textView.getSelectionStart() != this.textView.getSelectionEnd();
            if (line != -1 && !sel) {
                this.caretEnteredLine(this.getCaretLine());
            }
            if (sel != this.hadSelection) {
                this.hadSelection = sel;
                this.hasSelectionChanged(sel);
            }
        }
    }

    private void hasSelectionChanged(boolean sel) {
        ((AbstractOutputTab)this.getParent()).hasSelectionChanged(sel);
    }

    public final void changedUpdate(DocumentEvent e) {
        e.getLength();
        this.documentChanged();
    }

    public final void insertUpdate(DocumentEvent e) {
        e.getLength();
        this.documentChanged();
    }

    public final void removeUpdate(DocumentEvent e) {
        e.getLength();
        this.documentChanged();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.setMouseLine(-1);
    }

    public void setMouseLine(int line, Point p) {
        if (this.mouseLine != line) {
            this.mouseLine = line;
        }
    }

    public final void setMouseLine(int line) {
        this.setMouseLine(line, null);
    }

    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        int pos = this.textView.viewToModel(p);
        if (pos < this.getLength()) {
            int line = this.getDocument().getDefaultRootElement().getElementIndex(pos);
            int lineStart = this.getDocument().getDefaultRootElement().getElement(line).getStartOffset();
            int lineLength = this.getDocument().getDefaultRootElement().getElement(line).getEndOffset() - lineStart;
            try {
                boolean inLine;
                Rectangle r = this.textView.modelToView(lineStart + lineLength - 1);
                int maxX = r.x + r.width;
                boolean bl = inLine = p.x <= maxX;
                if (this.isWrapped()) {
                    Rectangle ra = this.textView.modelToView(lineStart);
                    if (ra.y <= r.y && p.y < r.y) {
                        inLine = true;
                    }
                }
                if (inLine) {
                    this.setMouseLine(line, p);
                } else {
                    this.setMouseLine(-1);
                }
            }
            catch (BadLocationException ble) {
                this.setMouseLine(-1);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        int y;
        if (e.getSource() == this.getVerticalScrollBar() && (y = e.getY()) > this.getVerticalScrollBar().getHeight()) {
            this.lockScroll();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.locked && !e.isPopupTrigger()) {
            Element el = this.getDocument().getDefaultRootElement().getElement(this.getLineCount() - 1);
            this.getCaret().setDot(el.getStartOffset());
            this.unlockScroll();
            if (e.getSource() == this.textView) {
                this.getCaret().setDot(this.textView.viewToModel(e.getPoint()));
            }
        }
        if (e.isPopupTrigger()) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this);
            this.postPopupMenu(p, this);
        }
    }

    public final void mouseReleased(MouseEvent e) {
        int line;
        int pos;
        if (e.getSource() == this.textView && SwingUtilities.isLeftMouseButton(e) && (pos = this.textView.viewToModel(e.getPoint())) != -1 && (line = this.textView.getDocument().getDefaultRootElement().getElementIndex(pos)) >= 0) {
            this.lineClicked(line, e.getPoint());
            e.consume();
        }
        if (e.isPopupTrigger()) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this);
            this.postPopupMenu(p, this);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 35) {
            this.lockScroll();
        } else {
            this.unlockScroll();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public final void mouseWheelMoved(MouseWheelEvent e) {
        BoundedRangeModel sbmodel = this.getVerticalScrollBar().getModel();
        int max = sbmodel.getMaximum();
        int range = sbmodel.getExtent();
        int currPosition = sbmodel.getValue();
        if (e.getSource() == this.textView) {
            int newPosition = Math.max(0, Math.min(sbmodel.getMaximum(), currPosition + e.getUnitsToScroll() * this.textView.getFontMetrics(this.textView.getFont()).getHeight()));
            sbmodel.setValue(newPosition);
            if (newPosition + range >= max) {
                this.lockScroll();
                return;
            }
        }
        this.unlockScroll();
    }

    Caret getCaret() {
        return this.textView.getCaret();
    }

    private class OCaret
    extends DefaultCaret {
        private OCaret() {
        }

        public void setSelectionVisible(boolean val) {
            super.setSelectionVisible(true);
            super.setBlinkRate(0);
        }

        public boolean isSelectionVisible() {
            return true;
        }

        public void setBlinkRate(int rate) {
            super.setBlinkRate(0);
        }

        public void setVisible(boolean b) {
            super.setVisible(true);
        }

        public boolean isVisible() {
            return true;
        }

        public void paint(Graphics g) {
            JEditorPane component = AbstractOutputPane.this.textView;
            if (this.isVisible() && this.y >= 0) {
                try {
                    TextUI mapper = component.getUI();
                    Rectangle r = mapper.modelToView(component, this.getDot(), Position.Bias.Forward);
                    if (r == null || r.width == 0 && r.height == 0) {
                        return;
                    }
                    if (this.width > 0 && this.height > 0 && !this._contains(r.x, r.y, r.width, r.height)) {
                        Rectangle clip = g.getClipBounds();
                        if (clip != null && !clip.contains(this)) {
                            this.repaint();
                        }
                        this.damage(r);
                    }
                    g.setColor(component.getCaretColor());
                    g.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private boolean _contains(int X, int Y, int W, int H) {
            int w = this.width;
            int h = this.height;
            if ((w | h | W | H) < 0) {
                return false;
            }
            int x = this.x;
            int y = this.y;
            if (X < x || Y < y) {
                return false;
            }
            if (W > 0) {
                w += x;
                if ((W += X) <= X) {
                    if (w >= x || W > w) {
                        return false;
                    }
                } else if (w >= x && W > w) {
                    return true;
                }
            } else if (x + w < X) {
                return false;
            }
            if (H > 0) {
                h += y;
                if ((H += Y) <= Y ? h >= y || H > h : h >= y && H > h) {
                    return false;
                }
            } else if (y + h < Y) {
                return false;
            }
            return true;
        }

        public void mouseReleased(MouseEvent e) {
            if (!e.isConsumed()) {
                super.mouseReleased(e);
            }
        }
    }
}

