/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification;

import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.Predicate;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ProblemImpl;
import org.netbeans.modules.j2ee.verification.Rule;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRule
implements Rule {
    protected List<? extends Predicate> preConditions;
    protected Predicate predicate;

    protected AbstractRule() {
        this.preConditions = Collections.emptyList();
    }

    protected AbstractRule(Predicate assertion) {
        this.predicate = assertion;
        this.preConditions = Collections.emptyList();
    }

    protected AbstractRule(Predicate assertion, List<? extends Predicate> preConditions) {
        this.predicate = assertion;
        this.preConditions = preConditions;
    }

    @Override
    public JEEVerificationProblemMark.Severity getSeverity() {
        return JEEVerificationProblemMark.Severity.ERROR;
    }

    @Override
    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx) && !this.predicate.evaluate(subject)) {
            return this.createProblem(ctx, subject);
        }
        return null;
    }

    protected Problem createProblem(ProblemFinderContext ctx, Element subject) {
        JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(ctx.getMainJavaClass());
        problemContext.setElement(subject);
        return new ProblemImpl(problemContext, NbBundle.getMessage(this.getClass(), (String)this.getMessageKey(), (Object[])this.getMessageParameters()));
    }

    protected abstract String getMessageKey();

    protected Object[] getMessageParameters() {
        return null;
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        boolean result = true;
        for (Predicate predicate : this.preConditions) {
            result = result && predicate.evaluate(subject);
        }
        return result;
    }

    @Override
    public void reset() {
    }
}

